# This configuration file gives defaults for the scripts in
# the devscripts package, as documented in the individual manpages.
# Variables defined here may be overridden by a per-user ~/.devscripts
# configuration file, which has exactly the same syntax as this file.
#
# This file is sourced by /bin/bash, and should only contain
# comment lines (beginning with a '#'), and lines of the form
# VARIABLE=value
# The value must be quoted if there are spaces in it.
# Variables corresponding to switches (on/off; yes/no) must take
# one of the values 'yes' or 'no'.
# The variable names are all of the form PROGNAME_VARNAME,
# or DEVSCRIPTS_VARNAME if they are more generally applicable.
#
# As new variables are introduced into the devscripts program, their
# descriptions and default values will be appended as comments
# to this file.

# Variables recognised as of devscripts version 2.23.4+deb12u2:

##### Package-wide variables
#
# Lists of which scripts are affected by these package-wide variables
# can be found in the devscripts.conf(5) manpage.
#
#
# Directory Name Checking
#
# Several programs check the directory name and refuse to function if
# it does not match the name of the package being worked on.  (The
# details are described in the individual manpages.)
# These two variables control this behaviour, corresponding to the
# --check-dirname-level and --check-dirname-regex command line options.
# The possible values of DEVSCRIPTS_CHECK_DIRNAME_LEVEL are:
#   0    never check the directory name
#   1    check the directory name only if the program has changed directory
#   2    always check the directory name
# The variable DEVSCRIPTS_DIRNAME_REGEXP is a Perl regex which
# defines what is considered a valid directory name for the source
# package PACKAGE; if it includes a '/', then it must match the full
# directory path, otherwise it must match the full directory name.
#
# The default settings are:
# DEVSCRIPTS_CHECK_DIRNAME_LEVEL=1
# DEVSCRIPTS_CHECK_DIRNAME_REGEX='PACKAGE(-.+)?'

##### annotate-output
#
# No variables currently

##### archpath
#
# No variables currently

##### bts
#
# Default bts show/bugs to run in offline mode?
# BTS_OFFLINE=no
#
# Cache all visited bug reports once a cache has been established
# for the first time?
# BTS_CACHE=yes
#
# How much to mirror when caching?  The minimal amount (min), the mbox
# version as well (mbox) or the whole works (full)?
# BTS_CACHE_MODE=min
#
# Always refresh the cache, even if nothing's changed?
# BTS_FORCE_REFRESH=no
#
# How do we read an mbox?  This will be split on whitespace, then
# %s is replaced by the mbox name and %% by a single %.
# BTS_MAIL_READER='mutt -f %s'
#
# What sendmail command do we use?  This will be split on whitespace.
# BTS_SENDMAIL_COMMAND='/usr/sbin/sendmail'
#
# Download only new bugs when caching?  If set to yes, don't check for
# updates in bugs we already have.
# BTS_ONLY_NEW=no
#
# Which SMTP host should be used?  Note that if both an SMTP host and
# sendmail command are specified in the configuration file(s), the SMTP
# host will be used unless overridden by --sendmail on the command line
# BTS_SMTP_HOST=reportbug.debian.org
#
# If the SMTP host specified above requires authentication, the following
# options may be used to specify the username and password to use.
# If only a username is provided then the password will be prompted for
# before sending the e-mail
# BTS_SMTP_AUTH_USERNAME=user
# BTS_SMTP_AUTH_PASSWORD=pass
#
# Specify a HELO to use when connecting to the SMTP host. If not supplied
# and the file /etc/mailname exists, its contents will be used as the HELO
# BTS_SMTP_HELO=foo.example.com
#
# Include resolved bugs when caching?
# BTS_INCLUDE_RESOLVED=yes
#
# Suppress BTS acknowledgment e-mails (ignored by the control bot)
# BTS_SUPPRESS_ACKS=no
#
# Allow the generated message to be edited and, if necessary, abandoned
# before sending it to the control bot?
#
# If set to yes, prompt for confirmation / edit / abandonment.
# If set to force, spawn an editor and then proceed as if set to yes
# BTS_INTERACTIVE=no
#
# Specify a list of e-mail addresses to which a carbon copy of the
# generated e-mail to the control bot should automatically be sent.
# BTS_DEFAULT_CC=example@example.com
#
# Which debbugs server should be used?
# BTS_SERVER=https://bugs.debian.org

##### chdist
#
# No variables currently

##### checkbashisms
#
# No variables currently

##### cowpoke
#
# No variables currently; see cowpoke.conf and cowpoke(1)

##### cvs-debc
#
# No variables currently

##### cvs-debi
#
# No variables currently

##### cvs-debrelease
#
# No variables currently

##### cvs-debuild
#
# No variables currently

##### dd-list
#
# No variables currently

##### dcmd
#
# No variables currently

##### debc
#
# debc recognises the DEBRELEASE_DEBS_DIR variable; see debrelease
# below for more information.

##### deb-reversion
#
# No variables currently

##### debchange/dch
#
# Preserve the source tree dirname if the upstream version changes?
# DEBCHANGE_PRESERVE=no
#
# Query the BTS when --closes is being used?
# DEBCHANGE_QUERY_BTS=yes
#
# Select a heuristic to use to determine whether the package has released.
# See the debchange man page for details.
# DEBCHANGE_RELEASE_HEURISTIC=log
# DEBCHANGE_RELEASE_HEURISTIC=changelog
#
# Introduce multiple-maintainer markers in changelog sections?
# DEBCHANGE_MULTIMAINT=yes
#
# When appending to a multiple-maintainer changelog, if there are
# existing changes made by the current maintainer, should new
# changelog entries be appended to the existing entries?
# DEBCHANGE_MULTIMAINT_MERGE=no
#
# When appending entries to the changelog, should the trailer line
# be maintained as-is?
# DEBCHANGE_MAINTTRAILER=yes
#
# Use a fixed timezone in changelog entries?
# DEBCHANGE_TZ=UTC
#
# Allow a new version to be lower than the current package version
# if the new version matches the specified regular expression
# DEBCHANGE_LOWER_VERSION_PATTERN=bpo
#
# Attempt to automatically determine whether the current changelog
# stanza represents an NMU?
# DEBCHANGE_AUTO_NMU=yes
#
# When --release was used and an editor presented, force the changelog
# to be explicitly saved in the editor?  If this is set to "no" then
# the changes made by --release will be automatically saved.
# DEBCHANGE_FORCE_SAVE_ON_RELEASE=yes

##### debcheckout
#
# List of space-separated pairs REGEXP/REPLACEMENT_TEXT to define
# custom rules to enable authenticated mode.
# DEBCHECKOUT_AUTH_URLS=''
#
# For debian-dir-only repositories, also retrieve the source
# package, unpack it, and move the missing files over.
# DEBCHECKOUT_SOURCE=auto
#
# Username for authenticated mode, can be overridden with -u|--user.
# DEBCHECKOUT_USER=''
#
# See debcheckout(1) for a more precise description of syntax and
# semantics of these settings.

##### debclean
#
# Remove .deb, .changes, .dsc and .upload files?
# DEBCLEAN_CLEANDEBS=no

##### debcommit
#
# Strip a leading "* " from commit messages taken from changelogs?
# DEBCOMMIT_STRIP_MESSAGE=yes
#
# Sign created tags using gnupg?
# DEBCOMMIT_SIGN_TAGS=no
#
# Take any uncommitted changes in the changelog in
# to account when determining the commit message
# for a release?
# DEBCOMMIT_RELEASE_USE_CHANGELOG=no
#
# Sign commits using gnupg?
# DEBCOMMIT_SIGN_COMMITS=no

##### debdiff
#
# Show directory names which appear in the filelist?
# DEBDIFF_DIRS=no
#
# Compare control files?
# DEBDIFF_CONTROL=yes
#
# Which control files to compare?  A comma-separated list, with
# possibilities such as postinst, config and so on; ALL means compare
# all control files.
# DEBDIFF_CONTROLFILES=control
#
# Show files which have moved between .debs?
# DEBDIFF_SHOW_MOVED=no
#
# Option to pass to wdiff
# DEBDIFF_WDIFF_OPT=
#
# Include the output of diffstat?
# DEBDIFF_SHOW_DIFFSTAT=no
#
# Compare control files in source packages using wdiff?
# DEBDIFF_WDIFF_SOURCE_CONTROL=no
#
# Always compare package in version order, rather than the order specified
# on the command line?
# DEBDIFF_AUTO_VER_SORT=no
#
# Unpack tarballs found in the top level source directory.
# DEBDIFF_UNPACK_TARBALLS=yes
#
# Apply patches when comparing 3.0 (quilt)-format packages
# DEBDIFF_APPLY_PATCHES=no

##### debdiff-apply
#
# No variables currently

##### debi
#
# debc recognises the DEBRELEASE_DEBS_DIR variable; see debrelease
# below for more information.

##### debpkg
#
# No variables currently

##### debrelease
#
# This specifies which uploader program to use.  As of devscripts 2.23.4+deb12u2
# the recognised values are "dupload" (default) and "dput".  Check the
# debrelease(1) manpage for any recent changes to this variable
# DEBRELEASE_UPLOADER=dupload
#
# This specifies the directory, relative to the top of the source
# tree, in which the .changes and .debs files are to be found.  Note
# that this also affects debc and debi.
# DEBRELEASE_DEBS_DIR=..

##### debrsign
#
# No variables currently

##### debsign
#
# debsign recognises the DEBRELEASE_DEBS_DIR variable; see debrelease
# above for more information.
#
# Always re-sign files even if they are already signed, without prompting.
# DEBSIGN_ALWAYS_RESIGN=yes
#
# Which signing program to use?  gpg and pgp are the usual values; the
# default is determined as described in the manpage.
# Corresponds to -p option
# DEBSIGN_PROGRAM=
#
# How the signing program works; must be either gpg or pgp as of
# devscripts version 2.23.4+deb12u2.  The default is described in the
# manpage.  Corresponds to -sgpg and -spgp.
# DEBSIGN_SIGNLIKE=
#
# Maintainer name (only used to determine GPG keyid; -m option)
# DEBSIGN_MAINT=
#
# GPG keyid to use (-k option)
# DEBSIGN_KEYID=

##### debsnap
#
# Where to put the directory named <prefix>-<package>/
# default: source-$package_name if unset
# DEBSNAP_DESTDIR=
#
# Verbosely show messages (yes/no)
# default: no
# DEBSNAP_VERBOSE=no
#
# The base URL of the archive to download from
# DEBSNAP_BASE_URL=https://snapshot.debian.org
#
# A sed regexp to transform pool/<component>/f/foo into the desired layout
# default: make the directory from pool/<component>/f/foo to pool/f/foo
# DEBSNAP_CLEAN_REGEX="s@\([^/]*\)/[^/]*/\(.*\)@\1/\2@"
#
# Where the Sources.gz lives, subdirectory of DEBSNAP_BASE_URL/<clean dir>/
# default: DEBSNAP_BASE_URL/<clean dir>/source/Sources.gz
# DEBSNAP_SOURCES_GZ_PATH=source/Sources.gz

##### debuild
#
# Do we preserve the whole environment except for PATH?
# DEBUILD_PRESERVE_ENV=no
#
# Are there any environment variables we should preserve?  This should
# be a comma-separated list.
# DEBUILD_PRESERVE_ENVVARS=""
#
# How to set a preserved environment variable, in this case to set
# FOO=bar.
# DEBUILD_SET_ENVVAR_FOO=bar
#
# Do we check for the existence of the .orig.tar.gz before calling
# dpkg-buildpackage?
# DEBUILD_TGZ_CHECK=yes
#
# Corresponds to the dpkg-buildpackage -r option.
# DEBUILD_ROOTCMD=fakeroot
#
# Extra options given to dpkg-buildpackage before any command-line
# options specified.  Single options containing spaces should be
# quoted, for example "-m'Julian Gilbey <jdg@debian.org>' -us -uc"
# If this contains a -r, -d or -D option, this will also be recognised
# when running debuild binary|binary-arch|...
# DEBUILD_DPKG_BUILDPACKAGE_OPTS=""
#
# Do we run lintian at the end of a full run?
# DEBUILD_LINTIAN=yes
#
# Extra options given to lintian before any command-line options
# specified.
# DEBUILD_LINTIAN_OPTS=""
#
# Colon-separated list of options to be added to the beginning
# of PATH once it has been sanitised
# DEBUILD_PREPEND_PATH="/usr/lib/ccache"
#
# Credentials to pass to debrsign when signing dsc / changes files
# Setting this option to a non-blank string implies using debrsign
# DEBUILD_SIGNING_USERNAME="user@host"
#
# Hooks; see the manpage for details of these
# DEBUILD_DPKG_BUILDPACKAGE_HOOK=""
# DEBUILD_CLEAN_HOOK=""
# DEBUILD_DPKG_SOURCE_HOOK=""
# DEBUILD_BUILD_HOOK=""
# DEBUILD_BINARY_HOOK=""
# DEBUILD_FINAL_CLEAN_HOOK=""
# DEBUILD_LINTIAN_HOOK=""
# DEBUILD_SIGNING_HOOK=""
# DEBUILD_POST_DPKG_BUILDPACKAGE_HOOK=""

##### dget
#
# Extra directories to search for files in addition to
# /var/cache/apt/archives.  This is a colon-separated list of directories.
# DGET_PATH=""
#
# Unpack downloaded source packages
# DGET_UNPACK=yes
#
# Verify source package signatures using dscverify
# DGET_VERIFY=yes

##### diff2patches
#
# No variables currently

##### dpkg-depcheck
#
# Extra options given to dpkg-depcheck before any command-line
# options specified.  For example: "-b --features=-catch-alternatives"
# DPKG_DEPCHECK_OPTIONS=""

##### dpkg-genbuilddeps
#
# No variables currently

##### dpkg-sig
#
# dpkg-sig is not a part of devscripts, but shares this configuration file.
# It pays attention to the values of DEBSIGN_MAINT and DEBSIGN_KEY in
# addition to the following.
#
# This key ID takes precedence over the rest
# DPKGSIG_KEYID=
#
# Do we sign the .changes and .dsc files?  See the manpage for more
# info.  Valid options are no, auto, yes, full and force_full.
# DPKGSIG_SIGN_CHANGES=auto
#
# Do we cache the gpg passphrase by default?  This can be dangerous!
# DPKGSIG_CACHE_PASS=no

##### dscverify
#
# A colon separated list of extra keyrings to read.
# DSCVERIFY_KEYRINGS=""

##### getbuildlog
#
# No variables currently

##### grep-excuses
#
# This specifies a default maintainer name or email to hunt for
# GREP_EXCUSES_MAINTAINER=""
#
# Is this running on ftp-master.debian.org?  If so, we use the local
# excuses file
# GREP_EXCUSES_FTP_MASTER=no

##### list-unreleased
#
# No variables currently

##### mergechanges
#
# No variables currently

##### manpage-alert
#
# No variables currently

##### mass-bug
#
# No variables currently

#### mk-build-deps
#
# Which tool to use for installing build depends?
# MKBUILDDEPS_TOOL="/usr/bin/apt-get --no-install-recommends"
#
# Remove package files after install?
# MKBUILDDEPS_REMOVE_AFTER_INSTALL=yes
#
# Tool used to gain root privileges to install the deb
# MKBUILDDEPS_ROOTCMD=''

##### namecheck
#
# No variables currently; see .namecheckrc

##### nmudiff
#
# Number of days to indicate that an NMU upload has been delayed by
# using the DELAYED upload queue. 0 indicates no delay.
# Defaults to "XX" which adds a placeholder to the e-mail.
# NMUDIFF_DELAY=3
#
# Should we use mutt to edit and send the message or just a plain old
# editor?
# NMUDIFF_MUTT=yes
#
# Should we always submit a new report (yes), always send to the bugs
# which are being closed (no), or send to the bug being closed if
# there is only one of them, otherwise send a new report (maybe)?
# NMUDIFF_NEWREPORT=maybe
#
# nmudiff also uses the value of BTS_SENDMAIL_COMMAND if NMUDIFF_MUTT=no

##### plotchangelog
#
# Command line options to use (space separated).  None of the options
# should contain spaces.  Use the PLOTCHANGELOG_GNUPLOT variable for
# the --gnuplot command line option.
# PLOTCHANGELOG_OPTIONS=""
#
# Here we can give gnuplot options.  Any command line --gnuplot
# commands will be appended to these.
# PLOTCHANGELOG_GNUPLOT=""

##### pts-subscribe
#
# How long will we subscribe for by default?  The default is 30 days.
# Setting this to 'forever' means that no unsubscription request will
# be scheduled.
# PTS_UNTIL='now + 30 days'

##### rc-alert
#
# No variables currently

##### rmadison
#
# Add a custom URL to the default list of shorthands so one
# can use it with -u without having to specify the full URL
#
# RMADISON_URL_MAP_EXAMPLE=http://example.com/madison.cgi
#
# Default URL to use if none is specified on the command line.
# RMADISON_DEFAULT_URL=debian
#
# Default architecture to use if none is specified on the command line.
# use --architecture='*' to run an unrestricted query when
# RMADISON_ARCHITECTURE is set.
# RMADISON_ARCHITECTURE=source,i386,amd64,all

##### svnpath
#
# No variables currently

##### tagpending
#
# No variables currently

##### transition-check
#
# No variables currently

##### uscan
#
# Should we download newer upstream files we come across?
# USCAN_DOWNLOAD=yes
#
# Should we use FTP PASV mode for ftp:// links?  'default' means let
# Net::FTP(3) make the choice (primarily based on the FTP_PASSIVE
# environment variable); 'yes' and 'no' override the default
# USCAN_PASV=default
#
# Should we create a symlink from the downloaded tar.gz file to
# pkg_version.orig.tar.gz, rename it like this or do nothing?
# Options are 'symlink'/'yes', 'rename' or 'no'
# USCAN_SYMLINK=yes
#
# Should we use DEHS style output (XML format)?
# USCAN_DEHS_OUTPUT=no
#
# Should we give verbose output?
# USCAN_VERBOSE=no
#
# What user agent string should we send with requests?
# (Default is 'Debian uscan X.Y.Z')
# USCAN_USER_AGENT=''
#
# Where should downloaded files be placed?
# USCAN_DESTDIR=..
#
# Automatically repack bzipped tar or zip archives to gzipped tars?
# USCAN_REPACK=no
#
# Use the Files-Excluded field in debian/copyright to determine whether
# the orig tarball needs to be repacked to remove non-DFSG content?
# USCAN_EXCLUSION=yes

##### uupdate
#
# Should we retain the pristine upstream source wherever possible?
# UUPDATE_PRISTINE=yes
#
# Should we symlink the .orig.tar.gz file to its new name or
# copy it instead?  yes=symlink, no=copy
# UUPDATE_SYMLINK_ORIG=yes
#
# Corresponds to the dpkg-buildpackage -r option and debuild
# DEBUILD_ROOTCMD option.  Normally, this can be left empty, as then
# the debuild setting will be used.
# UUPDATE_ROOTCMD=''

##### whodepends
#
# No variables currently

##### who-uploads
#
# Display the date of the upload?
# WHOUPLOADS_DATE=no
#
# Maximum number of uploads to display per package
# WHOUPLOADS_MAXUPLOADS=3
#
# Colon-separated list of keyrings to examine by default
# WHOUPLOADS_KEYRINGS=/usr/share/keyrings/debian-keyring.gpg:/usr/share/keyrings/debian-keyring.pgp:/usr/share/keyrings/debian-maintainers.gpg:/usr/share/keyrings/debian-nonupload.gpg

##### wnpp-alert
#
# No variables currently

##### wnpp-check
#
# No variables currently

