const apiSchema = [
   {
      "children" : [
         {
            "children" : [
               {
                  "info" : {
                     "DELETE" : {
                        "allowtoken" : 1,
                        "description" : "Mark replication job for removal.",
                        "method" : "DELETE",
                        "name" : "delete",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "force" : {
                                 "default" : 0,
                                 "description" : "Will remove the jobconfig entry, but will not cleanup.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "id" : {
                                 "description" : "Replication Job ID. The ID is composed of a Guest ID and a job number, separated by a hyphen, i.e. '<GUEST>-<JOBNUM>'.",
                                 "format" : "pve-replication-job-id",
                                 "pattern" : "[1-9][0-9]{2,8}-\\d{1,9}",
                                 "type" : "string"
                              },
                              "keep" : {
                                 "default" : 0,
                                 "description" : "Keep replicated data at target (do not remove).",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/storage",
                              [
                                 "Datastore.Allocate"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     },
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Read replication job configuration.",
                        "method" : "GET",
                        "name" : "read",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "id" : {
                                 "description" : "Replication Job ID. The ID is composed of a Guest ID and a job number, separated by a hyphen, i.e. '<GUEST>-<JOBNUM>'.",
                                 "format" : "pve-replication-job-id",
                                 "pattern" : "[1-9][0-9]{2,8}-\\d{1,9}",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Requires the VM.Audit permission on /vms/<vmid>.",
                           "user" : "all"
                        },
                        "returns" : {
                           "type" : "object"
                        }
                     },
                     "PUT" : {
                        "allowtoken" : 1,
                        "description" : "Update replication job configuration.",
                        "method" : "PUT",
                        "name" : "update",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "comment" : {
                                 "description" : "Description.",
                                 "maxLength" : 4096,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "delete" : {
                                 "description" : "A list of settings you want to delete.",
                                 "format" : "pve-configid-list",
                                 "maxLength" : 4096,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "digest" : {
                                 "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                 "maxLength" : 64,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "disable" : {
                                 "description" : "Flag to disable/deactivate the entry.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "id" : {
                                 "description" : "Replication Job ID. The ID is composed of a Guest ID and a job number, separated by a hyphen, i.e. '<GUEST>-<JOBNUM>'.",
                                 "format" : "pve-replication-job-id",
                                 "pattern" : "[1-9][0-9]{2,8}-\\d{1,9}",
                                 "type" : "string"
                              },
                              "rate" : {
                                 "description" : "Rate limit in mbps (megabytes per second) as floating point number.",
                                 "minimum" : 1,
                                 "optional" : 1,
                                 "type" : "number",
                                 "typetext" : "<number> (1 - N)"
                              },
                              "remove_job" : {
                                 "description" : "Mark the replication job for removal. The job will remove all local replication snapshots. When set to 'full', it also tries to remove replicated volumes on the target. The job then removes itself from the configuration file.",
                                 "enum" : [
                                    "local",
                                    "full"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "schedule" : {
                                 "default" : "*/15",
                                 "description" : "Storage replication schedule. The format is a subset of `systemd` calendar events.",
                                 "format" : "pve-calendar-event",
                                 "maxLength" : 128,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "source" : {
                                 "description" : "For internal use, to detect if the guest was stolen.",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/storage",
                              [
                                 "Datastore.Allocate"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/replication/{id}",
                  "text" : "{id}"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "List replication jobs.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "description" : "Will only return replication jobs for which the calling user has VM.Audit permission on /vms/<vmid>.",
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{id}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               },
               "POST" : {
                  "allowtoken" : 1,
                  "description" : "Create a new replication job",
                  "method" : "POST",
                  "name" : "create",
                  "parameters" : {
                     "additionalProperties" : 0,
                     "properties" : {
                        "comment" : {
                           "description" : "Description.",
                           "maxLength" : 4096,
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "disable" : {
                           "description" : "Flag to disable/deactivate the entry.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "id" : {
                           "description" : "Replication Job ID. The ID is composed of a Guest ID and a job number, separated by a hyphen, i.e. '<GUEST>-<JOBNUM>'.",
                           "format" : "pve-replication-job-id",
                           "pattern" : "[1-9][0-9]{2,8}-\\d{1,9}",
                           "type" : "string"
                        },
                        "rate" : {
                           "description" : "Rate limit in mbps (megabytes per second) as floating point number.",
                           "minimum" : 1,
                           "optional" : 1,
                           "type" : "number",
                           "typetext" : "<number> (1 - N)"
                        },
                        "remove_job" : {
                           "description" : "Mark the replication job for removal. The job will remove all local replication snapshots. When set to 'full', it also tries to remove replicated volumes on the target. The job then removes itself from the configuration file.",
                           "enum" : [
                              "local",
                              "full"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "schedule" : {
                           "default" : "*/15",
                           "description" : "Storage replication schedule. The format is a subset of `systemd` calendar events.",
                           "format" : "pve-calendar-event",
                           "maxLength" : 128,
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "source" : {
                           "description" : "For internal use, to detect if the guest was stolen.",
                           "format" : "pve-node",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "target" : {
                           "description" : "Target node.",
                           "format" : "pve-node",
                           "optional" : 0,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "type" : {
                           "description" : "Section type.",
                           "enum" : [
                              "local"
                           ],
                           "type" : "string"
                        }
                     },
                     "type" : "object"
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/storage",
                        [
                           "Datastore.Allocate"
                        ]
                     ]
                  },
                  "protected" : 1,
                  "returns" : {
                     "type" : "null"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/replication",
            "text" : "replication"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Remove Metric server.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read metric server configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Create a new external metric server config",
                              "method" : "POST",
                              "name" : "create",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "api-path-prefix" : {
                                       "description" : "An API path prefix inserted between '<host>:<port>/' and '/api2/'. Can be useful if the InfluxDB service runs behind a reverse proxy.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "bucket" : {
                                       "description" : "The InfluxDB bucket/db. Only necessary when using the http v2 api.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "description" : "Flag to disable the plugin.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "id" : {
                                       "description" : "The ID of the entry.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "influxdbproto" : {
                                       "default" : "udp",
                                       "enum" : [
                                          "udp",
                                          "http",
                                          "https"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "max-body-size" : {
                                       "default" : 25000000,
                                       "description" : "InfluxDB max-body-size in bytes. Requests are batched up to this size.",
                                       "minimum" : 1,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (1 - N)"
                                    },
                                    "mtu" : {
                                       "default" : 1500,
                                       "description" : "MTU for metrics transmission over UDP",
                                       "maximum" : 65536,
                                       "minimum" : 512,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (512 - 65536)"
                                    },
                                    "organization" : {
                                       "description" : "The InfluxDB organization. Only necessary when using the http v2 api. Has no meaning when using v2 compatibility api.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "path" : {
                                       "description" : "root graphite path (ex: proxmox.mycluster.mykey)",
                                       "format" : "graphite-path",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "port" : {
                                       "description" : "server network port",
                                       "maximum" : 65536,
                                       "minimum" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (1 - 65536)"
                                    },
                                    "proto" : {
                                       "description" : "Protocol to send graphite data. TCP or UDP (default)",
                                       "enum" : [
                                          "udp",
                                          "tcp"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "server" : {
                                       "description" : "server dns name or IP address",
                                       "format" : "address",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "timeout" : {
                                       "default" : 1,
                                       "description" : "graphite TCP socket timeout (default=1)",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "token" : {
                                       "description" : "The InfluxDB access token. Only necessary when using the http v2 api. If the v2 compatibility api is used, use 'user:password' instead.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "type" : {
                                       "description" : "Plugin type.",
                                       "enum" : [
                                          "graphite",
                                          "influxdb"
                                       ],
                                       "format" : "pve-configid",
                                       "type" : "string"
                                    },
                                    "verify-certificate" : {
                                       "default" : 1,
                                       "description" : "Set to 0 to disable certificate verification for https endpoints.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update metric server configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "api-path-prefix" : {
                                       "description" : "An API path prefix inserted between '<host>:<port>/' and '/api2/'. Can be useful if the InfluxDB service runs behind a reverse proxy.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "bucket" : {
                                       "description" : "The InfluxDB bucket/db. Only necessary when using the http v2 api.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "description" : "Flag to disable the plugin.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "id" : {
                                       "description" : "The ID of the entry.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "influxdbproto" : {
                                       "default" : "udp",
                                       "enum" : [
                                          "udp",
                                          "http",
                                          "https"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "max-body-size" : {
                                       "default" : 25000000,
                                       "description" : "InfluxDB max-body-size in bytes. Requests are batched up to this size.",
                                       "minimum" : 1,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (1 - N)"
                                    },
                                    "mtu" : {
                                       "default" : 1500,
                                       "description" : "MTU for metrics transmission over UDP",
                                       "maximum" : 65536,
                                       "minimum" : 512,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (512 - 65536)"
                                    },
                                    "organization" : {
                                       "description" : "The InfluxDB organization. Only necessary when using the http v2 api. Has no meaning when using v2 compatibility api.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "path" : {
                                       "description" : "root graphite path (ex: proxmox.mycluster.mykey)",
                                       "format" : "graphite-path",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "port" : {
                                       "description" : "server network port",
                                       "maximum" : 65536,
                                       "minimum" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (1 - 65536)"
                                    },
                                    "proto" : {
                                       "description" : "Protocol to send graphite data. TCP or UDP (default)",
                                       "enum" : [
                                          "udp",
                                          "tcp"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "server" : {
                                       "description" : "server dns name or IP address",
                                       "format" : "address",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "timeout" : {
                                       "default" : 1,
                                       "description" : "graphite TCP socket timeout (default=1)",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "token" : {
                                       "description" : "The InfluxDB access token. Only necessary when using the http v2 api. If the v2 compatibility api is used, use 'user:password' instead.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "verify-certificate" : {
                                       "default" : 1,
                                       "description" : "Set to 0 to disable certificate verification for https endpoints.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/metrics/server/{id}",
                        "text" : "{id}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List configured metric servers.",
                        "method" : "GET",
                        "name" : "server_index",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "disable" : {
                                    "description" : "Flag to disable the plugin.",
                                    "type" : "boolean"
                                 },
                                 "id" : {
                                    "description" : "The ID of the entry.",
                                    "type" : "string"
                                 },
                                 "port" : {
                                    "description" : "Server network port",
                                    "type" : "integer"
                                 },
                                 "server" : {
                                    "description" : "Server dns name or IP address",
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "description" : "Plugin type.",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{id}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/metrics/server",
                  "text" : "server"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Retrieve metrics of the cluster.",
                        "method" : "GET",
                        "name" : "export",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "history" : {
                                 "default" : 0,
                                 "description" : "Also return historic values. Returns full available metric history unless `start-time` is also set",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "local-only" : {
                                 "default" : 0,
                                 "description" : "Only return metrics for the current node instead of the whole cluster",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "start-time" : {
                                 "default" : 0,
                                 "description" : "Only include metrics with a timestamp > start-time.",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "data" : {
                                 "description" : "Array of system metrics. Metrics are sorted by their timestamp.",
                                 "items" : {
                                    "additionalProperties" : 0,
                                    "properties" : {
                                       "id" : {
                                          "description" : "Unique identifier for this metric object, for instance 'node/<nodename>' or 'qemu/<vmid>'.",
                                          "type" : "string"
                                       },
                                       "metric" : {
                                          "description" : "Name of the metric.",
                                          "type" : "string"
                                       },
                                       "timestamp" : {
                                          "description" : "Time at which this metric was observed",
                                          "type" : "integer"
                                       },
                                       "type" : {
                                          "description" : "Type of the metric.",
                                          "enum" : [
                                             "gauge",
                                             "counter",
                                             "derive"
                                          ],
                                          "type" : "string"
                                       },
                                       "value" : {
                                          "description" : "Metric value.",
                                          "type" : "number"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "type" : "array"
                              }
                           },
                           "type" : "object"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/metrics/export",
                  "text" : "export"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Metrics index.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{name}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/metrics",
            "text" : "metrics"
         },
         {
            "children" : [
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Returns known notification metadata fields",
                        "method" : "GET",
                        "name" : "get_matcher_fields",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "or",
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Modify"
                                 ]
                              ],
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Audit"
                                 ]
                              ]
                           ]
                        },
                        "protected" : 0,
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "name" : {
                                    "description" : "Name of the field.",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/notifications/matcher-fields",
                  "text" : "matcher-fields"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Returns known notification metadata fields and their known values",
                        "method" : "GET",
                        "name" : "get_matcher_field_values",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "or",
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Modify"
                                 ]
                              ],
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Audit"
                                 ]
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "comment" : {
                                    "description" : "Additional comment for this value.",
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "field" : {
                                    "description" : "Field this value belongs to.",
                                    "type" : "string"
                                 },
                                 "value" : {
                                    "description" : "Notification metadata value known by the system.",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/notifications/matcher-field-values",
                  "text" : "matcher-field-values"
               },
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "info" : {
                                 "DELETE" : {
                                    "allowtoken" : 1,
                                    "description" : "Remove sendmail endpoint",
                                    "method" : "DELETE",
                                    "name" : "delete_sendmail_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/mapping/notifications",
                                          [
                                             "Mapping.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Return a specific sendmail endpoint",
                                    "method" : "GET",
                                    "name" : "get_sendmail_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "or",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Audit"
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "properties" : {
                                          "author" : {
                                             "description" : "Author of the mail",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean"
                                          },
                                          "from-address" : {
                                             "description" : "`From` address for the mail",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "mailto" : {
                                             "description" : "List of email recipients",
                                             "items" : {
                                                "format" : "email-or-username",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array"
                                          },
                                          "mailto-user" : {
                                             "description" : "List of users",
                                             "items" : {
                                                "format" : "pve-userid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "PUT" : {
                                    "allowtoken" : 1,
                                    "description" : "Update existing sendmail endpoint",
                                    "method" : "PUT",
                                    "name" : "update_sendmail_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "author" : {
                                             "description" : "Author of the mail",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "delete" : {
                                             "description" : "A list of settings you want to delete.",
                                             "items" : {
                                                "format" : "pve-configid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          },
                                          "from-address" : {
                                             "description" : "`From` address for the mail",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "mailto" : {
                                             "description" : "List of email recipients",
                                             "items" : {
                                                "format" : "email-or-username",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "mailto-user" : {
                                             "description" : "List of users",
                                             "items" : {
                                                "format" : "pve-userid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "and",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "or",
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.Audit",
                                                   "Sys.Modify"
                                                ]
                                             ],
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.AccessNetwork"
                                                ]
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/notifications/endpoints/sendmail/{name}",
                              "text" : "{name}"
                           }
                        ],
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Returns a list of all sendmail endpoints",
                              "method" : "GET",
                              "name" : "get_sendmail_endpoints",
                              "parameters" : {
                                 "additionalProperties" : 0
                              },
                              "permissions" : {
                                 "check" : [
                                    "or",
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Audit"
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "items" : {
                                    "properties" : {
                                       "author" : {
                                          "description" : "Author of the mail",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "comment" : {
                                          "description" : "Comment",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "disable" : {
                                          "default" : 0,
                                          "description" : "Disable this target",
                                          "optional" : 1,
                                          "type" : "boolean"
                                       },
                                       "from-address" : {
                                          "description" : "`From` address for the mail",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "mailto" : {
                                          "description" : "List of email recipients",
                                          "items" : {
                                             "format" : "email-or-username",
                                             "type" : "string"
                                          },
                                          "optional" : 1,
                                          "type" : "array"
                                       },
                                       "mailto-user" : {
                                          "description" : "List of users",
                                          "items" : {
                                             "format" : "pve-userid",
                                             "type" : "string"
                                          },
                                          "optional" : 1,
                                          "type" : "array"
                                       },
                                       "name" : {
                                          "description" : "The name of the endpoint.",
                                          "format" : "pve-configid",
                                          "type" : "string"
                                       },
                                       "origin" : {
                                          "description" : "Show if this entry was created by a user or was built-in",
                                          "enum" : [
                                             "user-created",
                                             "builtin",
                                             "modified-builtin"
                                          ],
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "links" : [
                                    {
                                       "href" : "{name}",
                                       "rel" : "child"
                                    }
                                 ],
                                 "type" : "array"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Create a new sendmail endpoint",
                              "method" : "POST",
                              "name" : "create_sendmail_endpoint",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "author" : {
                                       "description" : "Author of the mail",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "comment" : {
                                       "description" : "Comment",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "default" : 0,
                                       "description" : "Disable this target",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "from-address" : {
                                       "description" : "`From` address for the mail",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "mailto" : {
                                       "description" : "List of email recipients",
                                       "items" : {
                                          "format" : "email-or-username",
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "mailto-user" : {
                                       "description" : "List of users",
                                       "items" : {
                                          "format" : "pve-userid",
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "name" : {
                                       "description" : "The name of the endpoint.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "and",
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "or",
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Audit",
                                             "Sys.Modify"
                                          ]
                                       ],
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.AccessNetwork"
                                          ]
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/notifications/endpoints/sendmail",
                        "text" : "sendmail"
                     },
                     {
                        "children" : [
                           {
                              "info" : {
                                 "DELETE" : {
                                    "allowtoken" : 1,
                                    "description" : "Remove gotify endpoint",
                                    "method" : "DELETE",
                                    "name" : "delete_gotify_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/mapping/notifications",
                                          [
                                             "Mapping.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Return a specific gotify endpoint",
                                    "method" : "GET",
                                    "name" : "get_gotify_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "description" : "Name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "or",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Audit"
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "properties" : {
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string"
                                          },
                                          "server" : {
                                             "description" : "Server URL",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "PUT" : {
                                    "allowtoken" : 1,
                                    "description" : "Update existing gotify endpoint",
                                    "method" : "PUT",
                                    "name" : "update_gotify_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "delete" : {
                                             "description" : "A list of settings you want to delete.",
                                             "items" : {
                                                "format" : "pve-configid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "server" : {
                                             "description" : "Server URL",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "token" : {
                                             "description" : "Secret token",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "and",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "or",
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.Audit",
                                                   "Sys.Modify"
                                                ]
                                             ],
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.AccessNetwork"
                                                ]
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/notifications/endpoints/gotify/{name}",
                              "text" : "{name}"
                           }
                        ],
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Returns a list of all gotify endpoints",
                              "method" : "GET",
                              "name" : "get_gotify_endpoints",
                              "parameters" : {
                                 "additionalProperties" : 0
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/notifications",
                                    [
                                       "Mapping.Audit"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "items" : {
                                    "properties" : {
                                       "comment" : {
                                          "description" : "Comment",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "disable" : {
                                          "default" : 0,
                                          "description" : "Disable this target",
                                          "optional" : 1,
                                          "type" : "boolean"
                                       },
                                       "name" : {
                                          "description" : "The name of the endpoint.",
                                          "format" : "pve-configid",
                                          "type" : "string"
                                       },
                                       "origin" : {
                                          "description" : "Show if this entry was created by a user or was built-in",
                                          "enum" : [
                                             "user-created",
                                             "builtin",
                                             "modified-builtin"
                                          ],
                                          "type" : "string"
                                       },
                                       "server" : {
                                          "description" : "Server URL",
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "links" : [
                                    {
                                       "href" : "{name}",
                                       "rel" : "child"
                                    }
                                 ],
                                 "type" : "array"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Create a new gotify endpoint",
                              "method" : "POST",
                              "name" : "create_gotify_endpoint",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Comment",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "default" : 0,
                                       "description" : "Disable this target",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "name" : {
                                       "description" : "The name of the endpoint.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "server" : {
                                       "description" : "Server URL",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "token" : {
                                       "description" : "Secret token",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "and",
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "or",
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Audit",
                                             "Sys.Modify"
                                          ]
                                       ],
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.AccessNetwork"
                                          ]
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/notifications/endpoints/gotify",
                        "text" : "gotify"
                     },
                     {
                        "children" : [
                           {
                              "info" : {
                                 "DELETE" : {
                                    "allowtoken" : 1,
                                    "description" : "Remove smtp endpoint",
                                    "method" : "DELETE",
                                    "name" : "delete_smtp_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/mapping/notifications",
                                          [
                                             "Mapping.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Return a specific smtp endpoint",
                                    "method" : "GET",
                                    "name" : "get_smtp_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "or",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Audit"
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "properties" : {
                                          "author" : {
                                             "description" : "Author of the mail. Defaults to 'Proxmox VE'.",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean"
                                          },
                                          "from-address" : {
                                             "description" : "`From` address for the mail",
                                             "type" : "string"
                                          },
                                          "mailto" : {
                                             "description" : "List of email recipients",
                                             "items" : {
                                                "format" : "email-or-username",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array"
                                          },
                                          "mailto-user" : {
                                             "description" : "List of users",
                                             "items" : {
                                                "format" : "pve-userid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array"
                                          },
                                          "mode" : {
                                             "default" : "tls",
                                             "description" : "Determine which encryption method shall be used for the connection.",
                                             "enum" : [
                                                "insecure",
                                                "starttls",
                                                "tls"
                                             ],
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string"
                                          },
                                          "port" : {
                                             "description" : "The port to be used. Defaults to 465 for TLS based connections, 587 for STARTTLS based connections and port 25 for insecure plain-text connections.",
                                             "optional" : 1,
                                             "type" : "integer"
                                          },
                                          "server" : {
                                             "description" : "The address of the SMTP server.",
                                             "type" : "string"
                                          },
                                          "username" : {
                                             "description" : "Username for SMTP authentication",
                                             "optional" : 1,
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "PUT" : {
                                    "allowtoken" : 1,
                                    "description" : "Update existing smtp endpoint",
                                    "method" : "PUT",
                                    "name" : "update_smtp_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "author" : {
                                             "description" : "Author of the mail. Defaults to 'Proxmox VE'.",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "delete" : {
                                             "description" : "A list of settings you want to delete.",
                                             "items" : {
                                                "format" : "pve-configid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          },
                                          "from-address" : {
                                             "description" : "`From` address for the mail",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "mailto" : {
                                             "description" : "List of email recipients",
                                             "items" : {
                                                "format" : "email-or-username",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "mailto-user" : {
                                             "description" : "List of users",
                                             "items" : {
                                                "format" : "pve-userid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "mode" : {
                                             "default" : "tls",
                                             "description" : "Determine which encryption method shall be used for the connection.",
                                             "enum" : [
                                                "insecure",
                                                "starttls",
                                                "tls"
                                             ],
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "password" : {
                                             "description" : "Password for SMTP authentication",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "port" : {
                                             "description" : "The port to be used. Defaults to 465 for TLS based connections, 587 for STARTTLS based connections and port 25 for insecure plain-text connections.",
                                             "optional" : 1,
                                             "type" : "integer",
                                             "typetext" : "<integer>"
                                          },
                                          "server" : {
                                             "description" : "The address of the SMTP server.",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "username" : {
                                             "description" : "Username for SMTP authentication",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "and",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "or",
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.Audit",
                                                   "Sys.Modify"
                                                ]
                                             ],
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.AccessNetwork"
                                                ]
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/notifications/endpoints/smtp/{name}",
                              "text" : "{name}"
                           }
                        ],
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Returns a list of all smtp endpoints",
                              "method" : "GET",
                              "name" : "get_smtp_endpoints",
                              "parameters" : {
                                 "additionalProperties" : 0
                              },
                              "permissions" : {
                                 "check" : [
                                    "or",
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Audit"
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "items" : {
                                    "properties" : {
                                       "author" : {
                                          "description" : "Author of the mail. Defaults to 'Proxmox VE'.",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "comment" : {
                                          "description" : "Comment",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "disable" : {
                                          "default" : 0,
                                          "description" : "Disable this target",
                                          "optional" : 1,
                                          "type" : "boolean"
                                       },
                                       "from-address" : {
                                          "description" : "`From` address for the mail",
                                          "type" : "string"
                                       },
                                       "mailto" : {
                                          "description" : "List of email recipients",
                                          "items" : {
                                             "format" : "email-or-username",
                                             "type" : "string"
                                          },
                                          "optional" : 1,
                                          "type" : "array"
                                       },
                                       "mailto-user" : {
                                          "description" : "List of users",
                                          "items" : {
                                             "format" : "pve-userid",
                                             "type" : "string"
                                          },
                                          "optional" : 1,
                                          "type" : "array"
                                       },
                                       "mode" : {
                                          "default" : "tls",
                                          "description" : "Determine which encryption method shall be used for the connection.",
                                          "enum" : [
                                             "insecure",
                                             "starttls",
                                             "tls"
                                          ],
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "name" : {
                                          "description" : "The name of the endpoint.",
                                          "format" : "pve-configid",
                                          "type" : "string"
                                       },
                                       "origin" : {
                                          "description" : "Show if this entry was created by a user or was built-in",
                                          "enum" : [
                                             "user-created",
                                             "builtin",
                                             "modified-builtin"
                                          ],
                                          "type" : "string"
                                       },
                                       "port" : {
                                          "description" : "The port to be used. Defaults to 465 for TLS based connections, 587 for STARTTLS based connections and port 25 for insecure plain-text connections.",
                                          "optional" : 1,
                                          "type" : "integer"
                                       },
                                       "server" : {
                                          "description" : "The address of the SMTP server.",
                                          "type" : "string"
                                       },
                                       "username" : {
                                          "description" : "Username for SMTP authentication",
                                          "optional" : 1,
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "links" : [
                                    {
                                       "href" : "{name}",
                                       "rel" : "child"
                                    }
                                 ],
                                 "type" : "array"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Create a new smtp endpoint",
                              "method" : "POST",
                              "name" : "create_smtp_endpoint",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "author" : {
                                       "description" : "Author of the mail. Defaults to 'Proxmox VE'.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "comment" : {
                                       "description" : "Comment",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "default" : 0,
                                       "description" : "Disable this target",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "from-address" : {
                                       "description" : "`From` address for the mail",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "mailto" : {
                                       "description" : "List of email recipients",
                                       "items" : {
                                          "format" : "email-or-username",
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "mailto-user" : {
                                       "description" : "List of users",
                                       "items" : {
                                          "format" : "pve-userid",
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "mode" : {
                                       "default" : "tls",
                                       "description" : "Determine which encryption method shall be used for the connection.",
                                       "enum" : [
                                          "insecure",
                                          "starttls",
                                          "tls"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "name" : {
                                       "description" : "The name of the endpoint.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "password" : {
                                       "description" : "Password for SMTP authentication",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "port" : {
                                       "description" : "The port to be used. Defaults to 465 for TLS based connections, 587 for STARTTLS based connections and port 25 for insecure plain-text connections.",
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "server" : {
                                       "description" : "The address of the SMTP server.",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "username" : {
                                       "description" : "Username for SMTP authentication",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "and",
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "or",
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Audit",
                                             "Sys.Modify"
                                          ]
                                       ],
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.AccessNetwork"
                                          ]
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/notifications/endpoints/smtp",
                        "text" : "smtp"
                     },
                     {
                        "children" : [
                           {
                              "info" : {
                                 "DELETE" : {
                                    "allowtoken" : 1,
                                    "description" : "Remove webhook endpoint",
                                    "method" : "DELETE",
                                    "name" : "delete_webhook_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/mapping/notifications",
                                          [
                                             "Mapping.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Return a specific webhook endpoint",
                                    "method" : "GET",
                                    "name" : "get_webhook_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "description" : "Name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "or",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Audit"
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "properties" : {
                                          "body" : {
                                             "description" : "HTTP body, base64 encoded",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean"
                                          },
                                          "header" : {
                                             "description" : "HTTP headers to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                             "items" : {
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array"
                                          },
                                          "method" : {
                                             "description" : "HTTP method",
                                             "enum" : [
                                                "post",
                                                "put",
                                                "get"
                                             ],
                                             "type" : "string"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string"
                                          },
                                          "secret" : {
                                             "description" : "Secrets to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                             "items" : {
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array"
                                          },
                                          "url" : {
                                             "description" : "Server URL",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "PUT" : {
                                    "allowtoken" : 1,
                                    "description" : "Update existing webhook endpoint",
                                    "method" : "PUT",
                                    "name" : "update_webhook_endpoint",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "body" : {
                                             "description" : "HTTP body, base64 encoded",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "comment" : {
                                             "description" : "Comment",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "delete" : {
                                             "description" : "A list of settings you want to delete.",
                                             "items" : {
                                                "format" : "pve-configid",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "disable" : {
                                             "default" : 0,
                                             "description" : "Disable this target",
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          },
                                          "header" : {
                                             "description" : "HTTP headers to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                             "items" : {
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "method" : {
                                             "description" : "HTTP method",
                                             "enum" : [
                                                "post",
                                                "put",
                                                "get"
                                             ],
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "name" : {
                                             "description" : "The name of the endpoint.",
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "secret" : {
                                             "description" : "Secrets to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                             "items" : {
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "url" : {
                                             "description" : "Server URL",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "and",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "or",
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.Audit",
                                                   "Sys.Modify"
                                                ]
                                             ],
                                             [
                                                "perm",
                                                "/",
                                                [
                                                   "Sys.AccessNetwork"
                                                ]
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/notifications/endpoints/webhook/{name}",
                              "text" : "{name}"
                           }
                        ],
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Returns a list of all webhook endpoints",
                              "method" : "GET",
                              "name" : "get_webhook_endpoints",
                              "parameters" : {
                                 "additionalProperties" : 0
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/notifications",
                                    [
                                       "Mapping.Audit"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "items" : {
                                    "properties" : {
                                       "body" : {
                                          "description" : "HTTP body, base64 encoded",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "comment" : {
                                          "description" : "Comment",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "disable" : {
                                          "default" : 0,
                                          "description" : "Disable this target",
                                          "optional" : 1,
                                          "type" : "boolean"
                                       },
                                       "header" : {
                                          "description" : "HTTP headers to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                          "items" : {
                                             "type" : "string"
                                          },
                                          "optional" : 1,
                                          "type" : "array"
                                       },
                                       "method" : {
                                          "description" : "HTTP method",
                                          "enum" : [
                                             "post",
                                             "put",
                                             "get"
                                          ],
                                          "type" : "string"
                                       },
                                       "name" : {
                                          "description" : "The name of the endpoint.",
                                          "format" : "pve-configid",
                                          "type" : "string"
                                       },
                                       "origin" : {
                                          "description" : "Show if this entry was created by a user or was built-in",
                                          "enum" : [
                                             "user-created",
                                             "builtin",
                                             "modified-builtin"
                                          ],
                                          "type" : "string"
                                       },
                                       "secret" : {
                                          "description" : "Secrets to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                          "items" : {
                                             "type" : "string"
                                          },
                                          "optional" : 1,
                                          "type" : "array"
                                       },
                                       "url" : {
                                          "description" : "Server URL",
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "links" : [
                                    {
                                       "href" : "{name}",
                                       "rel" : "child"
                                    }
                                 ],
                                 "type" : "array"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Create a new webhook endpoint",
                              "method" : "POST",
                              "name" : "create_webhook_endpoint",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "body" : {
                                       "description" : "HTTP body, base64 encoded",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "comment" : {
                                       "description" : "Comment",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "default" : 0,
                                       "description" : "Disable this target",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "header" : {
                                       "description" : "HTTP headers to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "method" : {
                                       "description" : "HTTP method",
                                       "enum" : [
                                          "post",
                                          "put",
                                          "get"
                                       ],
                                       "type" : "string"
                                    },
                                    "name" : {
                                       "description" : "The name of the endpoint.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "secret" : {
                                       "description" : "Secrets to set. These have to be formatted as a property string in the format name=<name>,value=<base64 of value>",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "url" : {
                                       "description" : "Server URL",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "and",
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "or",
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Audit",
                                             "Sys.Modify"
                                          ]
                                       ],
                                       [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.AccessNetwork"
                                          ]
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/notifications/endpoints/webhook",
                        "text" : "webhook"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Index for all available endpoint types.",
                        "method" : "GET",
                        "name" : "endpoints_index",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {},
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/notifications/endpoints",
                  "text" : "endpoints"
               },
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "info" : {
                                 "POST" : {
                                    "allowtoken" : 1,
                                    "description" : "Send a test notification to a provided target.",
                                    "method" : "POST",
                                    "name" : "test_target",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "name" : {
                                             "description" : "Name of the target.",
                                             "format" : "pve-configid",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "or",
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Modify"
                                             ]
                                          ],
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Audit"
                                             ]
                                          ],
                                          [
                                             "perm",
                                             "/mapping/notifications",
                                             [
                                                "Mapping.Use"
                                             ]
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/notifications/targets/{name}/test",
                              "text" : "test"
                           }
                        ],
                        "leaf" : 0,
                        "path" : "/cluster/notifications/targets/{name}",
                        "text" : "{name}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Returns a list of all entities that can be used as notification targets.",
                        "method" : "GET",
                        "name" : "get_all_targets",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "or",
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Modify"
                                 ]
                              ],
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Audit"
                                 ]
                              ],
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Use"
                                 ]
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "comment" : {
                                    "description" : "Comment",
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "disable" : {
                                    "default" : 0,
                                    "description" : "Show if this target is disabled",
                                    "optional" : 1,
                                    "type" : "boolean"
                                 },
                                 "name" : {
                                    "description" : "Name of the target.",
                                    "format" : "pve-configid",
                                    "type" : "string"
                                 },
                                 "origin" : {
                                    "description" : "Show if this entry was created by a user or was built-in",
                                    "enum" : [
                                       "user-created",
                                       "builtin",
                                       "modified-builtin"
                                    ],
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "description" : "Type of the target.",
                                    "enum" : [
                                       "sendmail",
                                       "gotify",
                                       "smtp",
                                       "webhook"
                                    ],
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/notifications/targets",
                  "text" : "targets"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Remove matcher",
                              "method" : "DELETE",
                              "name" : "delete_matcher",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "name" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/notifications",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Return a specific matcher",
                              "method" : "GET",
                              "name" : "get_matcher",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "name" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "or",
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/notifications",
                                       [
                                          "Mapping.Audit"
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Comment",
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "disable" : {
                                       "default" : 0,
                                       "description" : "Disable this matcher",
                                       "optional" : 1,
                                       "type" : "boolean"
                                    },
                                    "invert-match" : {
                                       "description" : "Invert match of the whole matcher",
                                       "optional" : 1,
                                       "type" : "boolean"
                                    },
                                    "match-calendar" : {
                                       "description" : "Match notification timestamp",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array"
                                    },
                                    "match-field" : {
                                       "description" : "Metadata fields to match (regex or exact match). Must be in the form (regex|exact):<field>=<value>",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array"
                                    },
                                    "match-severity" : {
                                       "description" : "Notification severities to match",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array"
                                    },
                                    "mode" : {
                                       "default" : "all",
                                       "description" : "Choose between 'all' and 'any' for when multiple properties are specified",
                                       "enum" : [
                                          "all",
                                          "any"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "name" : {
                                       "description" : "Name of the matcher.",
                                       "format" : "pve-configid",
                                       "type" : "string"
                                    },
                                    "target" : {
                                       "description" : "Targets to notify on match",
                                       "items" : {
                                          "format" : "pve-configid",
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array"
                                    }
                                 },
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update existing matcher",
                              "method" : "PUT",
                              "name" : "update_matcher",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Comment",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "items" : {
                                          "format" : "pve-configid",
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "default" : 0,
                                       "description" : "Disable this matcher",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "invert-match" : {
                                       "description" : "Invert match of the whole matcher",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "match-calendar" : {
                                       "description" : "Match notification timestamp",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "match-field" : {
                                       "description" : "Metadata fields to match (regex or exact match). Must be in the form (regex|exact):<field>=<value>",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "match-severity" : {
                                       "description" : "Notification severities to match",
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "mode" : {
                                       "default" : "all",
                                       "description" : "Choose between 'all' and 'any' for when multiple properties are specified",
                                       "enum" : [
                                          "all",
                                          "any"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "name" : {
                                       "description" : "Name of the matcher.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "target" : {
                                       "description" : "Targets to notify on match",
                                       "items" : {
                                          "format" : "pve-configid",
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/notifications",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/notifications/matchers/{name}",
                        "text" : "{name}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Returns a list of all matchers",
                        "method" : "GET",
                        "name" : "get_matchers",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "or",
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Modify"
                                 ]
                              ],
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Audit"
                                 ]
                              ],
                              [
                                 "perm",
                                 "/mapping/notifications",
                                 [
                                    "Mapping.Use"
                                 ]
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "comment" : {
                                    "description" : "Comment",
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "disable" : {
                                    "default" : 0,
                                    "description" : "Disable this matcher",
                                    "optional" : 1,
                                    "type" : "boolean"
                                 },
                                 "invert-match" : {
                                    "description" : "Invert match of the whole matcher",
                                    "optional" : 1,
                                    "type" : "boolean"
                                 },
                                 "match-calendar" : {
                                    "description" : "Match notification timestamp",
                                    "items" : {
                                       "type" : "string"
                                    },
                                    "optional" : 1,
                                    "type" : "array"
                                 },
                                 "match-field" : {
                                    "description" : "Metadata fields to match (regex or exact match). Must be in the form (regex|exact):<field>=<value>",
                                    "items" : {
                                       "type" : "string"
                                    },
                                    "optional" : 1,
                                    "type" : "array"
                                 },
                                 "match-severity" : {
                                    "description" : "Notification severities to match",
                                    "items" : {
                                       "type" : "string"
                                    },
                                    "optional" : 1,
                                    "type" : "array"
                                 },
                                 "mode" : {
                                    "default" : "all",
                                    "description" : "Choose between 'all' and 'any' for when multiple properties are specified",
                                    "enum" : [
                                       "all",
                                       "any"
                                    ],
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "name" : {
                                    "description" : "Name of the matcher.",
                                    "format" : "pve-configid",
                                    "type" : "string"
                                 },
                                 "origin" : {
                                    "description" : "Show if this entry was created by a user or was built-in",
                                    "enum" : [
                                       "user-created",
                                       "builtin",
                                       "modified-builtin"
                                    ],
                                    "type" : "string"
                                 },
                                 "target" : {
                                    "description" : "Targets to notify on match",
                                    "items" : {
                                       "format" : "pve-configid",
                                       "type" : "string"
                                    },
                                    "optional" : 1,
                                    "type" : "array"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new matcher",
                        "method" : "POST",
                        "name" : "create_matcher",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "comment" : {
                                 "description" : "Comment",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "disable" : {
                                 "default" : 0,
                                 "description" : "Disable this matcher",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "invert-match" : {
                                 "description" : "Invert match of the whole matcher",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "match-calendar" : {
                                 "description" : "Match notification timestamp",
                                 "items" : {
                                    "type" : "string"
                                 },
                                 "optional" : 1,
                                 "type" : "array",
                                 "typetext" : "<array>"
                              },
                              "match-field" : {
                                 "description" : "Metadata fields to match (regex or exact match). Must be in the form (regex|exact):<field>=<value>",
                                 "items" : {
                                    "type" : "string"
                                 },
                                 "optional" : 1,
                                 "type" : "array",
                                 "typetext" : "<array>"
                              },
                              "match-severity" : {
                                 "description" : "Notification severities to match",
                                 "items" : {
                                    "type" : "string"
                                 },
                                 "optional" : 1,
                                 "type" : "array",
                                 "typetext" : "<array>"
                              },
                              "mode" : {
                                 "default" : "all",
                                 "description" : "Choose between 'all' and 'any' for when multiple properties are specified",
                                 "enum" : [
                                    "all",
                                    "any"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "name" : {
                                 "description" : "Name of the matcher.",
                                 "format" : "pve-configid",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "target" : {
                                 "description" : "Targets to notify on match",
                                 "items" : {
                                    "format" : "pve-configid",
                                    "type" : "string"
                                 },
                                 "optional" : 1,
                                 "type" : "array",
                                 "typetext" : "<array>"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/mapping/notifications",
                              [
                                 "Mapping.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/notifications/matchers",
                  "text" : "matchers"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Index for notification-related API endpoints.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{name}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/notifications",
            "text" : "notifications"
         },
         {
            "children" : [
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Return the version of the cluster join API available on this node.",
                        "method" : "GET",
                        "name" : "join_api_version",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "description" : "Cluster Join API version, currently 1",
                           "minimum" : 0,
                           "type" : "integer"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/config/apiversion",
                  "text" : "apiversion"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Removes a node from the cluster configuration.",
                              "method" : "DELETE",
                              "name" : "delnode",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "node" : {
                                       "description" : "The cluster node name.",
                                       "format" : "pve-node",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Adds a node to the cluster configuration. This call is for internal use.",
                              "method" : "POST",
                              "name" : "addnode",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "apiversion" : {
                                       "description" : "The JOIN_API_VERSION of the new node.",
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "force" : {
                                       "description" : "Do not throw error if node already exists.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "link[n]" : {
                                       "description" : "Address and priority information of a single corosync link. (up to 8 links supported; link0..link7)",
                                       "format" : {
                                          "address" : {
                                             "default_key" : 1,
                                             "description" : "Hostname (or IP) of this corosync link address.",
                                             "format" : "address",
                                             "format_description" : "IP",
                                             "type" : "string"
                                          },
                                          "priority" : {
                                             "default" : 0,
                                             "description" : "The priority for the link when knet is used in 'passive' mode (default). Lower value means higher priority. Only valid for cluster create, ignored on node add.",
                                             "maximum" : 255,
                                             "minimum" : 0,
                                             "optional" : 1,
                                             "type" : "integer"
                                          }
                                       },
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "[address=]<IP> [,priority=<integer>]"
                                    },
                                    "new_node_ip" : {
                                       "description" : "IP Address of node to add. Used as fallback if no links are given.",
                                       "format" : "ip",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "node" : {
                                       "description" : "The cluster node name.",
                                       "format" : "pve-node",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "nodeid" : {
                                       "description" : "Node id for this node.",
                                       "minimum" : 1,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (1 - N)"
                                    },
                                    "votes" : {
                                       "description" : "Number of votes for this node",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    }
                                 }
                              },
                              "protected" : 1,
                              "returns" : {
                                 "properties" : {
                                    "corosync_authkey" : {
                                       "type" : "string"
                                    },
                                    "corosync_conf" : {
                                       "type" : "string"
                                    },
                                    "warnings" : {
                                       "items" : {
                                          "type" : "string"
                                       },
                                       "type" : "array"
                                    }
                                 },
                                 "type" : "object"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/config/nodes/{node}",
                        "text" : "{node}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Corosync node list.",
                        "method" : "GET",
                        "name" : "nodes",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "node" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{node}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/config/nodes",
                  "text" : "nodes"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get information needed to join this cluster over the connected node.",
                        "method" : "GET",
                        "name" : "join_info",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "node" : {
                                 "default" : "current connected node",
                                 "description" : "The node for which the joinee gets the nodeinfo. ",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "config_digest" : {
                                 "type" : "string"
                              },
                              "nodelist" : {
                                 "items" : {
                                    "additionalProperties" : 1,
                                    "properties" : {
                                       "name" : {
                                          "description" : "The cluster node name.",
                                          "format" : "pve-node",
                                          "type" : "string"
                                       },
                                       "nodeid" : {
                                          "description" : "Node id for this node.",
                                          "minimum" : 1,
                                          "optional" : 1,
                                          "type" : "integer"
                                       },
                                       "pve_addr" : {
                                          "format" : "ip",
                                          "type" : "string"
                                       },
                                       "pve_fp" : {
                                          "description" : "Certificate SHA 256 fingerprint.",
                                          "pattern" : "([A-Fa-f0-9]{2}:){31}[A-Fa-f0-9]{2}",
                                          "type" : "string"
                                       },
                                       "quorum_votes" : {
                                          "minimum" : 0,
                                          "type" : "integer"
                                       },
                                       "ring0_addr" : {
                                          "description" : "Address and priority information of a single corosync link. (up to 8 links supported; link0..link7)",
                                          "format" : {
                                             "address" : {
                                                "default_key" : 1,
                                                "description" : "Hostname (or IP) of this corosync link address.",
                                                "format" : "address",
                                                "format_description" : "IP",
                                                "type" : "string"
                                             },
                                             "priority" : {
                                                "default" : 0,
                                                "description" : "The priority for the link when knet is used in 'passive' mode (default). Lower value means higher priority. Only valid for cluster create, ignored on node add.",
                                                "maximum" : 255,
                                                "minimum" : 0,
                                                "optional" : 1,
                                                "type" : "integer"
                                             }
                                          },
                                          "optional" : 1,
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "type" : "array"
                              },
                              "preferred_node" : {
                                 "description" : "The cluster node name.",
                                 "format" : "pve-node",
                                 "type" : "string"
                              },
                              "totem" : {
                                 "type" : "object"
                              }
                           },
                           "type" : "object"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Joins this node into an existing cluster. If no links are given, default to IP resolved by node's hostname on single link (fallback fails for clusters with multiple links).",
                        "method" : "POST",
                        "name" : "join",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "fingerprint" : {
                                 "description" : "Certificate SHA 256 fingerprint.",
                                 "pattern" : "([A-Fa-f0-9]{2}:){31}[A-Fa-f0-9]{2}",
                                 "type" : "string"
                              },
                              "force" : {
                                 "description" : "Do not throw error if node already exists.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "hostname" : {
                                 "description" : "Hostname (or IP) of an existing cluster member.",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "link[n]" : {
                                 "description" : "Address and priority information of a single corosync link. (up to 8 links supported; link0..link7)",
                                 "format" : {
                                    "address" : {
                                       "default_key" : 1,
                                       "description" : "Hostname (or IP) of this corosync link address.",
                                       "format" : "address",
                                       "format_description" : "IP",
                                       "type" : "string"
                                    },
                                    "priority" : {
                                       "default" : 0,
                                       "description" : "The priority for the link when knet is used in 'passive' mode (default). Lower value means higher priority. Only valid for cluster create, ignored on node add.",
                                       "maximum" : 255,
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer"
                                    }
                                 },
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "[address=]<IP> [,priority=<integer>]"
                              },
                              "nodeid" : {
                                 "description" : "Node id for this node.",
                                 "minimum" : 1,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (1 - N)"
                              },
                              "password" : {
                                 "description" : "Superuser (root) password of peer node.",
                                 "maxLength" : 128,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "votes" : {
                                 "description" : "Number of votes for this node",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              }
                           }
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "string"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/config/join",
                  "text" : "join"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get corosync totem protocol settings.",
                        "method" : "GET",
                        "name" : "totem",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "type" : "object"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/config/totem",
                  "text" : "totem"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get QDevice status",
                        "method" : "GET",
                        "name" : "status",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "object"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/config/qdevice",
                  "text" : "qdevice"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Directory index.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/",
                        [
                           "Sys.Audit"
                        ]
                     ]
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{name}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               },
               "POST" : {
                  "allowtoken" : 1,
                  "description" : "Generate new cluster configuration. If no links given, default to local IP address as link0.",
                  "method" : "POST",
                  "name" : "create",
                  "parameters" : {
                     "additionalProperties" : 0,
                     "properties" : {
                        "clustername" : {
                           "description" : "The name of the cluster.",
                           "format" : "pve-node",
                           "maxLength" : 15,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "link[n]" : {
                           "description" : "Address and priority information of a single corosync link. (up to 8 links supported; link0..link7)",
                           "format" : {
                              "address" : {
                                 "default_key" : 1,
                                 "description" : "Hostname (or IP) of this corosync link address.",
                                 "format" : "address",
                                 "format_description" : "IP",
                                 "type" : "string"
                              },
                              "priority" : {
                                 "default" : 0,
                                 "description" : "The priority for the link when knet is used in 'passive' mode (default). Lower value means higher priority. Only valid for cluster create, ignored on node add.",
                                 "maximum" : 255,
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[address=]<IP> [,priority=<integer>]"
                        },
                        "nodeid" : {
                           "description" : "Node id for this node.",
                           "minimum" : 1,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (1 - N)"
                        },
                        "votes" : {
                           "description" : "Number of votes for this node.",
                           "minimum" : 1,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (1 - N)"
                        }
                     }
                  },
                  "protected" : 1,
                  "returns" : {
                     "type" : "string"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/config",
            "text" : "config"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "info" : {
                                 "DELETE" : {
                                    "allowtoken" : 1,
                                    "description" : "Delete rule.",
                                    "method" : "DELETE",
                                    "name" : "delete_rule",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "group" : {
                                             "description" : "Security Group name.",
                                             "maxLength" : 18,
                                             "minLength" : 2,
                                             "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                             "type" : "string"
                                          },
                                          "pos" : {
                                             "description" : "Update rule at position <pos>.",
                                             "minimum" : 0,
                                             "optional" : 1,
                                             "type" : "integer",
                                             "typetext" : "<integer> (0 - N)"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "proxyto" : null,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Get single rule data.",
                                    "method" : "GET",
                                    "name" : "get_rule",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "group" : {
                                             "description" : "Security Group name.",
                                             "maxLength" : 18,
                                             "minLength" : 2,
                                             "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                             "type" : "string"
                                          },
                                          "pos" : {
                                             "description" : "Update rule at position <pos>.",
                                             "minimum" : 0,
                                             "optional" : 1,
                                             "type" : "integer",
                                             "typetext" : "<integer> (0 - N)"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Audit"
                                          ]
                                       ]
                                    },
                                    "proxyto" : null,
                                    "returns" : {
                                       "properties" : {
                                          "action" : {
                                             "type" : "string"
                                          },
                                          "comment" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "dest" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "dport" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "enable" : {
                                             "optional" : 1,
                                             "type" : "integer"
                                          },
                                          "icmp-type" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "iface" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "ipversion" : {
                                             "optional" : 1,
                                             "type" : "integer"
                                          },
                                          "log" : {
                                             "description" : "Log level for firewall rule",
                                             "enum" : [
                                                "emerg",
                                                "alert",
                                                "crit",
                                                "err",
                                                "warning",
                                                "notice",
                                                "info",
                                                "debug",
                                                "nolog"
                                             ],
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "macro" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "pos" : {
                                             "type" : "integer"
                                          },
                                          "proto" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "source" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "sport" : {
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "type" : {
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "PUT" : {
                                    "allowtoken" : 1,
                                    "description" : "Modify rule data.",
                                    "method" : "PUT",
                                    "name" : "update_rule",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "action" : {
                                             "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                             "maxLength" : 20,
                                             "minLength" : 2,
                                             "optional" : 1,
                                             "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                             "type" : "string"
                                          },
                                          "comment" : {
                                             "description" : "Descriptive comment.",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "delete" : {
                                             "description" : "A list of settings you want to delete.",
                                             "format" : "pve-configid-list",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "dest" : {
                                             "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                             "format" : "pve-fw-addr-spec",
                                             "maxLength" : 512,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "dport" : {
                                             "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                             "format" : "pve-fw-dport-spec",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "enable" : {
                                             "description" : "Flag to enable/disable a rule.",
                                             "minimum" : 0,
                                             "optional" : 1,
                                             "type" : "integer",
                                             "typetext" : "<integer> (0 - N)"
                                          },
                                          "group" : {
                                             "description" : "Security Group name.",
                                             "maxLength" : 18,
                                             "minLength" : 2,
                                             "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                             "type" : "string"
                                          },
                                          "icmp-type" : {
                                             "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                             "format" : "pve-fw-icmp-type-spec",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "iface" : {
                                             "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                             "format" : "pve-iface",
                                             "maxLength" : 20,
                                             "minLength" : 2,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "log" : {
                                             "description" : "Log level for firewall rule.",
                                             "enum" : [
                                                "emerg",
                                                "alert",
                                                "crit",
                                                "err",
                                                "warning",
                                                "notice",
                                                "info",
                                                "debug",
                                                "nolog"
                                             ],
                                             "optional" : 1,
                                             "type" : "string"
                                          },
                                          "macro" : {
                                             "description" : "Use predefined standard macro.",
                                             "maxLength" : 128,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "moveto" : {
                                             "description" : "Move rule to new position <moveto>. Other arguments are ignored.",
                                             "minimum" : 0,
                                             "optional" : 1,
                                             "type" : "integer",
                                             "typetext" : "<integer> (0 - N)"
                                          },
                                          "pos" : {
                                             "description" : "Update rule at position <pos>.",
                                             "minimum" : 0,
                                             "optional" : 1,
                                             "type" : "integer",
                                             "typetext" : "<integer> (0 - N)"
                                          },
                                          "proto" : {
                                             "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                             "format" : "pve-fw-protocol-spec",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "source" : {
                                             "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                             "format" : "pve-fw-addr-spec",
                                             "maxLength" : 512,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "sport" : {
                                             "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                             "format" : "pve-fw-sport-spec",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "type" : {
                                             "description" : "Rule type.",
                                             "enum" : [
                                                "in",
                                                "out",
                                                "forward",
                                                "group"
                                             ],
                                             "optional" : 1,
                                             "type" : "string"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "proxyto" : null,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/firewall/groups/{group}/{pos}",
                              "text" : "{pos}"
                           }
                        ],
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete security group.",
                              "method" : "DELETE",
                              "name" : "delete_security_group",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "group" : {
                                       "description" : "Security Group name.",
                                       "maxLength" : 18,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "List rules.",
                              "method" : "GET",
                              "name" : "get_rules",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "group" : {
                                       "description" : "Security Group name.",
                                       "maxLength" : 18,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "proxyto" : null,
                              "returns" : {
                                 "items" : {
                                    "properties" : {
                                       "pos" : {
                                          "type" : "integer"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "links" : [
                                    {
                                       "href" : "{pos}",
                                       "rel" : "child"
                                    }
                                 ],
                                 "type" : "array"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Create new rule.",
                              "method" : "POST",
                              "name" : "create_rule",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "action" : {
                                       "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                       "maxLength" : 20,
                                       "minLength" : 2,
                                       "optional" : 0,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    },
                                    "comment" : {
                                       "description" : "Descriptive comment.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dest" : {
                                       "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                       "format" : "pve-fw-addr-spec",
                                       "maxLength" : 512,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dport" : {
                                       "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                       "format" : "pve-fw-dport-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "enable" : {
                                       "description" : "Flag to enable/disable a rule.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "group" : {
                                       "description" : "Security Group name.",
                                       "maxLength" : 18,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    },
                                    "icmp-type" : {
                                       "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                       "format" : "pve-fw-icmp-type-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "iface" : {
                                       "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                       "format" : "pve-iface",
                                       "maxLength" : 20,
                                       "minLength" : 2,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "log" : {
                                       "description" : "Log level for firewall rule.",
                                       "enum" : [
                                          "emerg",
                                          "alert",
                                          "crit",
                                          "err",
                                          "warning",
                                          "notice",
                                          "info",
                                          "debug",
                                          "nolog"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "macro" : {
                                       "description" : "Use predefined standard macro.",
                                       "maxLength" : 128,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "pos" : {
                                       "description" : "Update rule at position <pos>.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "proto" : {
                                       "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                       "format" : "pve-fw-protocol-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "source" : {
                                       "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                       "format" : "pve-fw-addr-spec",
                                       "maxLength" : 512,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "sport" : {
                                       "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                       "format" : "pve-fw-sport-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "type" : {
                                       "description" : "Rule type.",
                                       "enum" : [
                                          "in",
                                          "out",
                                          "forward",
                                          "group"
                                       ],
                                       "optional" : 0,
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "proxyto" : null,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/firewall/groups/{group}",
                        "text" : "{group}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List security groups.",
                        "method" : "GET",
                        "name" : "list_security_groups",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "comment" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "digest" : {
                                    "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                    "maxLength" : 64,
                                    "optional" : 0,
                                    "type" : "string"
                                 },
                                 "group" : {
                                    "description" : "Security Group name.",
                                    "maxLength" : 18,
                                    "minLength" : 2,
                                    "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{group}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create new security group.",
                        "method" : "POST",
                        "name" : "create_security_group",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "comment" : {
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "digest" : {
                                 "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                 "maxLength" : 64,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "group" : {
                                 "description" : "Security Group name.",
                                 "maxLength" : 18,
                                 "minLength" : 2,
                                 "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                 "type" : "string"
                              },
                              "rename" : {
                                 "description" : "Rename/update an existing security group. You can set 'rename' to the same value as 'name' to update the 'comment' of an existing group.",
                                 "maxLength" : 18,
                                 "minLength" : 2,
                                 "optional" : 1,
                                 "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/firewall/groups",
                  "text" : "groups"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete rule.",
                              "method" : "DELETE",
                              "name" : "delete_rule",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "pos" : {
                                       "description" : "Update rule at position <pos>.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "proxyto" : null,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get single rule data.",
                              "method" : "GET",
                              "name" : "get_rule",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "pos" : {
                                       "description" : "Update rule at position <pos>.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "proxyto" : null,
                              "returns" : {
                                 "properties" : {
                                    "action" : {
                                       "type" : "string"
                                    },
                                    "comment" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "dest" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "dport" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "enable" : {
                                       "optional" : 1,
                                       "type" : "integer"
                                    },
                                    "icmp-type" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "iface" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "ipversion" : {
                                       "optional" : 1,
                                       "type" : "integer"
                                    },
                                    "log" : {
                                       "description" : "Log level for firewall rule",
                                       "enum" : [
                                          "emerg",
                                          "alert",
                                          "crit",
                                          "err",
                                          "warning",
                                          "notice",
                                          "info",
                                          "debug",
                                          "nolog"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "macro" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "pos" : {
                                       "type" : "integer"
                                    },
                                    "proto" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "source" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "sport" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "type" : {
                                       "type" : "string"
                                    }
                                 },
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Modify rule data.",
                              "method" : "PUT",
                              "name" : "update_rule",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "action" : {
                                       "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                       "maxLength" : 20,
                                       "minLength" : 2,
                                       "optional" : 1,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    },
                                    "comment" : {
                                       "description" : "Descriptive comment.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dest" : {
                                       "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                       "format" : "pve-fw-addr-spec",
                                       "maxLength" : 512,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dport" : {
                                       "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                       "format" : "pve-fw-dport-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "enable" : {
                                       "description" : "Flag to enable/disable a rule.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "icmp-type" : {
                                       "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                       "format" : "pve-fw-icmp-type-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "iface" : {
                                       "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                       "format" : "pve-iface",
                                       "maxLength" : 20,
                                       "minLength" : 2,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "log" : {
                                       "description" : "Log level for firewall rule.",
                                       "enum" : [
                                          "emerg",
                                          "alert",
                                          "crit",
                                          "err",
                                          "warning",
                                          "notice",
                                          "info",
                                          "debug",
                                          "nolog"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "macro" : {
                                       "description" : "Use predefined standard macro.",
                                       "maxLength" : 128,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "moveto" : {
                                       "description" : "Move rule to new position <moveto>. Other arguments are ignored.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "pos" : {
                                       "description" : "Update rule at position <pos>.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "proto" : {
                                       "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                       "format" : "pve-fw-protocol-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "source" : {
                                       "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                       "format" : "pve-fw-addr-spec",
                                       "maxLength" : 512,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "sport" : {
                                       "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                       "format" : "pve-fw-sport-spec",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "type" : {
                                       "description" : "Rule type.",
                                       "enum" : [
                                          "in",
                                          "out",
                                          "forward",
                                          "group"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "proxyto" : null,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/firewall/rules/{pos}",
                        "text" : "{pos}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List rules.",
                        "method" : "GET",
                        "name" : "get_rules",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "proxyto" : null,
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "pos" : {
                                    "type" : "integer"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{pos}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create new rule.",
                        "method" : "POST",
                        "name" : "create_rule",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "action" : {
                                 "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                 "maxLength" : 20,
                                 "minLength" : 2,
                                 "optional" : 0,
                                 "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                 "type" : "string"
                              },
                              "comment" : {
                                 "description" : "Descriptive comment.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "dest" : {
                                 "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                 "format" : "pve-fw-addr-spec",
                                 "maxLength" : 512,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "digest" : {
                                 "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                 "maxLength" : 64,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "dport" : {
                                 "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                 "format" : "pve-fw-dport-spec",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "enable" : {
                                 "description" : "Flag to enable/disable a rule.",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "icmp-type" : {
                                 "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                 "format" : "pve-fw-icmp-type-spec",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "iface" : {
                                 "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                 "format" : "pve-iface",
                                 "maxLength" : 20,
                                 "minLength" : 2,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "log" : {
                                 "description" : "Log level for firewall rule.",
                                 "enum" : [
                                    "emerg",
                                    "alert",
                                    "crit",
                                    "err",
                                    "warning",
                                    "notice",
                                    "info",
                                    "debug",
                                    "nolog"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "macro" : {
                                 "description" : "Use predefined standard macro.",
                                 "maxLength" : 128,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "pos" : {
                                 "description" : "Update rule at position <pos>.",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "proto" : {
                                 "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                 "format" : "pve-fw-protocol-spec",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "source" : {
                                 "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                 "format" : "pve-fw-addr-spec",
                                 "maxLength" : 512,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "sport" : {
                                 "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                 "format" : "pve-fw-sport-spec",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "type" : {
                                 "description" : "Rule type.",
                                 "enum" : [
                                    "in",
                                    "out",
                                    "forward",
                                    "group"
                                 ],
                                 "optional" : 0,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "proxyto" : null,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/firewall/rules",
                  "text" : "rules"
               },
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "info" : {
                                 "DELETE" : {
                                    "allowtoken" : 1,
                                    "description" : "Remove IP or Network from IPSet.",
                                    "method" : "DELETE",
                                    "name" : "remove_ip",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "cidr" : {
                                             "description" : "Network/IP specification in CIDR format.",
                                             "format" : "IPorCIDRorAlias",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "name" : {
                                             "description" : "IP set name.",
                                             "maxLength" : 64,
                                             "minLength" : 2,
                                             "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                             "type" : "string"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Read IP or Network settings from IPSet.",
                                    "method" : "GET",
                                    "name" : "read_ip",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "cidr" : {
                                             "description" : "Network/IP specification in CIDR format.",
                                             "format" : "IPorCIDRorAlias",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "name" : {
                                             "description" : "IP set name.",
                                             "maxLength" : 64,
                                             "minLength" : 2,
                                             "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                             "type" : "string"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Audit"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "object"
                                    }
                                 },
                                 "PUT" : {
                                    "allowtoken" : 1,
                                    "description" : "Update IP or Network settings",
                                    "method" : "PUT",
                                    "name" : "update_ip",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "cidr" : {
                                             "description" : "Network/IP specification in CIDR format.",
                                             "format" : "IPorCIDRorAlias",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "comment" : {
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "digest" : {
                                             "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                             "maxLength" : 64,
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "name" : {
                                             "description" : "IP set name.",
                                             "maxLength" : 64,
                                             "minLength" : 2,
                                             "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                             "type" : "string"
                                          },
                                          "nomatch" : {
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Modify"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/firewall/ipset/{name}/{cidr}",
                              "text" : "{cidr}"
                           }
                        ],
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete IPSet",
                              "method" : "DELETE",
                              "name" : "delete_ipset",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "force" : {
                                       "description" : "Delete all members of the IPSet, if there are any.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "name" : {
                                       "description" : "IP set name.",
                                       "maxLength" : 64,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "List IPSet content",
                              "method" : "GET",
                              "name" : "get_ipset",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "name" : {
                                       "description" : "IP set name.",
                                       "maxLength" : 64,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "items" : {
                                    "properties" : {
                                       "cidr" : {
                                          "type" : "string"
                                       },
                                       "comment" : {
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "digest" : {
                                          "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                          "maxLength" : 64,
                                          "optional" : 0,
                                          "type" : "string"
                                       },
                                       "nomatch" : {
                                          "optional" : 1,
                                          "type" : "boolean"
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "links" : [
                                    {
                                       "href" : "{cidr}",
                                       "rel" : "child"
                                    }
                                 ],
                                 "type" : "array"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Add IP or Network to IPSet.",
                              "method" : "POST",
                              "name" : "create_ip",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "cidr" : {
                                       "description" : "Network/IP specification in CIDR format.",
                                       "format" : "IPorCIDRorAlias",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "comment" : {
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "name" : {
                                       "description" : "IP set name.",
                                       "maxLength" : 64,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    },
                                    "nomatch" : {
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/firewall/ipset/{name}",
                        "text" : "{name}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List IPSets",
                        "method" : "GET",
                        "name" : "ipset_index",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "comment" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "digest" : {
                                    "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                    "maxLength" : 64,
                                    "optional" : 0,
                                    "type" : "string"
                                 },
                                 "name" : {
                                    "description" : "IP set name.",
                                    "maxLength" : 64,
                                    "minLength" : 2,
                                    "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create new IPSet",
                        "method" : "POST",
                        "name" : "create_ipset",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "comment" : {
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "digest" : {
                                 "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                 "maxLength" : 64,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "name" : {
                                 "description" : "IP set name.",
                                 "maxLength" : 64,
                                 "minLength" : 2,
                                 "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                 "type" : "string"
                              },
                              "rename" : {
                                 "description" : "Rename an existing IPSet. You can set 'rename' to the same value as 'name' to update the 'comment' of an existing IPSet.",
                                 "maxLength" : 64,
                                 "minLength" : 2,
                                 "optional" : 1,
                                 "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/firewall/ipset",
                  "text" : "ipset"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Remove IP or Network alias.",
                              "method" : "DELETE",
                              "name" : "remove_alias",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "name" : {
                                       "description" : "Alias name.",
                                       "maxLength" : 64,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read alias.",
                              "method" : "GET",
                              "name" : "read_alias",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "name" : {
                                       "description" : "Alias name.",
                                       "maxLength" : 64,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update IP or Network alias.",
                              "method" : "PUT",
                              "name" : "update_alias",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "cidr" : {
                                       "description" : "Network/IP specification in CIDR format.",
                                       "format" : "IPorCIDR",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "comment" : {
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "name" : {
                                       "description" : "Alias name.",
                                       "maxLength" : 64,
                                       "minLength" : 2,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    },
                                    "rename" : {
                                       "description" : "Rename an existing alias.",
                                       "maxLength" : 64,
                                       "minLength" : 2,
                                       "optional" : 1,
                                       "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/firewall/aliases/{name}",
                        "text" : "{name}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List aliases",
                        "method" : "GET",
                        "name" : "get_aliases",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "cidr" : {
                                    "type" : "string"
                                 },
                                 "comment" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "digest" : {
                                    "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                    "maxLength" : 64,
                                    "optional" : 0,
                                    "type" : "string"
                                 },
                                 "name" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create IP or Network Alias.",
                        "method" : "POST",
                        "name" : "create_alias",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "cidr" : {
                                 "description" : "Network/IP specification in CIDR format.",
                                 "format" : "IPorCIDR",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "comment" : {
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "name" : {
                                 "description" : "Alias name.",
                                 "maxLength" : 64,
                                 "minLength" : 2,
                                 "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/firewall/aliases",
                  "text" : "aliases"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get Firewall options.",
                        "method" : "GET",
                        "name" : "get_options",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "properties" : {
                              "ebtables" : {
                                 "default" : 1,
                                 "description" : "Enable ebtables rules cluster wide.",
                                 "optional" : 1,
                                 "type" : "boolean"
                              },
                              "enable" : {
                                 "description" : "Enable or disable the firewall cluster wide.",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer"
                              },
                              "log_ratelimit" : {
                                 "description" : "Log ratelimiting settings",
                                 "format" : {
                                    "burst" : {
                                       "default" : 5,
                                       "description" : "Initial burst of packages which will always get logged before the rate is applied",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer"
                                    },
                                    "enable" : {
                                       "default" : "1",
                                       "default_key" : 1,
                                       "description" : "Enable or disable log rate limiting",
                                       "type" : "boolean"
                                    },
                                    "rate" : {
                                       "default" : "1/second",
                                       "description" : "Frequency with which the burst bucket gets refilled",
                                       "format_description" : "rate",
                                       "optional" : 1,
                                       "pattern" : "[1-9][0-9]*\\/(second|minute|hour|day)",
                                       "type" : "string"
                                    }
                                 },
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "policy_forward" : {
                                 "description" : "Forward policy.",
                                 "enum" : [
                                    "ACCEPT",
                                    "DROP"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "policy_in" : {
                                 "description" : "Input policy.",
                                 "enum" : [
                                    "ACCEPT",
                                    "REJECT",
                                    "DROP"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "policy_out" : {
                                 "description" : "Output policy.",
                                 "enum" : [
                                    "ACCEPT",
                                    "REJECT",
                                    "DROP"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "type" : "object"
                        }
                     },
                     "PUT" : {
                        "allowtoken" : 1,
                        "description" : "Set Firewall options.",
                        "method" : "PUT",
                        "name" : "set_options",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "delete" : {
                                 "description" : "A list of settings you want to delete.",
                                 "format" : "pve-configid-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "digest" : {
                                 "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                 "maxLength" : 64,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "ebtables" : {
                                 "default" : 1,
                                 "description" : "Enable ebtables rules cluster wide.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "enable" : {
                                 "description" : "Enable or disable the firewall cluster wide.",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "log_ratelimit" : {
                                 "description" : "Log ratelimiting settings",
                                 "format" : {
                                    "burst" : {
                                       "default" : 5,
                                       "description" : "Initial burst of packages which will always get logged before the rate is applied",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer"
                                    },
                                    "enable" : {
                                       "default" : "1",
                                       "default_key" : 1,
                                       "description" : "Enable or disable log rate limiting",
                                       "type" : "boolean"
                                    },
                                    "rate" : {
                                       "default" : "1/second",
                                       "description" : "Frequency with which the burst bucket gets refilled",
                                       "format_description" : "rate",
                                       "optional" : 1,
                                       "pattern" : "[1-9][0-9]*\\/(second|minute|hour|day)",
                                       "type" : "string"
                                    }
                                 },
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "[enable=]<1|0> [,burst=<integer>] [,rate=<rate>]"
                              },
                              "policy_forward" : {
                                 "description" : "Forward policy.",
                                 "enum" : [
                                    "ACCEPT",
                                    "DROP"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "policy_in" : {
                                 "description" : "Input policy.",
                                 "enum" : [
                                    "ACCEPT",
                                    "REJECT",
                                    "DROP"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "policy_out" : {
                                 "description" : "Output policy.",
                                 "enum" : [
                                    "ACCEPT",
                                    "REJECT",
                                    "DROP"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/firewall/options",
                  "text" : "options"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List available macros",
                        "method" : "GET",
                        "name" : "get_macros",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "descr" : {
                                    "description" : "More verbose description (if available).",
                                    "type" : "string"
                                 },
                                 "macro" : {
                                    "description" : "Macro name.",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/firewall/macros",
                  "text" : "macros"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Lists possible IPSet/Alias reference which are allowed in source/dest properties.",
                        "method" : "GET",
                        "name" : "refs",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "type" : {
                                 "description" : "Only list references of specified type.",
                                 "enum" : [
                                    "alias",
                                    "ipset"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "comment" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "name" : {
                                    "type" : "string"
                                 },
                                 "ref" : {
                                    "type" : "string"
                                 },
                                 "scope" : {
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "enum" : [
                                       "alias",
                                       "ipset"
                                    ],
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/firewall/refs",
                  "text" : "refs"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Directory index.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{name}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/firewall",
            "text" : "firewall"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Returns included guests and the backup status of their disks. Optimized to be used in ExtJS tree views.",
                              "method" : "GET",
                              "name" : "get_volume_backup_included",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "description" : "The job ID.",
                                       "maxLength" : 50,
                                       "pattern" : "\\S+",
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "description" : "Root node of the tree object. Children represent guests, grandchildren represent volumes of that guest.",
                                 "properties" : {
                                    "children" : {
                                       "items" : {
                                          "properties" : {
                                             "children" : {
                                                "description" : "The volumes of the guest with the information if they will be included in backups.",
                                                "items" : {
                                                   "properties" : {
                                                      "id" : {
                                                         "description" : "Configuration key of the volume.",
                                                         "type" : "string"
                                                      },
                                                      "included" : {
                                                         "description" : "Whether the volume is included in the backup or not.",
                                                         "type" : "boolean"
                                                      },
                                                      "name" : {
                                                         "description" : "Name of the volume.",
                                                         "type" : "string"
                                                      },
                                                      "reason" : {
                                                         "description" : "The reason why the volume is included (or excluded).",
                                                         "type" : "string"
                                                      }
                                                   },
                                                   "type" : "object"
                                                },
                                                "optional" : 1,
                                                "type" : "array"
                                             },
                                             "id" : {
                                                "description" : "VMID of the guest.",
                                                "type" : "integer"
                                             },
                                             "name" : {
                                                "description" : "Name of the guest",
                                                "optional" : 1,
                                                "type" : "string"
                                             },
                                             "type" : {
                                                "description" : "Type of the guest, VM, CT or unknown for removed but not purged guests.",
                                                "enum" : [
                                                   "qemu",
                                                   "lxc",
                                                   "unknown"
                                                ],
                                                "type" : "string"
                                             }
                                          },
                                          "type" : "object"
                                       },
                                       "type" : "array"
                                    }
                                 },
                                 "type" : "object"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/backup/{id}/included_volumes",
                        "text" : "included_volumes"
                     }
                  ],
                  "info" : {
                     "DELETE" : {
                        "allowtoken" : 1,
                        "description" : "Delete vzdump backup job definition.",
                        "method" : "DELETE",
                        "name" : "delete_job",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "id" : {
                                 "description" : "The job ID.",
                                 "maxLength" : 50,
                                 "pattern" : "\\S+",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     },
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Read vzdump backup job definition.",
                        "method" : "GET",
                        "name" : "read_job",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "id" : {
                                 "description" : "The job ID.",
                                 "maxLength" : 50,
                                 "pattern" : "\\S+",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "type" : "object"
                        }
                     },
                     "PUT" : {
                        "allowtoken" : 1,
                        "description" : "Update vzdump backup job definition.",
                        "method" : "PUT",
                        "name" : "update_job",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "all" : {
                                 "default" : 0,
                                 "description" : "Backup all known guest systems on this host.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "bwlimit" : {
                                 "default" : 0,
                                 "description" : "Limit I/O bandwidth (in KiB/s).",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "comment" : {
                                 "description" : "Description for the Job.",
                                 "maxLength" : 512,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "compress" : {
                                 "default" : "0",
                                 "description" : "Compress dump file.",
                                 "enum" : [
                                    "0",
                                    "1",
                                    "gzip",
                                    "lzo",
                                    "zstd"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "delete" : {
                                 "description" : "A list of settings you want to delete.",
                                 "format" : "pve-configid-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "dow" : {
                                 "description" : "Day of week selection.",
                                 "format" : "pve-day-of-week-list",
                                 "optional" : 1,
                                 "requires" : "starttime",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "dumpdir" : {
                                 "description" : "Store resulting files to specified directory.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "enabled" : {
                                 "default" : "1",
                                 "description" : "Enable or disable the job.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "exclude" : {
                                 "description" : "Exclude specified guest systems (assumes --all)",
                                 "format" : "pve-vmid-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "exclude-path" : {
                                 "description" : "Exclude certain files/directories (shell globs). Paths starting with '/' are anchored to the container's root, other paths match relative to each subdirectory.",
                                 "items" : {
                                    "type" : "string"
                                 },
                                 "optional" : 1,
                                 "type" : "array",
                                 "typetext" : "<array>"
                              },
                              "fleecing" : {
                                 "description" : "Options for backup fleecing (VM only).",
                                 "format" : "backup-fleecing",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "[[enabled=]<1|0>] [,storage=<storage ID>]"
                              },
                              "id" : {
                                 "description" : "The job ID.",
                                 "maxLength" : 50,
                                 "pattern" : "\\S+",
                                 "type" : "string"
                              },
                              "ionice" : {
                                 "default" : 7,
                                 "description" : "Set IO priority when using the BFQ scheduler. For snapshot and suspend mode backups of VMs, this only affects the compressor. A value of 8 means the idle priority is used, otherwise the best-effort priority is used with the specified value.",
                                 "maximum" : 8,
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - 8)"
                              },
                              "lockwait" : {
                                 "default" : 180,
                                 "description" : "Maximal time to wait for the global lock (minutes).",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "mailnotification" : {
                                 "default" : "always",
                                 "description" : "Deprecated: use notification targets/matchers instead. Specify when to send a notification mail",
                                 "enum" : [
                                    "always",
                                    "failure"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "mailto" : {
                                 "description" : "Deprecated: Use notification targets/matchers instead. Comma-separated list of email addresses or users that should receive email notifications.",
                                 "format" : "email-or-username-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "maxfiles" : {
                                 "description" : "Deprecated: use 'prune-backups' instead. Maximal number of backup files per guest system.",
                                 "minimum" : 1,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (1 - N)"
                              },
                              "mode" : {
                                 "default" : "snapshot",
                                 "description" : "Backup mode.",
                                 "enum" : [
                                    "snapshot",
                                    "suspend",
                                    "stop"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "node" : {
                                 "description" : "Only run if executed on this node.",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "notes-template" : {
                                 "description" : "Template string for generating notes for the backup(s). It can contain variables which will be replaced by their values. Currently supported are {{cluster}}, {{guestname}}, {{node}}, and {{vmid}}, but more might be added in the future. Needs to be a single line, newline and backslash need to be escaped as '\\n' and '\\\\' respectively.",
                                 "maxLength" : 1024,
                                 "optional" : 1,
                                 "requires" : "storage",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "notification-mode" : {
                                 "default" : "auto",
                                 "description" : "Determine which notification system to use. If set to 'legacy-sendmail', vzdump will consider the mailto/mailnotification parameters and send emails to the specified address(es) via the 'sendmail' command. If set to 'notification-system', a notification will be sent via PVE's notification system, and the mailto and mailnotification will be ignored. If set to 'auto' (default setting), an email will be sent if mailto is set, and the notification system will be used if not.",
                                 "enum" : [
                                    "auto",
                                    "legacy-sendmail",
                                    "notification-system"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "notification-policy" : {
                                 "default" : "always",
                                 "description" : "Deprecated: Do not use",
                                 "enum" : [
                                    "always",
                                    "failure",
                                    "never"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "notification-target" : {
                                 "description" : "Deprecated: Do not use",
                                 "format" : "pve-configid",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "pbs-change-detection-mode" : {
                                 "description" : "PBS mode used to detect file changes and switch encoding format for container backups.",
                                 "enum" : [
                                    "legacy",
                                    "data",
                                    "metadata"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "performance" : {
                                 "description" : "Other performance-related settings.",
                                 "format" : "backup-performance",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "[max-workers=<integer>] [,pbs-entries-max=<integer>]"
                              },
                              "pigz" : {
                                 "default" : 0,
                                 "description" : "Use pigz instead of gzip when N>0. N=1 uses half of cores, N>1 uses N as thread count.",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "pool" : {
                                 "description" : "Backup all known guest systems included in the specified pool.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "protected" : {
                                 "description" : "If true, mark backup(s) as protected.",
                                 "optional" : 1,
                                 "requires" : "storage",
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "prune-backups" : {
                                 "default" : "keep-all=1",
                                 "description" : "Use these retention options instead of those from the storage configuration.",
                                 "format" : "prune-backups",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "[keep-all=<1|0>] [,keep-daily=<N>] [,keep-hourly=<N>] [,keep-last=<N>] [,keep-monthly=<N>] [,keep-weekly=<N>] [,keep-yearly=<N>]"
                              },
                              "quiet" : {
                                 "default" : 0,
                                 "description" : "Be quiet.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "remove" : {
                                 "default" : 1,
                                 "description" : "Prune older backups according to 'prune-backups'.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "repeat-missed" : {
                                 "default" : 0,
                                 "description" : "If true, the job will be run as soon as possible if it was missed while the scheduler was not running.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "schedule" : {
                                 "description" : "Backup schedule. The format is a subset of `systemd` calendar events.",
                                 "format" : "pve-calendar-event",
                                 "maxLength" : 128,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "script" : {
                                 "description" : "Use specified hook script.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "starttime" : {
                                 "description" : "Job Start time.",
                                 "optional" : 1,
                                 "pattern" : "\\d{1,2}:\\d{1,2}",
                                 "type" : "string",
                                 "typetext" : "HH:MM"
                              },
                              "stdexcludes" : {
                                 "default" : 1,
                                 "description" : "Exclude temporary files and logs.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "stop" : {
                                 "default" : 0,
                                 "description" : "Stop running backup jobs on this host.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "stopwait" : {
                                 "default" : 10,
                                 "description" : "Maximal time to wait until a guest system is stopped (minutes).",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "storage" : {
                                 "description" : "Store resulting file to this storage.",
                                 "format" : "pve-storage-id",
                                 "format_description" : "storage ID",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<storage ID>"
                              },
                              "tmpdir" : {
                                 "description" : "Store temporary files to specified directory.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "vmid" : {
                                 "description" : "The ID of the guest system you want to backup.",
                                 "format" : "pve-vmid-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "zstd" : {
                                 "default" : 1,
                                 "description" : "Zstd threads. N=0 uses half of the available cores, if N is set to a value bigger than 0, N is used as thread count.",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ],
                           "description" : "The 'tmpdir', 'dumpdir' and 'script' parameters are additionally restricted to the 'root@pam' user."
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/backup/{id}",
                  "text" : "{id}"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "List vzdump backup schedule.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/",
                        [
                           "Sys.Audit"
                        ]
                     ]
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {
                           "id" : {
                              "description" : "The job ID.",
                              "maxLength" : 50,
                              "pattern" : "\\S+",
                              "type" : "string"
                           }
                        },
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{id}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               },
               "POST" : {
                  "allowtoken" : 1,
                  "description" : "Create new vzdump backup job.",
                  "method" : "POST",
                  "name" : "create_job",
                  "parameters" : {
                     "additionalProperties" : 0,
                     "properties" : {
                        "all" : {
                           "default" : 0,
                           "description" : "Backup all known guest systems on this host.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "bwlimit" : {
                           "default" : 0,
                           "description" : "Limit I/O bandwidth (in KiB/s).",
                           "minimum" : 0,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (0 - N)"
                        },
                        "comment" : {
                           "description" : "Description for the Job.",
                           "maxLength" : 512,
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "compress" : {
                           "default" : "0",
                           "description" : "Compress dump file.",
                           "enum" : [
                              "0",
                              "1",
                              "gzip",
                              "lzo",
                              "zstd"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "dow" : {
                           "default" : "mon,tue,wed,thu,fri,sat,sun",
                           "description" : "Day of week selection.",
                           "format" : "pve-day-of-week-list",
                           "optional" : 1,
                           "requires" : "starttime",
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "dumpdir" : {
                           "description" : "Store resulting files to specified directory.",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "enabled" : {
                           "default" : "1",
                           "description" : "Enable or disable the job.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "exclude" : {
                           "description" : "Exclude specified guest systems (assumes --all)",
                           "format" : "pve-vmid-list",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "exclude-path" : {
                           "description" : "Exclude certain files/directories (shell globs). Paths starting with '/' are anchored to the container's root, other paths match relative to each subdirectory.",
                           "items" : {
                              "type" : "string"
                           },
                           "optional" : 1,
                           "type" : "array",
                           "typetext" : "<array>"
                        },
                        "fleecing" : {
                           "description" : "Options for backup fleecing (VM only).",
                           "format" : "backup-fleecing",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[[enabled=]<1|0>] [,storage=<storage ID>]"
                        },
                        "id" : {
                           "description" : "Job ID (will be autogenerated).",
                           "format" : "pve-configid",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "ionice" : {
                           "default" : 7,
                           "description" : "Set IO priority when using the BFQ scheduler. For snapshot and suspend mode backups of VMs, this only affects the compressor. A value of 8 means the idle priority is used, otherwise the best-effort priority is used with the specified value.",
                           "maximum" : 8,
                           "minimum" : 0,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (0 - 8)"
                        },
                        "lockwait" : {
                           "default" : 180,
                           "description" : "Maximal time to wait for the global lock (minutes).",
                           "minimum" : 0,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (0 - N)"
                        },
                        "mailnotification" : {
                           "default" : "always",
                           "description" : "Deprecated: use notification targets/matchers instead. Specify when to send a notification mail",
                           "enum" : [
                              "always",
                              "failure"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "mailto" : {
                           "description" : "Deprecated: Use notification targets/matchers instead. Comma-separated list of email addresses or users that should receive email notifications.",
                           "format" : "email-or-username-list",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "maxfiles" : {
                           "description" : "Deprecated: use 'prune-backups' instead. Maximal number of backup files per guest system.",
                           "minimum" : 1,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (1 - N)"
                        },
                        "mode" : {
                           "default" : "snapshot",
                           "description" : "Backup mode.",
                           "enum" : [
                              "snapshot",
                              "suspend",
                              "stop"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "node" : {
                           "description" : "Only run if executed on this node.",
                           "format" : "pve-node",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "notes-template" : {
                           "description" : "Template string for generating notes for the backup(s). It can contain variables which will be replaced by their values. Currently supported are {{cluster}}, {{guestname}}, {{node}}, and {{vmid}}, but more might be added in the future. Needs to be a single line, newline and backslash need to be escaped as '\\n' and '\\\\' respectively.",
                           "maxLength" : 1024,
                           "optional" : 1,
                           "requires" : "storage",
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "notification-mode" : {
                           "default" : "auto",
                           "description" : "Determine which notification system to use. If set to 'legacy-sendmail', vzdump will consider the mailto/mailnotification parameters and send emails to the specified address(es) via the 'sendmail' command. If set to 'notification-system', a notification will be sent via PVE's notification system, and the mailto and mailnotification will be ignored. If set to 'auto' (default setting), an email will be sent if mailto is set, and the notification system will be used if not.",
                           "enum" : [
                              "auto",
                              "legacy-sendmail",
                              "notification-system"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "notification-policy" : {
                           "default" : "always",
                           "description" : "Deprecated: Do not use",
                           "enum" : [
                              "always",
                              "failure",
                              "never"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "notification-target" : {
                           "description" : "Deprecated: Do not use",
                           "format" : "pve-configid",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "pbs-change-detection-mode" : {
                           "description" : "PBS mode used to detect file changes and switch encoding format for container backups.",
                           "enum" : [
                              "legacy",
                              "data",
                              "metadata"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "performance" : {
                           "description" : "Other performance-related settings.",
                           "format" : "backup-performance",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[max-workers=<integer>] [,pbs-entries-max=<integer>]"
                        },
                        "pigz" : {
                           "default" : 0,
                           "description" : "Use pigz instead of gzip when N>0. N=1 uses half of cores, N>1 uses N as thread count.",
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer>"
                        },
                        "pool" : {
                           "description" : "Backup all known guest systems included in the specified pool.",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "protected" : {
                           "description" : "If true, mark backup(s) as protected.",
                           "optional" : 1,
                           "requires" : "storage",
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "prune-backups" : {
                           "default" : "keep-all=1",
                           "description" : "Use these retention options instead of those from the storage configuration.",
                           "format" : "prune-backups",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[keep-all=<1|0>] [,keep-daily=<N>] [,keep-hourly=<N>] [,keep-last=<N>] [,keep-monthly=<N>] [,keep-weekly=<N>] [,keep-yearly=<N>]"
                        },
                        "quiet" : {
                           "default" : 0,
                           "description" : "Be quiet.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "remove" : {
                           "default" : 1,
                           "description" : "Prune older backups according to 'prune-backups'.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "repeat-missed" : {
                           "default" : 0,
                           "description" : "If true, the job will be run as soon as possible if it was missed while the scheduler was not running.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "schedule" : {
                           "description" : "Backup schedule. The format is a subset of `systemd` calendar events.",
                           "format" : "pve-calendar-event",
                           "maxLength" : 128,
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "script" : {
                           "description" : "Use specified hook script.",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "starttime" : {
                           "description" : "Job Start time.",
                           "optional" : 1,
                           "pattern" : "\\d{1,2}:\\d{1,2}",
                           "type" : "string",
                           "typetext" : "HH:MM"
                        },
                        "stdexcludes" : {
                           "default" : 1,
                           "description" : "Exclude temporary files and logs.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "stop" : {
                           "default" : 0,
                           "description" : "Stop running backup jobs on this host.",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "stopwait" : {
                           "default" : 10,
                           "description" : "Maximal time to wait until a guest system is stopped (minutes).",
                           "minimum" : 0,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (0 - N)"
                        },
                        "storage" : {
                           "description" : "Store resulting file to this storage.",
                           "format" : "pve-storage-id",
                           "format_description" : "storage ID",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<storage ID>"
                        },
                        "tmpdir" : {
                           "description" : "Store temporary files to specified directory.",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "vmid" : {
                           "description" : "The ID of the guest system you want to backup.",
                           "format" : "pve-vmid-list",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "zstd" : {
                           "default" : 1,
                           "description" : "Zstd threads. N=0 uses half of the available cores, if N is set to a value bigger than 0, N is used as thread count.",
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer>"
                        }
                     }
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/",
                        [
                           "Sys.Modify"
                        ]
                     ],
                     "description" : "The 'tmpdir', 'dumpdir' and 'script' parameters are additionally restricted to the 'root@pam' user."
                  },
                  "protected" : 1,
                  "returns" : {
                     "type" : "null"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/backup",
            "text" : "backup"
         },
         {
            "children" : [
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Shows all guests which are not covered by any backup job.",
                        "method" : "GET",
                        "name" : "get_guests_not_in_backup",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "description" : "Contains the guest objects.",
                           "items" : {
                              "properties" : {
                                 "name" : {
                                    "description" : "Name of the guest",
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "description" : "Type of the guest.",
                                    "enum" : [
                                       "qemu",
                                       "lxc"
                                    ],
                                    "type" : "string"
                                 },
                                 "vmid" : {
                                    "description" : "VMID of the guest.",
                                    "type" : "integer"
                                 }
                              },
                              "type" : "object"
                           },
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/backup-info/not-backed-up",
                  "text" : "not-backed-up"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Index for backup info related endpoints",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "returns" : {
                     "description" : "Directory index.",
                     "items" : {
                        "properties" : {
                           "subdir" : {
                              "description" : "API sub-directory endpoint",
                              "type" : "string"
                           }
                        },
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{subdir}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/backup-info",
            "text" : "backup-info"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "info" : {
                                 "POST" : {
                                    "allowtoken" : 1,
                                    "description" : "Request resource migration (online) to another node.",
                                    "method" : "POST",
                                    "name" : "migrate",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "node" : {
                                             "description" : "Target node.",
                                             "format" : "pve-node",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "sid" : {
                                             "description" : "HA resource ID. This consists of a resource type followed by a resource specific name, separated with colon (example: vm:100 / ct:100). For virtual machines and containers, you can simply use the VM or CT id as a shortcut (example: 100).",
                                             "format" : "pve-ha-resource-or-vm-id",
                                             "type" : "string",
                                             "typetext" : "<type>:<name>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Console"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/ha/resources/{sid}/migrate",
                              "text" : "migrate"
                           },
                           {
                              "info" : {
                                 "POST" : {
                                    "allowtoken" : 1,
                                    "description" : "Request resource relocatzion to another node. This stops the service on the old node, and restarts it on the target node.",
                                    "method" : "POST",
                                    "name" : "relocate",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "node" : {
                                             "description" : "Target node.",
                                             "format" : "pve-node",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "sid" : {
                                             "description" : "HA resource ID. This consists of a resource type followed by a resource specific name, separated with colon (example: vm:100 / ct:100). For virtual machines and containers, you can simply use the VM or CT id as a shortcut (example: 100).",
                                             "format" : "pve-ha-resource-or-vm-id",
                                             "type" : "string",
                                             "typetext" : "<type>:<name>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/",
                                          [
                                             "Sys.Console"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/ha/resources/{sid}/relocate",
                              "text" : "relocate"
                           }
                        ],
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete resource configuration.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "sid" : {
                                       "description" : "HA resource ID. This consists of a resource type followed by a resource specific name, separated with colon (example: vm:100 / ct:100). For virtual machines and containers, you can simply use the VM or CT id as a shortcut (example: 100).",
                                       "format" : "pve-ha-resource-or-vm-id",
                                       "type" : "string",
                                       "typetext" : "<type>:<name>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Console"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read resource configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "sid" : {
                                       "description" : "HA resource ID. This consists of a resource type followed by a resource specific name, separated with colon (example: vm:100 / ct:100). For virtual machines and containers, you can simply use the VM or CT id as a shortcut (example: 100).",
                                       "format" : "pve-ha-resource-or-vm-id",
                                       "type" : "string",
                                       "typetext" : "<type>:<name>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Description.",
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "digest" : {
                                       "description" : "Can be used to prevent concurrent modifications.",
                                       "type" : "string"
                                    },
                                    "group" : {
                                       "description" : "The HA group identifier.",
                                       "format" : "pve-configid",
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "max_relocate" : {
                                       "description" : "Maximal number of service relocate tries when a service failes to start.",
                                       "optional" : 1,
                                       "type" : "integer"
                                    },
                                    "max_restart" : {
                                       "description" : "Maximal number of tries to restart the service on a node after its start failed.",
                                       "optional" : 1,
                                       "type" : "integer"
                                    },
                                    "sid" : {
                                       "description" : "HA resource ID. This consists of a resource type followed by a resource specific name, separated with colon (example: vm:100 / ct:100). For virtual machines and containers, you can simply use the VM or CT id as a shortcut (example: 100).",
                                       "format" : "pve-ha-resource-or-vm-id",
                                       "type" : "string",
                                       "typetext" : "<type>:<name>"
                                    },
                                    "state" : {
                                       "description" : "Requested resource state.",
                                       "enum" : [
                                          "started",
                                          "stopped",
                                          "enabled",
                                          "disabled",
                                          "ignored"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "type" : {
                                       "description" : "The type of the resources.",
                                       "type" : "string"
                                    }
                                 },
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update resource configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Description.",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "group" : {
                                       "description" : "The HA group identifier.",
                                       "format" : "pve-configid",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "max_relocate" : {
                                       "default" : 1,
                                       "description" : "Maximal number of service relocate tries when a service failes to start.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "max_restart" : {
                                       "default" : 1,
                                       "description" : "Maximal number of tries to restart the service on a node after its start failed.",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "sid" : {
                                       "description" : "HA resource ID. This consists of a resource type followed by a resource specific name, separated with colon (example: vm:100 / ct:100). For virtual machines and containers, you can simply use the VM or CT id as a shortcut (example: 100).",
                                       "format" : "pve-ha-resource-or-vm-id",
                                       "type" : "string",
                                       "typetext" : "<type>:<name>"
                                    },
                                    "state" : {
                                       "default" : "started",
                                       "description" : "Requested resource state.",
                                       "enum" : [
                                          "started",
                                          "stopped",
                                          "enabled",
                                          "disabled",
                                          "ignored"
                                       ],
                                       "optional" : 1,
                                       "type" : "string",
                                       "verbose_description" : "Requested resource state. The CRM reads this state and acts accordingly.\nPlease note that `enabled` is just an alias for `started`.\n\n`started`;;\n\nThe CRM tries to start the resource. Service state is\nset to `started` after successful start. On node failures, or when start\nfails, it tries to recover the resource.  If everything fails, service\nstate it set to `error`.\n\n`stopped`;;\n\nThe CRM tries to keep the resource in `stopped` state, but it\nstill tries to relocate the resources on node failures.\n\n`disabled`;;\n\nThe CRM tries to put the resource in `stopped` state, but does not try\nto relocate the resources on node failures. The main purpose of this\nstate is error recovery, because it is the only way to move a resource out\nof the `error` state.\n\n`ignored`;;\n\nThe resource gets removed from the manager status and so the CRM and the LRM do\nnot touch the resource anymore. All {pve} API calls affecting this resource\nwill be executed, directly bypassing the HA stack. CRM commands will be thrown\naway while there source is in this state. The resource will not get relocated\non node failures.\n\n"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Console"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/ha/resources/{sid}",
                        "text" : "{sid}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List HA resources.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "type" : {
                                 "description" : "Only list resources of specific type",
                                 "enum" : [
                                    "ct",
                                    "vm"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "sid" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{sid}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new HA resource.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "comment" : {
                                 "description" : "Description.",
                                 "maxLength" : 4096,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "group" : {
                                 "description" : "The HA group identifier.",
                                 "format" : "pve-configid",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "max_relocate" : {
                                 "default" : 1,
                                 "description" : "Maximal number of service relocate tries when a service failes to start.",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "max_restart" : {
                                 "default" : 1,
                                 "description" : "Maximal number of tries to restart the service on a node after its start failed.",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "sid" : {
                                 "description" : "HA resource ID. This consists of a resource type followed by a resource specific name, separated with colon (example: vm:100 / ct:100). For virtual machines and containers, you can simply use the VM or CT id as a shortcut (example: 100).",
                                 "format" : "pve-ha-resource-or-vm-id",
                                 "type" : "string",
                                 "typetext" : "<type>:<name>"
                              },
                              "state" : {
                                 "default" : "started",
                                 "description" : "Requested resource state.",
                                 "enum" : [
                                    "started",
                                    "stopped",
                                    "enabled",
                                    "disabled",
                                    "ignored"
                                 ],
                                 "optional" : 1,
                                 "type" : "string",
                                 "verbose_description" : "Requested resource state. The CRM reads this state and acts accordingly.\nPlease note that `enabled` is just an alias for `started`.\n\n`started`;;\n\nThe CRM tries to start the resource. Service state is\nset to `started` after successful start. On node failures, or when start\nfails, it tries to recover the resource.  If everything fails, service\nstate it set to `error`.\n\n`stopped`;;\n\nThe CRM tries to keep the resource in `stopped` state, but it\nstill tries to relocate the resources on node failures.\n\n`disabled`;;\n\nThe CRM tries to put the resource in `stopped` state, but does not try\nto relocate the resources on node failures. The main purpose of this\nstate is error recovery, because it is the only way to move a resource out\nof the `error` state.\n\n`ignored`;;\n\nThe resource gets removed from the manager status and so the CRM and the LRM do\nnot touch the resource anymore. All {pve} API calls affecting this resource\nwill be executed, directly bypassing the HA stack. CRM commands will be thrown\naway while there source is in this state. The resource will not get relocated\non node failures.\n\n"
                              },
                              "type" : {
                                 "description" : "Resource type.",
                                 "enum" : [
                                    "ct",
                                    "vm"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Console"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/ha/resources",
                  "text" : "resources"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete ha group configuration.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "group" : {
                                       "description" : "The HA group identifier.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Console"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read ha group configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "group" : {
                                       "description" : "The HA group identifier.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {}
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update ha group configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Description.",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "group" : {
                                       "description" : "The HA group identifier.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "nodes" : {
                                       "description" : "List of cluster node names with optional priority.",
                                       "format" : "pve-ha-group-node-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<node>[:<pri>]{,<node>[:<pri>]}*",
                                       "verbose_description" : "List of cluster node members, where a priority can be given to each node. A resource bound to a group will run on the available nodes with the highest priority. If there are more nodes in the highest priority class, the services will get distributed to those nodes. The priorities have a relative meaning only. The higher the number, the higher the priority."
                                    },
                                    "nofailback" : {
                                       "default" : 0,
                                       "description" : "The CRM tries to run services on the node with the highest priority. If a node with higher priority comes online, the CRM migrates the service to that node. Enabling nofailback prevents that behavior.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "restricted" : {
                                       "default" : 0,
                                       "description" : "Resources bound to restricted groups may only run on nodes defined by the group.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>",
                                       "verbose_description" : "Resources bound to restricted groups may only run on nodes defined by the group. The resource will be placed in the stopped state if no group node member is online. Resources on unrestricted groups may run on any cluster node if all group members are offline, but they will migrate back as soon as a group member comes online. One can implement a 'preferred node' behavior using an unrestricted group with only one member."
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Console"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/ha/groups/{group}",
                        "text" : "{group}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get HA groups.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "group" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{group}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new HA group.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "comment" : {
                                 "description" : "Description.",
                                 "maxLength" : 4096,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "group" : {
                                 "description" : "The HA group identifier.",
                                 "format" : "pve-configid",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "nodes" : {
                                 "description" : "List of cluster node names with optional priority.",
                                 "format" : "pve-ha-group-node-list",
                                 "optional" : 0,
                                 "type" : "string",
                                 "typetext" : "<node>[:<pri>]{,<node>[:<pri>]}*",
                                 "verbose_description" : "List of cluster node members, where a priority can be given to each node. A resource bound to a group will run on the available nodes with the highest priority. If there are more nodes in the highest priority class, the services will get distributed to those nodes. The priorities have a relative meaning only. The higher the number, the higher the priority."
                              },
                              "nofailback" : {
                                 "default" : 0,
                                 "description" : "The CRM tries to run services on the node with the highest priority. If a node with higher priority comes online, the CRM migrates the service to that node. Enabling nofailback prevents that behavior.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "restricted" : {
                                 "default" : 0,
                                 "description" : "Resources bound to restricted groups may only run on nodes defined by the group.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>",
                                 "verbose_description" : "Resources bound to restricted groups may only run on nodes defined by the group. The resource will be placed in the stopped state if no group node member is online. Resources on unrestricted groups may run on any cluster node if all group members are offline, but they will migrate back as soon as a group member comes online. One can implement a 'preferred node' behavior using an unrestricted group with only one member."
                              },
                              "type" : {
                                 "description" : "Group type.",
                                 "enum" : [
                                    "group"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Console"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/ha/groups",
                  "text" : "groups"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get HA manger status.",
                              "method" : "GET",
                              "name" : "status",
                              "parameters" : {
                                 "additionalProperties" : 0
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "items" : {
                                    "properties" : {
                                       "crm_state" : {
                                          "description" : "For type 'service'. Service state as seen by the CRM.",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "id" : {
                                          "description" : "Status entry ID (quorum, master, lrm:<node>, service:<sid>).",
                                          "type" : "string"
                                       },
                                       "max_relocate" : {
                                          "description" : "For type 'service'.",
                                          "optional" : 1,
                                          "type" : "integer"
                                       },
                                       "max_restart" : {
                                          "description" : "For type 'service'.",
                                          "optional" : 1,
                                          "type" : "integer"
                                       },
                                       "node" : {
                                          "description" : "Node associated to status entry.",
                                          "type" : "string"
                                       },
                                       "quorate" : {
                                          "description" : "For type 'quorum'. Whether the cluster is quorate or not.",
                                          "optional" : 1,
                                          "type" : "boolean"
                                       },
                                       "request_state" : {
                                          "description" : "For type 'service'. Requested service state.",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "sid" : {
                                          "description" : "For type 'service'. Service ID.",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "state" : {
                                          "description" : "For type 'service'. Verbose service state.",
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "status" : {
                                          "description" : "Status of the entry (value depends on type).",
                                          "type" : "string"
                                       },
                                       "timestamp" : {
                                          "description" : "For type 'lrm','master'. Timestamp of the status information.",
                                          "optional" : 1,
                                          "type" : "integer"
                                       },
                                       "type" : {
                                          "description" : "Type of status entry.",
                                          "enum" : [
                                             "quorum",
                                             "master",
                                             "lrm",
                                             "service"
                                          ]
                                       }
                                    },
                                    "type" : "object"
                                 },
                                 "type" : "array"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/ha/status/current",
                        "text" : "current"
                     },
                     {
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get full HA manger status, including LRM status.",
                              "method" : "GET",
                              "name" : "manager_status",
                              "parameters" : {
                                 "additionalProperties" : 0
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/ha/status/manager_status",
                        "text" : "manager_status"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Directory index.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {},
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/ha/status",
                  "text" : "status"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Directory index.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/",
                        [
                           "Sys.Audit"
                        ]
                     ]
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {
                           "id" : {
                              "type" : "string"
                           }
                        },
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{id}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/ha",
            "text" : "ha"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete ACME plugin configuration.",
                              "method" : "DELETE",
                              "name" : "delete_plugin",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "description" : "Unique identifier for ACME plugin instance.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get ACME plugin configuration.",
                              "method" : "GET",
                              "name" : "get_plugin_config",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "description" : "Unique identifier for ACME plugin instance.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update ACME plugin configuration.",
                              "method" : "PUT",
                              "name" : "update_plugin",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "api" : {
                                       "description" : "API plugin name",
                                       "enum" : [
                                          "1984hosting",
                                          "acmedns",
                                          "acmeproxy",
                                          "active24",
                                          "ad",
                                          "ali",
                                          "alviy",
                                          "anx",
                                          "artfiles",
                                          "arvan",
                                          "aurora",
                                          "autodns",
                                          "aws",
                                          "azion",
                                          "azure",
                                          "bookmyname",
                                          "bunny",
                                          "cf",
                                          "clouddns",
                                          "cloudns",
                                          "cn",
                                          "conoha",
                                          "constellix",
                                          "cpanel",
                                          "curanet",
                                          "cyon",
                                          "da",
                                          "ddnss",
                                          "desec",
                                          "df",
                                          "dgon",
                                          "dnsexit",
                                          "dnshome",
                                          "dnsimple",
                                          "dnsservices",
                                          "doapi",
                                          "domeneshop",
                                          "dp",
                                          "dpi",
                                          "dreamhost",
                                          "duckdns",
                                          "durabledns",
                                          "dyn",
                                          "dynu",
                                          "dynv6",
                                          "easydns",
                                          "edgedns",
                                          "euserv",
                                          "exoscale",
                                          "fornex",
                                          "freedns",
                                          "gandi_livedns",
                                          "gcloud",
                                          "gcore",
                                          "gd",
                                          "geoscaling",
                                          "googledomains",
                                          "he",
                                          "hetzner",
                                          "hexonet",
                                          "hostingde",
                                          "huaweicloud",
                                          "infoblox",
                                          "infomaniak",
                                          "internetbs",
                                          "inwx",
                                          "ionos",
                                          "ionos_cloud",
                                          "ipv64",
                                          "ispconfig",
                                          "jd",
                                          "joker",
                                          "kappernet",
                                          "kas",
                                          "kinghost",
                                          "knot",
                                          "la",
                                          "leaseweb",
                                          "lexicon",
                                          "limacity",
                                          "linode",
                                          "linode_v4",
                                          "loopia",
                                          "lua",
                                          "maradns",
                                          "me",
                                          "miab",
                                          "misaka",
                                          "myapi",
                                          "mydevil",
                                          "mydnsjp",
                                          "mythic_beasts",
                                          "namecheap",
                                          "namecom",
                                          "namesilo",
                                          "nanelo",
                                          "nederhost",
                                          "neodigit",
                                          "netcup",
                                          "netlify",
                                          "nic",
                                          "njalla",
                                          "nm",
                                          "nsd",
                                          "nsone",
                                          "nsupdate",
                                          "nw",
                                          "oci",
                                          "omglol",
                                          "one",
                                          "online",
                                          "openprovider",
                                          "openstack",
                                          "opnsense",
                                          "ovh",
                                          "pdns",
                                          "pleskxml",
                                          "pointhq",
                                          "porkbun",
                                          "rackcorp",
                                          "rackspace",
                                          "rage4",
                                          "rcode0",
                                          "regru",
                                          "scaleway",
                                          "schlundtech",
                                          "selectel",
                                          "selfhost",
                                          "servercow",
                                          "simply",
                                          "technitium",
                                          "tele3",
                                          "tencent",
                                          "timeweb",
                                          "transip",
                                          "udr",
                                          "ultra",
                                          "unoeuro",
                                          "variomedia",
                                          "veesp",
                                          "vercel",
                                          "vscale",
                                          "vultr",
                                          "websupport",
                                          "west_cn",
                                          "world4you",
                                          "yandex360",
                                          "yc",
                                          "zilore",
                                          "zone",
                                          "zoneedit",
                                          "zonomi"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "data" : {
                                       "description" : "DNS plugin data. (base64 encoded)",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable" : {
                                       "description" : "Flag to disable the config.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "id" : {
                                       "description" : "ACME Plugin ID name",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "nodes" : {
                                       "description" : "List of cluster node names.",
                                       "format" : "pve-node-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "validation-delay" : {
                                       "default" : 30,
                                       "description" : "Extra delay in seconds to wait before requesting validation. Allows to cope with a long TTL of DNS records.",
                                       "maximum" : 172800,
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - 172800)"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/acme/plugins/{id}",
                        "text" : "{id}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "ACME plugin index.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "type" : {
                                 "description" : "Only list ACME plugins of a specific type",
                                 "enum" : [
                                    "dns",
                                    "standalone"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "plugin" : {
                                    "description" : "Unique identifier for ACME plugin instance.",
                                    "format" : "pve-configid",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{plugin}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Add ACME plugin configuration.",
                        "method" : "POST",
                        "name" : "add_plugin",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "api" : {
                                 "description" : "API plugin name",
                                 "enum" : [
                                    "1984hosting",
                                    "acmedns",
                                    "acmeproxy",
                                    "active24",
                                    "ad",
                                    "ali",
                                    "alviy",
                                    "anx",
                                    "artfiles",
                                    "arvan",
                                    "aurora",
                                    "autodns",
                                    "aws",
                                    "azion",
                                    "azure",
                                    "bookmyname",
                                    "bunny",
                                    "cf",
                                    "clouddns",
                                    "cloudns",
                                    "cn",
                                    "conoha",
                                    "constellix",
                                    "cpanel",
                                    "curanet",
                                    "cyon",
                                    "da",
                                    "ddnss",
                                    "desec",
                                    "df",
                                    "dgon",
                                    "dnsexit",
                                    "dnshome",
                                    "dnsimple",
                                    "dnsservices",
                                    "doapi",
                                    "domeneshop",
                                    "dp",
                                    "dpi",
                                    "dreamhost",
                                    "duckdns",
                                    "durabledns",
                                    "dyn",
                                    "dynu",
                                    "dynv6",
                                    "easydns",
                                    "edgedns",
                                    "euserv",
                                    "exoscale",
                                    "fornex",
                                    "freedns",
                                    "gandi_livedns",
                                    "gcloud",
                                    "gcore",
                                    "gd",
                                    "geoscaling",
                                    "googledomains",
                                    "he",
                                    "hetzner",
                                    "hexonet",
                                    "hostingde",
                                    "huaweicloud",
                                    "infoblox",
                                    "infomaniak",
                                    "internetbs",
                                    "inwx",
                                    "ionos",
                                    "ionos_cloud",
                                    "ipv64",
                                    "ispconfig",
                                    "jd",
                                    "joker",
                                    "kappernet",
                                    "kas",
                                    "kinghost",
                                    "knot",
                                    "la",
                                    "leaseweb",
                                    "lexicon",
                                    "limacity",
                                    "linode",
                                    "linode_v4",
                                    "loopia",
                                    "lua",
                                    "maradns",
                                    "me",
                                    "miab",
                                    "misaka",
                                    "myapi",
                                    "mydevil",
                                    "mydnsjp",
                                    "mythic_beasts",
                                    "namecheap",
                                    "namecom",
                                    "namesilo",
                                    "nanelo",
                                    "nederhost",
                                    "neodigit",
                                    "netcup",
                                    "netlify",
                                    "nic",
                                    "njalla",
                                    "nm",
                                    "nsd",
                                    "nsone",
                                    "nsupdate",
                                    "nw",
                                    "oci",
                                    "omglol",
                                    "one",
                                    "online",
                                    "openprovider",
                                    "openstack",
                                    "opnsense",
                                    "ovh",
                                    "pdns",
                                    "pleskxml",
                                    "pointhq",
                                    "porkbun",
                                    "rackcorp",
                                    "rackspace",
                                    "rage4",
                                    "rcode0",
                                    "regru",
                                    "scaleway",
                                    "schlundtech",
                                    "selectel",
                                    "selfhost",
                                    "servercow",
                                    "simply",
                                    "technitium",
                                    "tele3",
                                    "tencent",
                                    "timeweb",
                                    "transip",
                                    "udr",
                                    "ultra",
                                    "unoeuro",
                                    "variomedia",
                                    "veesp",
                                    "vercel",
                                    "vscale",
                                    "vultr",
                                    "websupport",
                                    "west_cn",
                                    "world4you",
                                    "yandex360",
                                    "yc",
                                    "zilore",
                                    "zone",
                                    "zoneedit",
                                    "zonomi"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "data" : {
                                 "description" : "DNS plugin data. (base64 encoded)",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "disable" : {
                                 "description" : "Flag to disable the config.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "id" : {
                                 "description" : "ACME Plugin ID name",
                                 "format" : "pve-configid",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "nodes" : {
                                 "description" : "List of cluster node names.",
                                 "format" : "pve-node-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "type" : {
                                 "description" : "ACME challenge type.",
                                 "enum" : [
                                    "dns",
                                    "standalone"
                                 ],
                                 "type" : "string"
                              },
                              "validation-delay" : {
                                 "default" : 30,
                                 "description" : "Extra delay in seconds to wait before requesting validation. Allows to cope with a long TTL of DNS records.",
                                 "maximum" : 172800,
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - 172800)"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/acme/plugins",
                  "text" : "plugins"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Deactivate existing ACME account at CA.",
                              "method" : "DELETE",
                              "name" : "deactivate_account",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "name" : {
                                       "default" : "default",
                                       "description" : "ACME account config file name.",
                                       "format" : "pve-configid",
                                       "format_description" : "name",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<name>"
                                    }
                                 }
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "string"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Return existing ACME account information.",
                              "method" : "GET",
                              "name" : "get_account",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "name" : {
                                       "default" : "default",
                                       "description" : "ACME account config file name.",
                                       "format" : "pve-configid",
                                       "format_description" : "name",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<name>"
                                    }
                                 }
                              },
                              "protected" : 1,
                              "returns" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "account" : {
                                       "optional" : 1,
                                       "renderer" : "yaml",
                                       "type" : "object"
                                    },
                                    "directory" : {
                                       "description" : "URL of ACME CA directory endpoint.",
                                       "optional" : 1,
                                       "pattern" : "^https?://.*",
                                       "type" : "string"
                                    },
                                    "location" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "tos" : {
                                       "optional" : 1,
                                       "type" : "string"
                                    }
                                 },
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update existing ACME account information with CA. Note: not specifying any new account information triggers a refresh.",
                              "method" : "PUT",
                              "name" : "update_account",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "contact" : {
                                       "description" : "Contact email addresses.",
                                       "format" : "email-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "name" : {
                                       "default" : "default",
                                       "description" : "ACME account config file name.",
                                       "format" : "pve-configid",
                                       "format_description" : "name",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<name>"
                                    }
                                 }
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "string"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/acme/account/{name}",
                        "text" : "{name}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "ACMEAccount index.",
                        "method" : "GET",
                        "name" : "account_index",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "protected" : 1,
                        "returns" : {
                           "items" : {
                              "properties" : {},
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Register a new ACME account with CA.",
                        "method" : "POST",
                        "name" : "register_account",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "contact" : {
                                 "description" : "Contact email addresses.",
                                 "format" : "email-list",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "directory" : {
                                 "default" : "https://acme-v02.api.letsencrypt.org/directory",
                                 "description" : "URL of ACME CA directory endpoint.",
                                 "optional" : 1,
                                 "pattern" : "^https?://.*",
                                 "type" : "string"
                              },
                              "eab-hmac-key" : {
                                 "description" : "HMAC key for External Account Binding.",
                                 "optional" : 1,
                                 "requires" : "eab-kid",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "eab-kid" : {
                                 "description" : "Key Identifier for External Account Binding.",
                                 "optional" : 1,
                                 "requires" : "eab-hmac-key",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "name" : {
                                 "default" : "default",
                                 "description" : "ACME account config file name.",
                                 "format" : "pve-configid",
                                 "format_description" : "name",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<name>"
                              },
                              "tos_url" : {
                                 "description" : "URL of CA TermsOfService - setting this indicates agreement.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           }
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "string"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/acme/account",
                  "text" : "account"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Retrieve ACME TermsOfService URL from CA. Deprecated, please use /cluster/acme/meta.",
                        "method" : "GET",
                        "name" : "get_tos",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "directory" : {
                                 "default" : "https://acme-v02.api.letsencrypt.org/directory",
                                 "description" : "URL of ACME CA directory endpoint.",
                                 "optional" : 1,
                                 "pattern" : "^https?://.*",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "description" : "ACME TermsOfService URL.",
                           "optional" : 1,
                           "type" : "string"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/acme/tos",
                  "text" : "tos"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Retrieve ACME Directory Meta Information",
                        "method" : "GET",
                        "name" : "get_meta",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "directory" : {
                                 "default" : "https://acme-v02.api.letsencrypt.org/directory",
                                 "description" : "URL of ACME CA directory endpoint.",
                                 "optional" : 1,
                                 "pattern" : "^https?://.*",
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/nodes/{node}",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "additionalProperties" : 1,
                           "properties" : {
                              "caaIdentities" : {
                                 "description" : "Hostnames referring to the ACME servers.",
                                 "items" : {
                                    "type" : "string"
                                 },
                                 "optional" : 1,
                                 "type" : "array"
                              },
                              "externalAccountRequired" : {
                                 "description" : "EAB Required",
                                 "optional" : 1,
                                 "type" : "boolean"
                              },
                              "termsOfService" : {
                                 "description" : "ACME TermsOfService URL.",
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "website" : {
                                 "description" : "URL to more information about the ACME server.",
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "type" : "object"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/acme/meta",
                  "text" : "meta"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get named known ACME directory endpoints.",
                        "method" : "GET",
                        "name" : "get_directories",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "additionalProperties" : 0,
                              "properties" : {
                                 "name" : {
                                    "type" : "string"
                                 },
                                 "url" : {
                                    "description" : "URL of ACME CA directory endpoint.",
                                    "pattern" : "^https?://.*",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/acme/directories",
                  "text" : "directories"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get schema of ACME challenge types.",
                        "method" : "GET",
                        "name" : "challengeschema",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "additionalProperties" : 0,
                              "properties" : {
                                 "id" : {
                                    "type" : "string"
                                 },
                                 "name" : {
                                    "description" : "Human readable name, falls back to id",
                                    "type" : "string"
                                 },
                                 "schema" : {
                                    "type" : "object"
                                 },
                                 "type" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/acme/challenge-schema",
                  "text" : "challenge-schema"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "ACMEAccount index.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{name}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/acme",
            "text" : "acme"
         },
         {
            "children" : [
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get ceph metadata.",
                        "method" : "GET",
                        "name" : "metadata",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "scope" : {
                                 "default" : "all",
                                 "enum" : [
                                    "all",
                                    "versions"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit",
                                 "Datastore.Audit"
                              ],
                              "any",
                              1
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "description" : "Items for each type of service containing objects for each instance.",
                           "properties" : {
                              "mds" : {
                                 "description" : "Metadata servers configured in the cluster and their properties.",
                                 "properties" : {
                                    "{id}" : {
                                       "description" : "Useful properties are listed, but not the full list.",
                                       "properties" : {
                                          "addr" : {
                                             "description" : "Bind addresses and ports.",
                                             "type" : "string"
                                          },
                                          "ceph_release" : {
                                             "description" : "Ceph release codename currently used.",
                                             "type" : "string"
                                          },
                                          "ceph_version" : {
                                             "description" : "Version info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "ceph_version_short" : {
                                             "description" : "Short version (numerical) info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "hostname" : {
                                             "description" : "Hostname on which the service is running.",
                                             "type" : "string"
                                          },
                                          "mem_swap_kb" : {
                                             "description" : "Memory of the service currently in swap.",
                                             "type" : "integer"
                                          },
                                          "mem_total_kb" : {
                                             "description" : "Memory consumption of the service.",
                                             "type" : "integer"
                                          },
                                          "name" : {
                                             "description" : "Name of the service instance.",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "mgr" : {
                                 "description" : "Managers configured in the cluster and their properties.",
                                 "properties" : {
                                    "{id}" : {
                                       "description" : "Useful properties are listed, but not the full list.",
                                       "properties" : {
                                          "addr" : {
                                             "description" : "Bind address",
                                             "type" : "string"
                                          },
                                          "ceph_release" : {
                                             "description" : "Ceph release codename currently used.",
                                             "type" : "string"
                                          },
                                          "ceph_version" : {
                                             "description" : "Version info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "ceph_version_short" : {
                                             "description" : "Short version (numerical) info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "hostname" : {
                                             "description" : "Hostname on which the service is running.",
                                             "type" : "string"
                                          },
                                          "mem_swap_kb" : {
                                             "description" : "Memory of the service currently in swap.",
                                             "type" : "integer"
                                          },
                                          "mem_total_kb" : {
                                             "description" : "Memory consumption of the service.",
                                             "type" : "integer"
                                          },
                                          "name" : {
                                             "description" : "Name of the service instance.",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "mon" : {
                                 "description" : "Monitors configured in the cluster and their properties.",
                                 "properties" : {
                                    "{id}" : {
                                       "description" : "Useful properties are listed, but not the full list.",
                                       "properties" : {
                                          "addrs" : {
                                             "description" : "Bind addresses and ports.",
                                             "type" : "string"
                                          },
                                          "ceph_release" : {
                                             "description" : "Ceph release codename currently used.",
                                             "type" : "string"
                                          },
                                          "ceph_version" : {
                                             "description" : "Version info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "ceph_version_short" : {
                                             "description" : "Short version (numerical) info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "hostname" : {
                                             "description" : "Hostname on which the service is running.",
                                             "type" : "string"
                                          },
                                          "mem_swap_kb" : {
                                             "description" : "Memory of the service currently in swap.",
                                             "type" : "integer"
                                          },
                                          "mem_total_kb" : {
                                             "description" : "Memory consumption of the service.",
                                             "type" : "integer"
                                          },
                                          "name" : {
                                             "description" : "Name of the service instance.",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "node" : {
                                 "description" : "Ceph version installed on the nodes.",
                                 "properties" : {
                                    "{node}" : {
                                       "properties" : {
                                          "buildcommit" : {
                                             "description" : "GIT commit used for the build.",
                                             "type" : "string"
                                          },
                                          "version" : {
                                             "description" : "Version info.",
                                             "properties" : {
                                                "parts" : {
                                                   "description" : "major, minor & patch",
                                                   "type" : "array"
                                                },
                                                "str" : {
                                                   "description" : "Version as single string.",
                                                   "type" : "string"
                                                }
                                             },
                                             "type" : "object"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "osd" : {
                                 "description" : "OSDs configured in the cluster and their properties.",
                                 "properties" : {
                                    "{id}" : {
                                       "description" : "Useful properties are listed, but not the full list.",
                                       "properties" : {
                                          "back_addr" : {
                                             "description" : "Bind addresses and ports for backend inter OSD traffic.",
                                             "type" : "string"
                                          },
                                          "ceph_release" : {
                                             "description" : "Ceph release codename currently used.",
                                             "type" : "string"
                                          },
                                          "ceph_version" : {
                                             "description" : "Version info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "ceph_version_short" : {
                                             "description" : "Short version (numerical) info currently used by the service.",
                                             "type" : "string"
                                          },
                                          "device_id" : {
                                             "description" : "Devices used by the OSD.",
                                             "type" : "string"
                                          },
                                          "front_addr" : {
                                             "description" : "Bind addresses and ports for frontend traffic to OSDs.",
                                             "type" : "string"
                                          },
                                          "hostname" : {
                                             "description" : "Hostname on which the service is running.",
                                             "type" : "string"
                                          },
                                          "id" : {
                                             "description" : "OSD ID.",
                                             "type" : "integer"
                                          },
                                          "mem_swap_kb" : {
                                             "description" : "Memory of the service currently in swap.",
                                             "type" : "integer"
                                          },
                                          "mem_total_kb" : {
                                             "description" : "Memory consumption of the service.",
                                             "type" : "integer"
                                          },
                                          "osd_data" : {
                                             "description" : "Path to the OSD data directory.",
                                             "type" : "string"
                                          },
                                          "osd_objectstore" : {
                                             "description" : "OSD objectstore type.",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "type" : "array"
                              }
                           },
                           "type" : "object"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/ceph/metadata",
                  "text" : "metadata"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Get ceph status.",
                        "method" : "GET",
                        "name" : "status",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit",
                                 "Datastore.Audit"
                              ],
                              "any",
                              1
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "object"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/ceph/status",
                  "text" : "status"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get the status of a specific ceph flag.",
                              "method" : "GET",
                              "name" : "get_flag",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "flag" : {
                                       "description" : "The name of the flag name to get.",
                                       "enum" : [
                                          "nobackfill",
                                          "nodeep-scrub",
                                          "nodown",
                                          "noin",
                                          "noout",
                                          "norebalance",
                                          "norecover",
                                          "noscrub",
                                          "notieragent",
                                          "noup",
                                          "pause"
                                       ],
                                       "type" : "string"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "boolean"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Set or clear (unset) a specific ceph flag",
                              "method" : "PUT",
                              "name" : "update_flag",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "flag" : {
                                       "description" : "The ceph flag to update",
                                       "enum" : [
                                          "nobackfill",
                                          "nodeep-scrub",
                                          "nodown",
                                          "noin",
                                          "noout",
                                          "norebalance",
                                          "norecover",
                                          "noscrub",
                                          "notieragent",
                                          "noup",
                                          "pause"
                                       ],
                                       "type" : "string"
                                    },
                                    "value" : {
                                       "description" : "The new value of the flag",
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/ceph/flags/{flag}",
                        "text" : "{flag}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "get the status of all ceph flags",
                        "method" : "GET",
                        "name" : "get_all_flags",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "items" : {
                              "additionalProperties" : 1,
                              "properties" : {
                                 "description" : {
                                    "description" : "Flag description.",
                                    "type" : "string"
                                 },
                                 "name" : {
                                    "description" : "Flag name.",
                                    "enum" : [
                                       "nobackfill",
                                       "nodeep-scrub",
                                       "nodown",
                                       "noin",
                                       "noout",
                                       "norebalance",
                                       "norecover",
                                       "noscrub",
                                       "notieragent",
                                       "noup",
                                       "pause"
                                    ],
                                    "type" : "string"
                                 },
                                 "value" : {
                                    "description" : "Flag value.",
                                    "type" : "boolean"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{name}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "PUT" : {
                        "allowtoken" : 1,
                        "description" : "Set/Unset multiple ceph flags at once.",
                        "method" : "PUT",
                        "name" : "set_flags",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "nobackfill" : {
                                 "description" : "Backfilling of PGs is suspended.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "nodeep-scrub" : {
                                 "description" : "Deep Scrubbing is disabled.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "nodown" : {
                                 "description" : "OSD failure reports are being ignored, such that the monitors will not mark OSDs down.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "noin" : {
                                 "description" : "OSDs that were previously marked out will not be marked back in when they start.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "noout" : {
                                 "description" : "OSDs will not automatically be marked out after the configured interval.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "norebalance" : {
                                 "description" : "Rebalancing of PGs is suspended.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "norecover" : {
                                 "description" : "Recovery of PGs is suspended.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "noscrub" : {
                                 "description" : "Scrubbing is disabled.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "notieragent" : {
                                 "description" : "Cache tiering activity is suspended.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "noup" : {
                                 "description" : "OSDs are not allowed to start.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "pause" : {
                                 "description" : "Pauses read and writes.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              }
                           }
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "string"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/ceph/flags",
                  "text" : "flags"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Cluster ceph index.",
                  "method" : "GET",
                  "name" : "cephindex",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{name}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/ceph",
            "text" : "ceph"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete realm-sync job definition.",
                              "method" : "DELETE",
                              "name" : "delete_job",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read realm-sync job definition.",
                              "method" : "GET",
                              "name" : "read_job",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/",
                                    [
                                       "Sys.Audit"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "POST" : {
                              "allowtoken" : 1,
                              "description" : "Create new realm-sync job.",
                              "method" : "POST",
                              "name" : "create_job",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Description for the Job.",
                                       "maxLength" : 512,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "enable-new" : {
                                       "default" : "1",
                                       "description" : "Enable newly synced users immediately.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "enabled" : {
                                       "default" : 1,
                                       "description" : "Determines if the job is enabled.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "id" : {
                                       "description" : "The ID of the job.",
                                       "format" : "pve-configid",
                                       "maxLength" : 64,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "realm" : {
                                       "description" : "Authentication domain ID",
                                       "format" : "pve-realm",
                                       "maxLength" : 32,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "remove-vanished" : {
                                       "default" : "none",
                                       "description" : "A semicolon-separated list of things to remove when they or the user vanishes during a sync. The following values are possible: 'entry' removes the user/group when not returned from the sync. 'properties' removes the set properties on existing user/group that do not appear in the source (even custom ones). 'acl' removes acls when the user/group is not returned from the sync. Instead of a list it also can be 'none' (the default).",
                                       "optional" : 1,
                                       "pattern" : "(?:(?:(?:acl|properties|entry);)*(?:acl|properties|entry))|none",
                                       "type" : "string",
                                       "typetext" : "([acl];[properties];[entry])|none"
                                    },
                                    "schedule" : {
                                       "description" : "Backup schedule. The format is a subset of `systemd` calendar events.",
                                       "format" : "pve-calendar-event",
                                       "maxLength" : 128,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "scope" : {
                                       "description" : "Select what to sync.",
                                       "enum" : [
                                          "users",
                                          "groups",
                                          "both"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "and",
                                    [
                                       "perm",
                                       "/access/realm/{realm}",
                                       [
                                          "Realm.AllocateUser"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/access/groups",
                                       [
                                          "User.Modify"
                                       ]
                                    ]
                                 ],
                                 "description" : "'Realm.AllocateUser' on '/access/realm/<realm>' and 'User.Modify' permissions to '/access/groups/'."
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update realm-sync job definition.",
                              "method" : "PUT",
                              "name" : "update_job",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "comment" : {
                                       "description" : "Description for the Job.",
                                       "maxLength" : 512,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "enable-new" : {
                                       "default" : "1",
                                       "description" : "Enable newly synced users immediately.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "enabled" : {
                                       "default" : 1,
                                       "description" : "Determines if the job is enabled.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "id" : {
                                       "description" : "The ID of the job.",
                                       "format" : "pve-configid",
                                       "maxLength" : 64,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "remove-vanished" : {
                                       "default" : "none",
                                       "description" : "A semicolon-separated list of things to remove when they or the user vanishes during a sync. The following values are possible: 'entry' removes the user/group when not returned from the sync. 'properties' removes the set properties on existing user/group that do not appear in the source (even custom ones). 'acl' removes acls when the user/group is not returned from the sync. Instead of a list it also can be 'none' (the default).",
                                       "optional" : 1,
                                       "pattern" : "(?:(?:(?:acl|properties|entry);)*(?:acl|properties|entry))|none",
                                       "type" : "string",
                                       "typetext" : "([acl];[properties];[entry])|none"
                                    },
                                    "schedule" : {
                                       "description" : "Backup schedule. The format is a subset of `systemd` calendar events.",
                                       "format" : "pve-calendar-event",
                                       "maxLength" : 128,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "scope" : {
                                       "description" : "Select what to sync.",
                                       "enum" : [
                                          "users",
                                          "groups",
                                          "both"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "and",
                                    [
                                       "perm",
                                       "/access/realm/{realm}",
                                       [
                                          "Realm.AllocateUser"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/access/groups",
                                       [
                                          "User.Modify"
                                       ]
                                    ]
                                 ],
                                 "description" : "'Realm.AllocateUser' on '/access/realm/<realm>' and 'User.Modify' permissions to '/access/groups/'."
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/jobs/realm-sync/{id}",
                        "text" : "{id}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List configured realm-sync-jobs.",
                        "method" : "GET",
                        "name" : "syncjob_index",
                        "parameters" : {
                           "additionalProperties" : 0
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/",
                              [
                                 "Sys.Audit"
                              ]
                           ]
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "comment" : {
                                    "description" : "A comment for the job.",
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "enabled" : {
                                    "description" : "If the job is enabled or not.",
                                    "type" : "boolean"
                                 },
                                 "id" : {
                                    "description" : "The ID of the entry.",
                                    "type" : "string"
                                 },
                                 "last-run" : {
                                    "description" : "Last execution time of the job in seconds since the beginning of the UNIX epoch",
                                    "optional" : 1,
                                    "type" : "integer"
                                 },
                                 "next-run" : {
                                    "description" : "Next planned execution time of the job in seconds since the beginning of the UNIX epoch.",
                                    "optional" : 1,
                                    "type" : "integer"
                                 },
                                 "realm" : {
                                    "description" : "Authentication domain ID",
                                    "format" : "pve-realm",
                                    "maxLength" : 32,
                                    "type" : "string"
                                 },
                                 "remove-vanished" : {
                                    "default" : "none",
                                    "description" : "A semicolon-separated list of things to remove when they or the user vanishes during a sync. The following values are possible: 'entry' removes the user/group when not returned from the sync. 'properties' removes the set properties on existing user/group that do not appear in the source (even custom ones). 'acl' removes acls when the user/group is not returned from the sync. Instead of a list it also can be 'none' (the default).",
                                    "optional" : "1",
                                    "pattern" : "(?:(?:(?:acl|properties|entry);)*(?:acl|properties|entry))|none",
                                    "type" : "string",
                                    "typetext" : "([acl];[properties];[entry])|none"
                                 },
                                 "schedule" : {
                                    "description" : "The configured sync schedule.",
                                    "type" : "string"
                                 },
                                 "scope" : {
                                    "description" : "Select what to sync.",
                                    "enum" : [
                                       "users",
                                       "groups",
                                       "both"
                                    ],
                                    "optional" : "1",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{id}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/jobs/realm-sync",
                  "text" : "realm-sync"
               },
               {
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "Returns a list of future schedule runtimes.",
                        "method" : "GET",
                        "name" : "schedule-analyze",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "iterations" : {
                                 "default" : 10,
                                 "description" : "Number of event-iteration to simulate and return.",
                                 "maximum" : 100,
                                 "minimum" : 1,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (1 - 100)"
                              },
                              "schedule" : {
                                 "description" : "Job schedule. The format is a subset of `systemd` calendar events.",
                                 "format" : "pve-calendar-event",
                                 "maxLength" : 128,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "starttime" : {
                                 "description" : "UNIX timestamp to start the calculation from. Defaults to the current time.",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              }
                           }
                        },
                        "permissions" : {
                           "user" : "all"
                        },
                        "returns" : {
                           "description" : "An array of the next <iterations> events since <starttime>.",
                           "items" : {
                              "properties" : {
                                 "timestamp" : {
                                    "description" : "UNIX timestamp for the run.",
                                    "type" : "integer"
                                 },
                                 "utc" : {
                                    "description" : "UTC timestamp for the run.",
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "type" : "array"
                        }
                     }
                  },
                  "leaf" : 1,
                  "path" : "/cluster/jobs/schedule-analyze",
                  "text" : "schedule-analyze"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Index for jobs related endpoints.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "description" : "Directory index.",
                     "items" : {
                        "properties" : {
                           "subdir" : {
                              "description" : "API sub-directory endpoint",
                              "type" : "string"
                           }
                        },
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{subdir}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/jobs",
            "text" : "jobs"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Remove directory mapping.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/dir",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get directory mapping.",
                              "method" : "GET",
                              "name" : "get",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "or",
                                    [
                                       "perm",
                                       "/mapping/dir/{id}",
                                       [
                                          "Mapping.Use"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/dir/{id}",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/dir/{id}",
                                       [
                                          "Mapping.Audit"
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update a directory mapping.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "description" : {
                                       "description" : "Description of the directory mapping",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "id" : {
                                       "description" : "The ID of the directory mapping",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "map" : {
                                       "description" : "A list of maps for the cluster nodes.",
                                       "items" : {
                                          "format" : {
                                             "node" : {
                                                "description" : "The cluster node name.",
                                                "format" : "pve-node",
                                                "type" : "string"
                                             },
                                             "path" : {
                                                "description" : "Absolute directory path that should be shared with the guest.",
                                                "format" : "pve-storage-path-in-property-string",
                                                "type" : "string"
                                             }
                                          },
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/dir/{id}",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/mapping/dir/{id}",
                        "text" : "{id}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List directory mapping",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "check-node" : {
                                 "description" : "If given, checks the configurations on the given node for correctness, and adds relevant diagnostics for the directory to the response.",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only lists entries where you have 'Mapping.Modify', 'Mapping.Use' or 'Mapping.Audit' permissions on '/mapping/dir/<id>'.",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "checks" : {
                                    "description" : "A list of checks, only present if 'check-node' is set.",
                                    "items" : {
                                       "properties" : {
                                          "message" : {
                                             "description" : "The message of the error",
                                             "type" : "string"
                                          },
                                          "severity" : {
                                             "description" : "The severity of the error",
                                             "enum" : [
                                                "warning",
                                                "error"
                                             ],
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    },
                                    "optional" : 1,
                                    "type" : "array"
                                 },
                                 "description" : {
                                    "description" : "A description of the logical mapping.",
                                    "type" : "string"
                                 },
                                 "id" : {
                                    "description" : "The logical ID of the mapping.",
                                    "type" : "string"
                                 },
                                 "map" : {
                                    "description" : "The entries of the mapping.",
                                    "items" : {
                                       "description" : "A mapping for a node.",
                                       "type" : "string"
                                    },
                                    "type" : "array"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{id}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new directory mapping.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "description" : {
                                 "description" : "Description of the directory mapping",
                                 "maxLength" : 4096,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "id" : {
                                 "description" : "The ID of the directory mapping",
                                 "format" : "pve-configid",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "map" : {
                                 "description" : "A list of maps for the cluster nodes.",
                                 "items" : {
                                    "format" : {
                                       "node" : {
                                          "description" : "The cluster node name.",
                                          "format" : "pve-node",
                                          "type" : "string"
                                       },
                                       "path" : {
                                          "description" : "Absolute directory path that should be shared with the guest.",
                                          "format" : "pve-storage-path-in-property-string",
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "string"
                                 },
                                 "optional" : 0,
                                 "type" : "array",
                                 "typetext" : "<array>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/mapping/dir",
                              [
                                 "Mapping.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/mapping/dir",
                  "text" : "dir"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Remove Hardware Mapping.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/pci",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get PCI Mapping.",
                              "method" : "GET",
                              "name" : "get",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "or",
                                    [
                                       "perm",
                                       "/mapping/pci/{id}",
                                       [
                                          "Mapping.Use"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/pci/{id}",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/pci/{id}",
                                       [
                                          "Mapping.Audit"
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update a hardware mapping.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "description" : {
                                       "description" : "Description of the logical PCI device.",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "id" : {
                                       "description" : "The ID of the logical PCI mapping.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "live-migration-capable" : {
                                       "default" : 0,
                                       "description" : "Marks the device(s) as being able to be live-migrated (Experimental). This needs hardware and driver support to work.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "map" : {
                                       "description" : "A list of maps for the cluster nodes.",
                                       "items" : {
                                          "format" : {
                                             "description" : {
                                                "description" : "Description of the node specific device.",
                                                "maxLength" : 4096,
                                                "optional" : 1,
                                                "type" : "string"
                                             },
                                             "id" : {
                                                "description" : "The vendor and device ID that is expected. Used for detecting hardware changes",
                                                "pattern" : "(?^:^[0-9A-Fa-f]{4}:[0-9A-Fa-f]{4}$)",
                                                "type" : "string"
                                             },
                                             "iommugroup" : {
                                                "description" : "The IOMMU group in which the device is to be expected in. Used for detecting hardware changes.",
                                                "optional" : 1,
                                                "type" : "integer"
                                             },
                                             "node" : {
                                                "description" : "The cluster node name.",
                                                "format" : "pve-node",
                                                "type" : "string"
                                             },
                                             "path" : {
                                                "description" : "The path to the device. If the function is omitted, the whole device is mapped. In that case use the attributes of the first device. You can give multiple paths as a semicolon seperated list, the first available will then be chosen on guest start.",
                                                "pattern" : "(?:[a-f0-9]{4,}:[a-f0-9]{2}:[a-f0-9]{2}(?:.[a-f0-9])?;)*[a-f0-9]{4,}:[a-f0-9]{2}:[a-f0-9]{2}(?:.[a-f0-9])?",
                                                "type" : "string"
                                             },
                                             "subsystem-id" : {
                                                "description" : "The subsystem vendor and device ID that is expected. Used for detecting hardware changes.",
                                                "optional" : 1,
                                                "pattern" : "(?^:^[0-9A-Fa-f]{4}:[0-9A-Fa-f]{4}$)",
                                                "type" : "string"
                                             }
                                          },
                                          "type" : "string"
                                       },
                                       "optional" : 1,
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    },
                                    "mdev" : {
                                       "default" : 0,
                                       "description" : "Marks the device(s) as being capable of providing mediated devices.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/pci/{id}",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/mapping/pci/{id}",
                        "text" : "{id}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List PCI Hardware Mapping",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "check-node" : {
                                 "description" : "If given, checks the configurations on the given node for correctness, and adds relevant diagnostics for the devices to the response.",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only lists entries where you have 'Mapping.Modify', 'Mapping.Use' or 'Mapping.Audit' permissions on '/mapping/pci/<id>'.",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "checks" : {
                                    "description" : "A list of checks, only present if 'check_node' is set.",
                                    "items" : {
                                       "properties" : {
                                          "message" : {
                                             "description" : "The message of the error",
                                             "type" : "string"
                                          },
                                          "severity" : {
                                             "description" : "The severity of the error",
                                             "enum" : [
                                                "warning",
                                                "error"
                                             ],
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    },
                                    "optional" : 1,
                                    "type" : "array"
                                 },
                                 "description" : {
                                    "description" : "A description of the logical mapping.",
                                    "type" : "string"
                                 },
                                 "id" : {
                                    "description" : "The logical ID of the mapping.",
                                    "type" : "string"
                                 },
                                 "map" : {
                                    "description" : "The entries of the mapping.",
                                    "items" : {
                                       "description" : "A mapping for a node.",
                                       "type" : "string"
                                    },
                                    "type" : "array"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{id}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new hardware mapping.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "description" : {
                                 "description" : "Description of the logical PCI device.",
                                 "maxLength" : 4096,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "id" : {
                                 "description" : "The ID of the logical PCI mapping.",
                                 "format" : "pve-configid",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "live-migration-capable" : {
                                 "default" : 0,
                                 "description" : "Marks the device(s) as being able to be live-migrated (Experimental). This needs hardware and driver support to work.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "map" : {
                                 "description" : "A list of maps for the cluster nodes.",
                                 "items" : {
                                    "format" : {
                                       "description" : {
                                          "description" : "Description of the node specific device.",
                                          "maxLength" : 4096,
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "id" : {
                                          "description" : "The vendor and device ID that is expected. Used for detecting hardware changes",
                                          "pattern" : "(?^:^[0-9A-Fa-f]{4}:[0-9A-Fa-f]{4}$)",
                                          "type" : "string"
                                       },
                                       "iommugroup" : {
                                          "description" : "The IOMMU group in which the device is to be expected in. Used for detecting hardware changes.",
                                          "optional" : 1,
                                          "type" : "integer"
                                       },
                                       "node" : {
                                          "description" : "The cluster node name.",
                                          "format" : "pve-node",
                                          "type" : "string"
                                       },
                                       "path" : {
                                          "description" : "The path to the device. If the function is omitted, the whole device is mapped. In that case use the attributes of the first device. You can give multiple paths as a semicolon seperated list, the first available will then be chosen on guest start.",
                                          "pattern" : "(?:[a-f0-9]{4,}:[a-f0-9]{2}:[a-f0-9]{2}(?:.[a-f0-9])?;)*[a-f0-9]{4,}:[a-f0-9]{2}:[a-f0-9]{2}(?:.[a-f0-9])?",
                                          "type" : "string"
                                       },
                                       "subsystem-id" : {
                                          "description" : "The subsystem vendor and device ID that is expected. Used for detecting hardware changes.",
                                          "optional" : 1,
                                          "pattern" : "(?^:^[0-9A-Fa-f]{4}:[0-9A-Fa-f]{4}$)",
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "string"
                                 },
                                 "optional" : 0,
                                 "type" : "array",
                                 "typetext" : "<array>"
                              },
                              "mdev" : {
                                 "default" : 0,
                                 "description" : "Marks the device(s) as being capable of providing mediated devices.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/mapping/pci",
                              [
                                 "Mapping.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/mapping/pci",
                  "text" : "pci"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Remove Hardware Mapping.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/usb",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Get USB Mapping.",
                              "method" : "GET",
                              "name" : "get",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "id" : {
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "or",
                                    [
                                       "perm",
                                       "/mapping/usb/{id}",
                                       [
                                          "Mapping.Audit"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/usb/{id}",
                                       [
                                          "Mapping.Use"
                                       ]
                                    ],
                                    [
                                       "perm",
                                       "/mapping/usb/{id}",
                                       [
                                          "Mapping.Modify"
                                       ]
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update a hardware mapping.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "description" : {
                                       "description" : "Description of the logical USB device.",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "id" : {
                                       "description" : "The ID of the logical USB mapping.",
                                       "format" : "pve-configid",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "map" : {
                                       "description" : "A list of maps for the cluster nodes.",
                                       "items" : {
                                          "format" : {
                                             "description" : {
                                                "description" : "Description of the node specific device.",
                                                "maxLength" : 4096,
                                                "optional" : 1,
                                                "type" : "string"
                                             },
                                             "id" : {
                                                "description" : "The vendor and device ID that is expected. If a USB path is given, it is only used for detecting hardware changes",
                                                "pattern" : "(?^:^[0-9A-Fa-f]{4}:[0-9A-Fa-f]{4}$)",
                                                "type" : "string"
                                             },
                                             "node" : {
                                                "description" : "The cluster node name.",
                                                "format" : "pve-node",
                                                "type" : "string"
                                             },
                                             "path" : {
                                                "description" : "The path to the usb device.",
                                                "optional" : 1,
                                                "pattern" : "(?^:^(\\d+)\\-(\\d+(\\.\\d+)*)$)",
                                                "type" : "string"
                                             }
                                          },
                                          "type" : "string"
                                       },
                                       "type" : "array",
                                       "typetext" : "<array>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/mapping/usb/{id}",
                                    [
                                       "Mapping.Modify"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/mapping/usb/{id}",
                        "text" : "{id}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "List USB Hardware Mappings",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "check-node" : {
                                 "description" : "If given, checks the configurations on the given node for correctness, and adds relevant errors to the devices.",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only lists entries where you have 'Mapping.Modify', 'Mapping.Use' or 'Mapping.Audit' permissions on '/mapping/usb/<id>'.",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "description" : {
                                    "description" : "A description of the logical mapping.",
                                    "type" : "string"
                                 },
                                 "error" : {
                                    "description" : "A list of errors when 'check_node' is given.",
                                    "items" : {
                                       "properties" : {
                                          "message" : {
                                             "description" : "The message of the error",
                                             "type" : "string"
                                          },
                                          "severity" : {
                                             "description" : "The severity of the error",
                                             "type" : "string"
                                          }
                                       },
                                       "type" : "object"
                                    }
                                 },
                                 "id" : {
                                    "description" : "The logical ID of the mapping.",
                                    "type" : "string"
                                 },
                                 "map" : {
                                    "description" : "The entries of the mapping.",
                                    "items" : {
                                       "description" : "A mapping for a node.",
                                       "type" : "string"
                                    },
                                    "type" : "array"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{id}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new hardware mapping.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "description" : {
                                 "description" : "Description of the logical USB device.",
                                 "maxLength" : 4096,
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "id" : {
                                 "description" : "The ID of the logical USB mapping.",
                                 "format" : "pve-configid",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "map" : {
                                 "description" : "A list of maps for the cluster nodes.",
                                 "items" : {
                                    "format" : {
                                       "description" : {
                                          "description" : "Description of the node specific device.",
                                          "maxLength" : 4096,
                                          "optional" : 1,
                                          "type" : "string"
                                       },
                                       "id" : {
                                          "description" : "The vendor and device ID that is expected. If a USB path is given, it is only used for detecting hardware changes",
                                          "pattern" : "(?^:^[0-9A-Fa-f]{4}:[0-9A-Fa-f]{4}$)",
                                          "type" : "string"
                                       },
                                       "node" : {
                                          "description" : "The cluster node name.",
                                          "format" : "pve-node",
                                          "type" : "string"
                                       },
                                       "path" : {
                                          "description" : "The path to the usb device.",
                                          "optional" : 1,
                                          "pattern" : "(?^:^(\\d+)\\-(\\d+(\\.\\d+)*)$)",
                                          "type" : "string"
                                       }
                                    },
                                    "type" : "string"
                                 },
                                 "type" : "array",
                                 "typetext" : "<array>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/mapping/usb",
                              [
                                 "Mapping.Modify"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/mapping/usb",
                  "text" : "usb"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "List resource types.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{name}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/mapping",
            "text" : "mapping"
         },
         {
            "children" : [
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "children" : [
                                 {
                                    "children" : [
                                       {
                                          "info" : {
                                             "DELETE" : {
                                                "allowtoken" : 1,
                                                "description" : "Delete rule.",
                                                "method" : "DELETE",
                                                "name" : "delete_rule",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "digest" : {
                                                         "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                         "maxLength" : 64,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "pos" : {
                                                         "description" : "Update rule at position <pos>.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "vnet" : {
                                                         "description" : "The SDN vnet object identifier.",
                                                         "format" : "pve-sdn-vnet-id",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "description" : "Needs SDN.Allocate permissions on '/sdn/zones/<zone>/<vnet>'",
                                                   "user" : "all"
                                                },
                                                "protected" : 1,
                                                "proxyto" : null,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             },
                                             "GET" : {
                                                "allowtoken" : 1,
                                                "description" : "Get single rule data.",
                                                "method" : "GET",
                                                "name" : "get_rule",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "pos" : {
                                                         "description" : "Update rule at position <pos>.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "vnet" : {
                                                         "description" : "The SDN vnet object identifier.",
                                                         "format" : "pve-sdn-vnet-id",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "description" : "Needs SDN.Audit or SDN.Allocate permissions on '/sdn/zones/<zone>/<vnet>'",
                                                   "user" : "all"
                                                },
                                                "proxyto" : null,
                                                "returns" : {
                                                   "properties" : {
                                                      "action" : {
                                                         "type" : "string"
                                                      },
                                                      "comment" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "dest" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "dport" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "enable" : {
                                                         "optional" : 1,
                                                         "type" : "integer"
                                                      },
                                                      "icmp-type" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "iface" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "ipversion" : {
                                                         "optional" : 1,
                                                         "type" : "integer"
                                                      },
                                                      "log" : {
                                                         "description" : "Log level for firewall rule",
                                                         "enum" : [
                                                            "emerg",
                                                            "alert",
                                                            "crit",
                                                            "err",
                                                            "warning",
                                                            "notice",
                                                            "info",
                                                            "debug",
                                                            "nolog"
                                                         ],
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "macro" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "pos" : {
                                                         "type" : "integer"
                                                      },
                                                      "proto" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "source" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "sport" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "type" : {
                                                         "type" : "string"
                                                      }
                                                   },
                                                   "type" : "object"
                                                }
                                             },
                                             "PUT" : {
                                                "allowtoken" : 1,
                                                "description" : "Modify rule data.",
                                                "method" : "PUT",
                                                "name" : "update_rule",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "action" : {
                                                         "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                                         "maxLength" : 20,
                                                         "minLength" : 2,
                                                         "optional" : 1,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "comment" : {
                                                         "description" : "Descriptive comment.",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "delete" : {
                                                         "description" : "A list of settings you want to delete.",
                                                         "format" : "pve-configid-list",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "dest" : {
                                                         "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                         "format" : "pve-fw-addr-spec",
                                                         "maxLength" : 512,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "digest" : {
                                                         "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                         "maxLength" : 64,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "dport" : {
                                                         "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                         "format" : "pve-fw-dport-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "enable" : {
                                                         "description" : "Flag to enable/disable a rule.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "icmp-type" : {
                                                         "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                                         "format" : "pve-fw-icmp-type-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "iface" : {
                                                         "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                                         "format" : "pve-iface",
                                                         "maxLength" : 20,
                                                         "minLength" : 2,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "log" : {
                                                         "description" : "Log level for firewall rule.",
                                                         "enum" : [
                                                            "emerg",
                                                            "alert",
                                                            "crit",
                                                            "err",
                                                            "warning",
                                                            "notice",
                                                            "info",
                                                            "debug",
                                                            "nolog"
                                                         ],
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "macro" : {
                                                         "description" : "Use predefined standard macro.",
                                                         "maxLength" : 128,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "moveto" : {
                                                         "description" : "Move rule to new position <moveto>. Other arguments are ignored.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "pos" : {
                                                         "description" : "Update rule at position <pos>.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "proto" : {
                                                         "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                                         "format" : "pve-fw-protocol-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "source" : {
                                                         "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                         "format" : "pve-fw-addr-spec",
                                                         "maxLength" : 512,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "sport" : {
                                                         "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                         "format" : "pve-fw-sport-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "type" : {
                                                         "description" : "Rule type.",
                                                         "enum" : [
                                                            "in",
                                                            "out",
                                                            "forward",
                                                            "group"
                                                         ],
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "vnet" : {
                                                         "description" : "The SDN vnet object identifier.",
                                                         "format" : "pve-sdn-vnet-id",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "description" : "Needs SDN.Allocate permissions on '/sdn/zones/<zone>/<vnet>'",
                                                   "user" : "all"
                                                },
                                                "protected" : 1,
                                                "proxyto" : null,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             }
                                          },
                                          "leaf" : 1,
                                          "path" : "/cluster/sdn/vnets/{vnet}/firewall/rules/{pos}",
                                          "text" : "{pos}"
                                       }
                                    ],
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "List rules.",
                                          "method" : "GET",
                                          "name" : "get_rules",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "vnet" : {
                                                   "description" : "The SDN vnet object identifier.",
                                                   "format" : "pve-sdn-vnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "description" : "Needs SDN.Audit or SDN.Allocate permissions on '/sdn/zones/<zone>/<vnet>'",
                                             "user" : "all"
                                          },
                                          "proxyto" : null,
                                          "returns" : {
                                             "items" : {
                                                "properties" : {
                                                   "pos" : {
                                                      "type" : "integer"
                                                   }
                                                },
                                                "type" : "object"
                                             },
                                             "links" : [
                                                {
                                                   "href" : "{pos}",
                                                   "rel" : "child"
                                                }
                                             ],
                                             "type" : "array"
                                          }
                                       },
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Create new rule.",
                                          "method" : "POST",
                                          "name" : "create_rule",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "action" : {
                                                   "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                                   "maxLength" : 20,
                                                   "minLength" : 2,
                                                   "optional" : 0,
                                                   "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                   "type" : "string"
                                                },
                                                "comment" : {
                                                   "description" : "Descriptive comment.",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dest" : {
                                                   "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                   "format" : "pve-fw-addr-spec",
                                                   "maxLength" : 512,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "digest" : {
                                                   "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                   "maxLength" : 64,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dport" : {
                                                   "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                   "format" : "pve-fw-dport-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "enable" : {
                                                   "description" : "Flag to enable/disable a rule.",
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "icmp-type" : {
                                                   "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                                   "format" : "pve-fw-icmp-type-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "iface" : {
                                                   "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                                   "format" : "pve-iface",
                                                   "maxLength" : 20,
                                                   "minLength" : 2,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "log" : {
                                                   "description" : "Log level for firewall rule.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "macro" : {
                                                   "description" : "Use predefined standard macro.",
                                                   "maxLength" : 128,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "pos" : {
                                                   "description" : "Update rule at position <pos>.",
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "proto" : {
                                                   "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                                   "format" : "pve-fw-protocol-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "source" : {
                                                   "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                   "format" : "pve-fw-addr-spec",
                                                   "maxLength" : 512,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "sport" : {
                                                   "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                   "format" : "pve-fw-sport-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "type" : {
                                                   "description" : "Rule type.",
                                                   "enum" : [
                                                      "in",
                                                      "out",
                                                      "forward",
                                                      "group"
                                                   ],
                                                   "optional" : 0,
                                                   "type" : "string"
                                                },
                                                "vnet" : {
                                                   "description" : "The SDN vnet object identifier.",
                                                   "format" : "pve-sdn-vnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "description" : "Needs SDN.Allocate permissions on '/sdn/zones/<zone>/<vnet>'",
                                             "user" : "all"
                                          },
                                          "protected" : 1,
                                          "proxyto" : null,
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       }
                                    },
                                    "leaf" : 0,
                                    "path" : "/cluster/sdn/vnets/{vnet}/firewall/rules",
                                    "text" : "rules"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Get vnet firewall options.",
                                          "method" : "GET",
                                          "name" : "get_options",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "vnet" : {
                                                   "description" : "The SDN vnet object identifier.",
                                                   "format" : "pve-sdn-vnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "description" : "Needs SDN.Audit or SDN.Allocate permissions on '/sdn/zones/<zone>/<vnet>'",
                                             "user" : "all"
                                          },
                                          "returns" : {
                                             "properties" : {
                                                "enable" : {
                                                   "default" : 0,
                                                   "description" : "Enable/disable firewall rules.",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "log_level_forward" : {
                                                   "description" : "Log level for forwarded traffic.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "policy_forward" : {
                                                   "description" : "Forward policy.",
                                                   "enum" : [
                                                      "ACCEPT",
                                                      "DROP"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                }
                                             },
                                             "type" : "object"
                                          }
                                       },
                                       "PUT" : {
                                          "allowtoken" : 1,
                                          "description" : "Set Firewall options.",
                                          "method" : "PUT",
                                          "name" : "set_options",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "delete" : {
                                                   "description" : "A list of settings you want to delete.",
                                                   "format" : "pve-configid-list",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "digest" : {
                                                   "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                   "maxLength" : 64,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "enable" : {
                                                   "default" : 0,
                                                   "description" : "Enable/disable firewall rules.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "log_level_forward" : {
                                                   "description" : "Log level for forwarded traffic.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "policy_forward" : {
                                                   "description" : "Forward policy.",
                                                   "enum" : [
                                                      "ACCEPT",
                                                      "DROP"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "vnet" : {
                                                   "description" : "The SDN vnet object identifier.",
                                                   "format" : "pve-sdn-vnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "description" : "Needs SDN.Allocate permissions on '/sdn/zones/<zone>/<vnet>'",
                                             "user" : "all"
                                          },
                                          "protected" : 1,
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/cluster/sdn/vnets/{vnet}/firewall/options",
                                    "text" : "options"
                                 }
                              ],
                              "info" : {
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Directory index.",
                                    "method" : "GET",
                                    "name" : "index",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "vnet" : {
                                             "description" : "The SDN vnet object identifier.",
                                             "format" : "pve-sdn-vnet-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "returns" : {
                                       "items" : {
                                          "properties" : {},
                                          "type" : "object"
                                       },
                                       "links" : [
                                          {
                                             "href" : "{name}",
                                             "rel" : "child"
                                          }
                                       ],
                                       "type" : "array"
                                    }
                                 }
                              },
                              "leaf" : 0,
                              "path" : "/cluster/sdn/vnets/{vnet}/firewall",
                              "text" : "firewall"
                           },
                           {
                              "children" : [
                                 {
                                    "info" : {
                                       "DELETE" : {
                                          "allowtoken" : 1,
                                          "description" : "Delete sdn subnet object configuration.",
                                          "method" : "DELETE",
                                          "name" : "delete",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "subnet" : {
                                                   "description" : "The SDN subnet object identifier.",
                                                   "format" : "pve-sdn-subnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vnet" : {
                                                   "description" : "The SDN vnet object identifier.",
                                                   "format" : "pve-sdn-vnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "description" : "Require 'SDN.Allocate' permission on '/sdn/zones/<zone>/<vnet>'",
                                             "user" : "all"
                                          },
                                          "protected" : 1,
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       },
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Read sdn subnet configuration.",
                                          "method" : "GET",
                                          "name" : "read",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "pending" : {
                                                   "description" : "Display pending config.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "running" : {
                                                   "description" : "Display running config.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "subnet" : {
                                                   "description" : "The SDN subnet object identifier.",
                                                   "format" : "pve-sdn-subnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vnet" : {
                                                   "description" : "The SDN vnet object identifier.",
                                                   "format" : "pve-sdn-vnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "description" : "Require 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/zones/<zone>/<vnet>'",
                                             "user" : "all"
                                          },
                                          "returns" : {
                                             "type" : "object"
                                          }
                                       },
                                       "PUT" : {
                                          "allowtoken" : 1,
                                          "description" : "Update sdn subnet object configuration.",
                                          "method" : "PUT",
                                          "name" : "update",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "delete" : {
                                                   "description" : "A list of settings you want to delete.",
                                                   "format" : "pve-configid-list",
                                                   "maxLength" : 4096,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dhcp-dns-server" : {
                                                   "description" : "IP address for the DNS server",
                                                   "format" : "ip",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dhcp-range" : {
                                                   "description" : "A list of DHCP ranges for this subnet",
                                                   "items" : {
                                                      "format" : "pve-sdn-dhcp-range",
                                                      "type" : "string"
                                                   },
                                                   "optional" : 1,
                                                   "type" : "array",
                                                   "typetext" : "<array>"
                                                },
                                                "digest" : {
                                                   "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                   "maxLength" : 64,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dnszoneprefix" : {
                                                   "description" : "dns domain zone prefix  ex: 'adm' -> <hostname>.adm.mydomain.com",
                                                   "format" : "dns-name",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "gateway" : {
                                                   "description" : "Subnet Gateway: Will be assign on vnet for layer3 zones",
                                                   "format" : "ip",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "snat" : {
                                                   "description" : "enable masquerade for this subnet if pve-firewall",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "subnet" : {
                                                   "description" : "The SDN subnet object identifier.",
                                                   "format" : "pve-sdn-subnet-id",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vnet" : {
                                                   "description" : "associated vnet",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                }
                                             },
                                             "type" : "object"
                                          },
                                          "permissions" : {
                                             "description" : "Require 'SDN.Allocate' permission on '/sdn/zones/<zone>/<vnet>'",
                                             "user" : "all"
                                          },
                                          "protected" : 1,
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/cluster/sdn/vnets/{vnet}/subnets/{subnet}",
                                    "text" : "{subnet}"
                                 }
                              ],
                              "info" : {
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "SDN subnets index.",
                                    "method" : "GET",
                                    "name" : "index",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "pending" : {
                                             "description" : "Display pending config.",
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          },
                                          "running" : {
                                             "description" : "Display running config.",
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          },
                                          "vnet" : {
                                             "description" : "The SDN vnet object identifier.",
                                             "format" : "pve-sdn-vnet-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "description" : "Only list entries where you have 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/zones/<zone>/<vnet>'",
                                       "user" : "all"
                                    },
                                    "returns" : {
                                       "items" : {
                                          "properties" : {},
                                          "type" : "object"
                                       },
                                       "links" : [
                                          {
                                             "href" : "{subnet}",
                                             "rel" : "child"
                                          }
                                       ],
                                       "type" : "array"
                                    }
                                 },
                                 "POST" : {
                                    "allowtoken" : 1,
                                    "description" : "Create a new sdn subnet object.",
                                    "method" : "POST",
                                    "name" : "create",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "dhcp-dns-server" : {
                                             "description" : "IP address for the DNS server",
                                             "format" : "ip",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "dhcp-range" : {
                                             "description" : "A list of DHCP ranges for this subnet",
                                             "items" : {
                                                "format" : "pve-sdn-dhcp-range",
                                                "type" : "string"
                                             },
                                             "optional" : 1,
                                             "type" : "array",
                                             "typetext" : "<array>"
                                          },
                                          "dnszoneprefix" : {
                                             "description" : "dns domain zone prefix  ex: 'adm' -> <hostname>.adm.mydomain.com",
                                             "format" : "dns-name",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "gateway" : {
                                             "description" : "Subnet Gateway: Will be assign on vnet for layer3 zones",
                                             "format" : "ip",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "snat" : {
                                             "description" : "enable masquerade for this subnet if pve-firewall",
                                             "optional" : 1,
                                             "type" : "boolean",
                                             "typetext" : "<boolean>"
                                          },
                                          "subnet" : {
                                             "description" : "The SDN subnet object identifier.",
                                             "format" : "pve-sdn-subnet-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "type" : {
                                             "enum" : [
                                                "subnet"
                                             ],
                                             "type" : "string"
                                          },
                                          "vnet" : {
                                             "description" : "associated vnet",
                                             "optional" : 0,
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       },
                                       "type" : "object"
                                    },
                                    "permissions" : {
                                       "description" : "Require 'SDN.Allocate' permission on '/sdn/zones/<zone>/<vnet>'",
                                       "user" : "all"
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 0,
                              "path" : "/cluster/sdn/vnets/{vnet}/subnets",
                              "text" : "subnets"
                           },
                           {
                              "info" : {
                                 "DELETE" : {
                                    "allowtoken" : 1,
                                    "description" : "Delete IP Mappings in a VNet",
                                    "method" : "DELETE",
                                    "name" : "ipdelete",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "ip" : {
                                             "description" : "The IP address to delete",
                                             "format" : "ip",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "mac" : {
                                             "description" : "Unicast MAC address.",
                                             "format" : "mac-addr",
                                             "format_description" : "XX:XX:XX:XX:XX:XX",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<XX:XX:XX:XX:XX:XX>",
                                             "verbose_description" : "A common MAC address with the I/G (Individual/Group) bit not set."
                                          },
                                          "vnet" : {
                                             "description" : "The SDN vnet object identifier.",
                                             "format" : "pve-sdn-vnet-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "zone" : {
                                             "description" : "The SDN zone object identifier.",
                                             "format" : "pve-sdn-zone-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/sdn/zones/{zone}/{vnet}",
                                          [
                                             "SDN.Allocate"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "POST" : {
                                    "allowtoken" : 1,
                                    "description" : "Create IP Mapping in a VNet",
                                    "method" : "POST",
                                    "name" : "ipcreate",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "ip" : {
                                             "description" : "The IP address to associate with the given MAC address",
                                             "format" : "ip",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "mac" : {
                                             "description" : "Unicast MAC address.",
                                             "format" : "mac-addr",
                                             "format_description" : "XX:XX:XX:XX:XX:XX",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<XX:XX:XX:XX:XX:XX>",
                                             "verbose_description" : "A common MAC address with the I/G (Individual/Group) bit not set."
                                          },
                                          "vnet" : {
                                             "description" : "The SDN vnet object identifier.",
                                             "format" : "pve-sdn-vnet-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "zone" : {
                                             "description" : "The SDN zone object identifier.",
                                             "format" : "pve-sdn-zone-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/sdn/zones/{zone}/{vnet}",
                                          [
                                             "SDN.Allocate"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 },
                                 "PUT" : {
                                    "allowtoken" : 1,
                                    "description" : "Update IP Mapping in a VNet",
                                    "method" : "PUT",
                                    "name" : "ipupdate",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "ip" : {
                                             "description" : "The IP address to associate with the given MAC address",
                                             "format" : "ip",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "mac" : {
                                             "description" : "Unicast MAC address.",
                                             "format" : "mac-addr",
                                             "format_description" : "XX:XX:XX:XX:XX:XX",
                                             "optional" : 1,
                                             "type" : "string",
                                             "typetext" : "<XX:XX:XX:XX:XX:XX>",
                                             "verbose_description" : "A common MAC address with the I/G (Individual/Group) bit not set."
                                          },
                                          "vmid" : {
                                             "description" : "The (unique) ID of the VM.",
                                             "format" : "pve-vmid",
                                             "maximum" : 999999999,
                                             "minimum" : 100,
                                             "optional" : 1,
                                             "type" : "integer",
                                             "typetext" : "<integer> (100 - 999999999)"
                                          },
                                          "vnet" : {
                                             "description" : "The SDN vnet object identifier.",
                                             "format" : "pve-sdn-vnet-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "zone" : {
                                             "description" : "The SDN zone object identifier.",
                                             "format" : "pve-sdn-zone-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "check" : [
                                          "perm",
                                          "/sdn/zones/{zone}/{vnet}",
                                          [
                                             "SDN.Allocate"
                                          ]
                                       ]
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "null"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/sdn/vnets/{vnet}/ips",
                              "text" : "ips"
                           }
                        ],
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete sdn vnet object configuration.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "vnet" : {
                                       "description" : "The SDN vnet object identifier.",
                                       "format" : "pve-sdn-vnet-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "description" : "Require 'SDN.Allocate' permission on '/sdn/zones/<zone>/<vnet>'",
                                 "user" : "all"
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read sdn vnet configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "pending" : {
                                       "description" : "Display pending config.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "running" : {
                                       "description" : "Display running config.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "vnet" : {
                                       "description" : "The SDN vnet object identifier.",
                                       "format" : "pve-sdn-vnet-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "description" : "Require 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/zones/<zone>/<vnet>'",
                                 "user" : "all"
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update sdn vnet object configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "alias" : {
                                       "description" : "alias name of the vnet",
                                       "maxLength" : 256,
                                       "optional" : 1,
                                       "pattern" : "(?^i:[\\(\\)-_.\\w\\d\\s]{0,256})",
                                       "type" : "string"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "isolate-ports" : {
                                       "description" : "If true, sets the isolated property for all members of this VNet",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "tag" : {
                                       "description" : "vlan or vxlan id",
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "vlanaware" : {
                                       "description" : "Allow vm VLANs to pass through this vnet.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "vnet" : {
                                       "description" : "The SDN vnet object identifier.",
                                       "format" : "pve-sdn-vnet-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "zone" : {
                                       "description" : "zone id",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "description" : "Require 'SDN.Allocate' permission on '/sdn/zones/<zone>/<vnet>'",
                                 "user" : "all"
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/sdn/vnets/{vnet}",
                        "text" : "{vnet}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "SDN vnets index.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "pending" : {
                                 "description" : "Display pending config.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "running" : {
                                 "description" : "Display running config.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only list entries where you have 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/zones/<zone>/<vnet>'",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {},
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{vnet}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new sdn vnet object.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "alias" : {
                                 "description" : "alias name of the vnet",
                                 "maxLength" : 256,
                                 "optional" : 1,
                                 "pattern" : "(?^i:[\\(\\)-_.\\w\\d\\s]{0,256})",
                                 "type" : "string"
                              },
                              "isolate-ports" : {
                                 "description" : "If true, sets the isolated property for all members of this VNet",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "tag" : {
                                 "description" : "vlan or vxlan id",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "type" : {
                                 "description" : "Type",
                                 "enum" : [
                                    "vnet"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "vlanaware" : {
                                 "description" : "Allow vm VLANs to pass through this vnet.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "vnet" : {
                                 "description" : "The SDN vnet object identifier.",
                                 "format" : "pve-sdn-vnet-id",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "zone" : {
                                 "description" : "zone id",
                                 "optional" : 0,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/sdn/zones/{zone}",
                              [
                                 "SDN.Allocate"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/sdn/vnets",
                  "text" : "vnets"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete sdn zone object configuration.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "zone" : {
                                       "description" : "The SDN zone object identifier.",
                                       "format" : "pve-sdn-zone-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/zones/{zone}",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read sdn zone configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "pending" : {
                                       "description" : "Display pending config.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "running" : {
                                       "description" : "Display running config.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "zone" : {
                                       "description" : "The SDN zone object identifier.",
                                       "format" : "pve-sdn-zone-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/zones/{zone}",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update sdn zone object configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "advertise-subnets" : {
                                       "description" : "Advertise evpn subnets if you have silent hosts",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "bridge" : {
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "bridge-disable-mac-learning" : {
                                       "description" : "Disable auto mac learning.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "controller" : {
                                       "description" : "Frr router name",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dhcp" : {
                                       "description" : "Type of the DHCP backend for this zone",
                                       "enum" : [
                                          "dnsmasq"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "disable-arp-nd-suppression" : {
                                       "description" : "Disable ipv4 arp && ipv6 neighbour discovery suppression",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "dns" : {
                                       "description" : "dns api server",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dnszone" : {
                                       "description" : "dns domain zone  ex: mydomain.com",
                                       "format" : "dns-name",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dp-id" : {
                                       "description" : "Faucet dataplane id",
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "exitnodes" : {
                                       "description" : "List of cluster node names.",
                                       "format" : "pve-node-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "exitnodes-local-routing" : {
                                       "description" : "Allow exitnodes to connect to evpn guests",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "exitnodes-primary" : {
                                       "description" : "Force traffic to this exitnode first.",
                                       "format" : "pve-node",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "ipam" : {
                                       "description" : "use a specific ipam",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "mac" : {
                                       "description" : "Anycast logical router mac address",
                                       "format" : "mac-addr",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "mtu" : {
                                       "description" : "MTU",
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "nodes" : {
                                       "description" : "List of cluster node names.",
                                       "format" : "pve-node-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "peers" : {
                                       "description" : "peers address list.",
                                       "format" : "ip-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "reversedns" : {
                                       "description" : "reverse dns api server",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "rt-import" : {
                                       "description" : "Route-Target import",
                                       "format" : "pve-sdn-bgp-rt-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "tag" : {
                                       "description" : "Service-VLAN Tag",
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - N)"
                                    },
                                    "vlan-protocol" : {
                                       "default" : "802.1q",
                                       "enum" : [
                                          "802.1q",
                                          "802.1ad"
                                       ],
                                       "optional" : 1,
                                       "type" : "string"
                                    },
                                    "vrf-vxlan" : {
                                       "description" : "l3vni.",
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "vxlan-port" : {
                                       "description" : "Vxlan tunnel udp port (default 4789).",
                                       "maximum" : 65536,
                                       "minimum" : 1,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (1 - 65536)"
                                    },
                                    "zone" : {
                                       "description" : "The SDN zone object identifier.",
                                       "format" : "pve-sdn-zone-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/zones/{zone}",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/sdn/zones/{zone}",
                        "text" : "{zone}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "SDN zones index.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "pending" : {
                                 "description" : "Display pending config.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "running" : {
                                 "description" : "Display running config.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "type" : {
                                 "description" : "Only list SDN zones of specific type",
                                 "enum" : [
                                    "evpn",
                                    "faucet",
                                    "qinq",
                                    "simple",
                                    "vlan",
                                    "vxlan"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only list entries where you have 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/zones/<zone>'",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "dhcp" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "dns" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "dnszone" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "ipam" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "mtu" : {
                                    "optional" : 1,
                                    "type" : "integer"
                                 },
                                 "nodes" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "pending" : {
                                    "optional" : 1,
                                    "type" : "boolean"
                                 },
                                 "reversedns" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "state" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "type" : "string"
                                 },
                                 "zone" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{zone}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new sdn zone object.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "advertise-subnets" : {
                                 "description" : "Advertise evpn subnets if you have silent hosts",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "bridge" : {
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "bridge-disable-mac-learning" : {
                                 "description" : "Disable auto mac learning.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "controller" : {
                                 "description" : "Frr router name",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "dhcp" : {
                                 "description" : "Type of the DHCP backend for this zone",
                                 "enum" : [
                                    "dnsmasq"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "disable-arp-nd-suppression" : {
                                 "description" : "Disable ipv4 arp && ipv6 neighbour discovery suppression",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "dns" : {
                                 "description" : "dns api server",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "dnszone" : {
                                 "description" : "dns domain zone  ex: mydomain.com",
                                 "format" : "dns-name",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "dp-id" : {
                                 "description" : "Faucet dataplane id",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "exitnodes" : {
                                 "description" : "List of cluster node names.",
                                 "format" : "pve-node-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "exitnodes-local-routing" : {
                                 "description" : "Allow exitnodes to connect to evpn guests",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "exitnodes-primary" : {
                                 "description" : "Force traffic to this exitnode first.",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "ipam" : {
                                 "description" : "use a specific ipam",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "mac" : {
                                 "description" : "Anycast logical router mac address",
                                 "format" : "mac-addr",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "mtu" : {
                                 "description" : "MTU",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "nodes" : {
                                 "description" : "List of cluster node names.",
                                 "format" : "pve-node-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "peers" : {
                                 "description" : "peers address list.",
                                 "format" : "ip-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "reversedns" : {
                                 "description" : "reverse dns api server",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "rt-import" : {
                                 "description" : "Route-Target import",
                                 "format" : "pve-sdn-bgp-rt-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "tag" : {
                                 "description" : "Service-VLAN Tag",
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - N)"
                              },
                              "type" : {
                                 "description" : "Plugin type.",
                                 "enum" : [
                                    "evpn",
                                    "faucet",
                                    "qinq",
                                    "simple",
                                    "vlan",
                                    "vxlan"
                                 ],
                                 "format" : "pve-configid",
                                 "type" : "string"
                              },
                              "vlan-protocol" : {
                                 "default" : "802.1q",
                                 "enum" : [
                                    "802.1q",
                                    "802.1ad"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "vrf-vxlan" : {
                                 "description" : "l3vni.",
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "vxlan-port" : {
                                 "description" : "Vxlan tunnel udp port (default 4789).",
                                 "maximum" : 65536,
                                 "minimum" : 1,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (1 - 65536)"
                              },
                              "zone" : {
                                 "description" : "The SDN zone object identifier.",
                                 "format" : "pve-sdn-zone-id",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/sdn/zones",
                              [
                                 "SDN.Allocate"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/sdn/zones",
                  "text" : "zones"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete sdn controller object configuration.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "controller" : {
                                       "description" : "The SDN controller object identifier.",
                                       "format" : "pve-sdn-controller-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/controllers",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read sdn controller configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "controller" : {
                                       "description" : "The SDN controller object identifier.",
                                       "format" : "pve-sdn-controller-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "pending" : {
                                       "description" : "Display pending config.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "running" : {
                                       "description" : "Display running config.",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/controllers/{controller}",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update sdn controller object configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "asn" : {
                                       "description" : "autonomous system number",
                                       "maximum" : 4294967296,
                                       "minimum" : 0,
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer> (0 - 4294967296)"
                                    },
                                    "bgp-multipath-as-path-relax" : {
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "controller" : {
                                       "description" : "The SDN controller object identifier.",
                                       "format" : "pve-sdn-controller-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "ebgp" : {
                                       "description" : "Enable ebgp. (remote-as external)",
                                       "optional" : 1,
                                       "type" : "boolean",
                                       "typetext" : "<boolean>"
                                    },
                                    "ebgp-multihop" : {
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "isis-domain" : {
                                       "description" : "ISIS domain.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "isis-ifaces" : {
                                       "description" : "ISIS interface.",
                                       "format" : "pve-iface-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "isis-net" : {
                                       "description" : "ISIS network entity title.",
                                       "format" : "pve-sdn-isis-net",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "loopback" : {
                                       "description" : "source loopback interface.",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "node" : {
                                       "description" : "The cluster node name.",
                                       "format" : "pve-node",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "peers" : {
                                       "description" : "peers address list.",
                                       "format" : "ip-list",
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/controllers",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/sdn/controllers/{controller}",
                        "text" : "{controller}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "SDN controllers index.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "pending" : {
                                 "description" : "Display pending config.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "running" : {
                                 "description" : "Display running config.",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "type" : {
                                 "description" : "Only list sdn controllers of specific type",
                                 "enum" : [
                                    "bgp",
                                    "evpn",
                                    "faucet",
                                    "isis"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only list entries where you have 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/controllers/<controller>'",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "controller" : {
                                    "type" : "string"
                                 },
                                 "pending" : {
                                    "optional" : 1,
                                    "type" : "boolean"
                                 },
                                 "state" : {
                                    "optional" : 1,
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{controller}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new sdn controller object.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "asn" : {
                                 "description" : "autonomous system number",
                                 "maximum" : 4294967296,
                                 "minimum" : 0,
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer> (0 - 4294967296)"
                              },
                              "bgp-multipath-as-path-relax" : {
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "controller" : {
                                 "description" : "The SDN controller object identifier.",
                                 "format" : "pve-sdn-controller-id",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "ebgp" : {
                                 "description" : "Enable ebgp. (remote-as external)",
                                 "optional" : 1,
                                 "type" : "boolean",
                                 "typetext" : "<boolean>"
                              },
                              "ebgp-multihop" : {
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "isis-domain" : {
                                 "description" : "ISIS domain.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "isis-ifaces" : {
                                 "description" : "ISIS interface.",
                                 "format" : "pve-iface-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "isis-net" : {
                                 "description" : "ISIS network entity title.",
                                 "format" : "pve-sdn-isis-net",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "loopback" : {
                                 "description" : "source loopback interface.",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "node" : {
                                 "description" : "The cluster node name.",
                                 "format" : "pve-node",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "peers" : {
                                 "description" : "peers address list.",
                                 "format" : "ip-list",
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "type" : {
                                 "description" : "Plugin type.",
                                 "enum" : [
                                    "bgp",
                                    "evpn",
                                    "faucet",
                                    "isis"
                                 ],
                                 "format" : "pve-configid",
                                 "type" : "string"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/sdn/controllers",
                              [
                                 "SDN.Allocate"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/sdn/controllers",
                  "text" : "controllers"
               },
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "info" : {
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "List PVE IPAM Entries",
                                    "method" : "GET",
                                    "name" : "ipamindex",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "ipam" : {
                                             "description" : "The SDN ipam object identifier.",
                                             "format" : "pve-sdn-ipam-id",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "description" : "Only list entries where you have 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/zones/<zone>/<vnet>'",
                                       "user" : "all"
                                    },
                                    "protected" : 1,
                                    "returns" : {
                                       "type" : "array"
                                    }
                                 }
                              },
                              "leaf" : 1,
                              "path" : "/cluster/sdn/ipams/{ipam}/status",
                              "text" : "status"
                           }
                        ],
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete sdn ipam object configuration.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "ipam" : {
                                       "description" : "The SDN ipam object identifier.",
                                       "format" : "pve-sdn-ipam-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/ipams",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read sdn ipam configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "ipam" : {
                                       "description" : "The SDN ipam object identifier.",
                                       "format" : "pve-sdn-ipam-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/ipams/{ipam}",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update sdn ipam object configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "fingerprint" : {
                                       "description" : "Certificate SHA 256 fingerprint.",
                                       "optional" : 1,
                                       "pattern" : "([A-Fa-f0-9]{2}:){31}[A-Fa-f0-9]{2}",
                                       "type" : "string"
                                    },
                                    "ipam" : {
                                       "description" : "The SDN ipam object identifier.",
                                       "format" : "pve-sdn-ipam-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "section" : {
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "token" : {
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "url" : {
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/ipams",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 0,
                        "path" : "/cluster/sdn/ipams/{ipam}",
                        "text" : "{ipam}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "SDN ipams index.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "type" : {
                                 "description" : "Only list sdn ipams of specific type",
                                 "enum" : [
                                    "netbox",
                                    "phpipam",
                                    "pve"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only list entries where you have 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/ipams/<ipam>'",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "ipam" : {
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{ipam}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new sdn ipam object.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "fingerprint" : {
                                 "description" : "Certificate SHA 256 fingerprint.",
                                 "optional" : 1,
                                 "pattern" : "([A-Fa-f0-9]{2}:){31}[A-Fa-f0-9]{2}",
                                 "type" : "string"
                              },
                              "ipam" : {
                                 "description" : "The SDN ipam object identifier.",
                                 "format" : "pve-sdn-ipam-id",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "section" : {
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "token" : {
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "type" : {
                                 "description" : "Plugin type.",
                                 "enum" : [
                                    "netbox",
                                    "phpipam",
                                    "pve"
                                 ],
                                 "format" : "pve-configid",
                                 "type" : "string"
                              },
                              "url" : {
                                 "optional" : 1,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/sdn/ipams",
                              [
                                 "SDN.Allocate"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/sdn/ipams",
                  "text" : "ipams"
               },
               {
                  "children" : [
                     {
                        "info" : {
                           "DELETE" : {
                              "allowtoken" : 1,
                              "description" : "Delete sdn dns object configuration.",
                              "method" : "DELETE",
                              "name" : "delete",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "dns" : {
                                       "description" : "The SDN dns object identifier.",
                                       "format" : "pve-sdn-dns-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/dns",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           },
                           "GET" : {
                              "allowtoken" : 1,
                              "description" : "Read sdn dns configuration.",
                              "method" : "GET",
                              "name" : "read",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "dns" : {
                                       "description" : "The SDN dns object identifier.",
                                       "format" : "pve-sdn-dns-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 }
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/dns/{dns}",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "returns" : {
                                 "type" : "object"
                              }
                           },
                           "PUT" : {
                              "allowtoken" : 1,
                              "description" : "Update sdn dns object configuration.",
                              "method" : "PUT",
                              "name" : "update",
                              "parameters" : {
                                 "additionalProperties" : 0,
                                 "properties" : {
                                    "delete" : {
                                       "description" : "A list of settings you want to delete.",
                                       "format" : "pve-configid-list",
                                       "maxLength" : 4096,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "digest" : {
                                       "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                       "maxLength" : 64,
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "dns" : {
                                       "description" : "The SDN dns object identifier.",
                                       "format" : "pve-sdn-dns-id",
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "fingerprint" : {
                                       "description" : "Certificate SHA 256 fingerprint.",
                                       "optional" : 1,
                                       "pattern" : "([A-Fa-f0-9]{2}:){31}[A-Fa-f0-9]{2}",
                                       "type" : "string"
                                    },
                                    "key" : {
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    },
                                    "reversemaskv6" : {
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "ttl" : {
                                       "optional" : 1,
                                       "type" : "integer",
                                       "typetext" : "<integer>"
                                    },
                                    "url" : {
                                       "optional" : 1,
                                       "type" : "string",
                                       "typetext" : "<string>"
                                    }
                                 },
                                 "type" : "object"
                              },
                              "permissions" : {
                                 "check" : [
                                    "perm",
                                    "/sdn/dns",
                                    [
                                       "SDN.Allocate"
                                    ]
                                 ]
                              },
                              "protected" : 1,
                              "returns" : {
                                 "type" : "null"
                              }
                           }
                        },
                        "leaf" : 1,
                        "path" : "/cluster/sdn/dns/{dns}",
                        "text" : "{dns}"
                     }
                  ],
                  "info" : {
                     "GET" : {
                        "allowtoken" : 1,
                        "description" : "SDN dns index.",
                        "method" : "GET",
                        "name" : "index",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "type" : {
                                 "description" : "Only list sdn dns of specific type",
                                 "enum" : [
                                    "powerdns"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           }
                        },
                        "permissions" : {
                           "description" : "Only list entries where you have 'SDN.Audit' or 'SDN.Allocate' permissions on '/sdn/dns/<dns>'",
                           "user" : "all"
                        },
                        "returns" : {
                           "items" : {
                              "properties" : {
                                 "dns" : {
                                    "type" : "string"
                                 },
                                 "type" : {
                                    "type" : "string"
                                 }
                              },
                              "type" : "object"
                           },
                           "links" : [
                              {
                                 "href" : "{dns}",
                                 "rel" : "child"
                              }
                           ],
                           "type" : "array"
                        }
                     },
                     "POST" : {
                        "allowtoken" : 1,
                        "description" : "Create a new sdn dns object.",
                        "method" : "POST",
                        "name" : "create",
                        "parameters" : {
                           "additionalProperties" : 0,
                           "properties" : {
                              "dns" : {
                                 "description" : "The SDN dns object identifier.",
                                 "format" : "pve-sdn-dns-id",
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "fingerprint" : {
                                 "description" : "Certificate SHA 256 fingerprint.",
                                 "optional" : 1,
                                 "pattern" : "([A-Fa-f0-9]{2}:){31}[A-Fa-f0-9]{2}",
                                 "type" : "string"
                              },
                              "key" : {
                                 "optional" : 0,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              },
                              "reversemaskv6" : {
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "reversev6mask" : {
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "ttl" : {
                                 "optional" : 1,
                                 "type" : "integer",
                                 "typetext" : "<integer>"
                              },
                              "type" : {
                                 "description" : "Plugin type.",
                                 "enum" : [
                                    "powerdns"
                                 ],
                                 "format" : "pve-configid",
                                 "type" : "string"
                              },
                              "url" : {
                                 "optional" : 0,
                                 "type" : "string",
                                 "typetext" : "<string>"
                              }
                           },
                           "type" : "object"
                        },
                        "permissions" : {
                           "check" : [
                              "perm",
                              "/sdn/dns",
                              [
                                 "SDN.Allocate"
                              ]
                           ]
                        },
                        "protected" : 1,
                        "returns" : {
                           "type" : "null"
                        }
                     }
                  },
                  "leaf" : 0,
                  "path" : "/cluster/sdn/dns",
                  "text" : "dns"
               }
            ],
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Directory index.",
                  "method" : "GET",
                  "name" : "index",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/sdn",
                        [
                           "SDN.Audit"
                        ]
                     ]
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {
                           "id" : {
                              "type" : "string"
                           }
                        },
                        "type" : "object"
                     },
                     "links" : [
                        {
                           "href" : "{id}",
                           "rel" : "child"
                        }
                     ],
                     "type" : "array"
                  }
               },
               "PUT" : {
                  "allowtoken" : 1,
                  "description" : "Apply sdn controller changes && reload.",
                  "method" : "PUT",
                  "name" : "reload",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/sdn",
                        [
                           "SDN.Allocate"
                        ]
                     ]
                  },
                  "protected" : 1,
                  "returns" : {
                     "type" : "string"
                  }
               }
            },
            "leaf" : 0,
            "path" : "/cluster/sdn",
            "text" : "sdn"
         },
         {
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Read cluster log",
                  "method" : "GET",
                  "name" : "log",
                  "parameters" : {
                     "additionalProperties" : 0,
                     "properties" : {
                        "max" : {
                           "description" : "Maximum number of entries.",
                           "minimum" : 1,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (1 - N)"
                        }
                     }
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {},
                        "type" : "object"
                     },
                     "type" : "array"
                  }
               }
            },
            "leaf" : 1,
            "path" : "/cluster/log",
            "text" : "log"
         },
         {
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Resources index (cluster wide).",
                  "method" : "GET",
                  "name" : "resources",
                  "parameters" : {
                     "additionalProperties" : 0,
                     "properties" : {
                        "type" : {
                           "description" : "Resource type.",
                           "enum" : [
                              "vm",
                              "storage",
                              "node",
                              "sdn"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        }
                     }
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {
                           "cgroup-mode" : {
                              "description" : "The cgroup mode the node operates under (for type 'node').",
                              "optional" : 1,
                              "type" : "integer"
                           },
                           "content" : {
                              "description" : "Allowed storage content types (for type 'storage').",
                              "format" : "pve-storage-content-list",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "cpu" : {
                              "description" : "CPU utilization (for types 'node', 'qemu' and 'lxc').",
                              "minimum" : 0,
                              "optional" : 1,
                              "renderer" : "fraction_as_percentage",
                              "type" : "number"
                           },
                           "disk" : {
                              "description" : "Used disk space in bytes (for type 'storage'), used root image space for VMs (for types 'qemu' and 'lxc').",
                              "minimum" : 0,
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "diskread" : {
                              "description" : "The amount of bytes the guest read from its block devices since the guest was started. This info is not available for all storage types. (for types 'qemu' and 'lxc')",
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "diskwrite" : {
                              "description" : "The amount of bytes the guest wrote to its block devices since the guest was started. This info is not available for all storage types. (for types 'qemu' and 'lxc')",
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "hastate" : {
                              "description" : "HA service status (for HA managed VMs).",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "id" : {
                              "description" : "Resource id.",
                              "type" : "string"
                           },
                           "level" : {
                              "description" : "Support level (for type 'node').",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "lock" : {
                              "description" : "The guest's current config lock (for types 'qemu' and 'lxc')",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "maxcpu" : {
                              "description" : "Number of available CPUs (for types 'node', 'qemu' and 'lxc').",
                              "minimum" : 0,
                              "optional" : 1,
                              "type" : "number"
                           },
                           "maxdisk" : {
                              "description" : "Storage size in bytes (for type 'storage'), root image size for VMs (for types 'qemu' and 'lxc').",
                              "minimum" : 0,
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "maxmem" : {
                              "description" : "Number of available memory in bytes (for types 'node', 'qemu' and 'lxc').",
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "mem" : {
                              "description" : "Used memory in bytes (for types 'node', 'qemu' and 'lxc').",
                              "minimum" : 0,
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "name" : {
                              "description" : "Name of the resource.",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "netin" : {
                              "description" : "The amount of traffic in bytes that was sent to the guest over the network since it was started. (for types 'qemu' and 'lxc')",
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "netout" : {
                              "description" : "The amount of traffic in bytes that was sent from the guest over the network since it was started. (for types 'qemu' and 'lxc')",
                              "optional" : 1,
                              "renderer" : "bytes",
                              "type" : "integer"
                           },
                           "node" : {
                              "description" : "The cluster node name (for types 'node', 'storage', 'qemu', and 'lxc').",
                              "format" : "pve-node",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "plugintype" : {
                              "description" : "More specific type, if available.",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "pool" : {
                              "description" : "The pool name (for types 'pool', 'qemu' and 'lxc').",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "status" : {
                              "description" : "Resource type dependent status.",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "storage" : {
                              "description" : "The storage identifier (for type 'storage').",
                              "format" : "pve-storage-id",
                              "format_description" : "storage ID",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "tags" : {
                              "description" : "The guest's tags (for types 'qemu' and 'lxc')",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "template" : {
                              "default" : 0,
                              "description" : "Determines if the guest is a template. (for types 'qemu' and 'lxc')",
                              "optional" : 1,
                              "type" : "boolean"
                           },
                           "type" : {
                              "description" : "Resource type.",
                              "enum" : [
                                 "node",
                                 "storage",
                                 "pool",
                                 "qemu",
                                 "lxc",
                                 "openvz",
                                 "sdn"
                              ],
                              "type" : "string"
                           },
                           "uptime" : {
                              "description" : "Uptime of node or virtual guest in seconds (for types 'node', 'qemu' and 'lxc').",
                              "optional" : 1,
                              "renderer" : "duration",
                              "type" : "integer"
                           },
                           "vmid" : {
                              "description" : "The numerical vmid (for types 'qemu' and 'lxc').",
                              "format" : "pve-vmid",
                              "maximum" : 999999999,
                              "minimum" : 100,
                              "optional" : 1,
                              "type" : "integer"
                           }
                        },
                        "type" : "object"
                     },
                     "type" : "array"
                  }
               }
            },
            "leaf" : 1,
            "path" : "/cluster/resources",
            "text" : "resources"
         },
         {
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "List recent tasks (cluster wide).",
                  "method" : "GET",
                  "name" : "tasks",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "items" : {
                        "properties" : {
                           "upid" : {
                              "type" : "string"
                           }
                        },
                        "type" : "object"
                     },
                     "type" : "array"
                  }
               }
            },
            "leaf" : 1,
            "path" : "/cluster/tasks",
            "text" : "tasks"
         },
         {
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Get datacenter options. Without 'Sys.Audit' on '/' not all options are returned.",
                  "method" : "GET",
                  "name" : "get_options",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/",
                        [
                           "Sys.Audit"
                        ]
                     ],
                     "user" : "all"
                  },
                  "returns" : {
                     "type" : "object"
                  }
               },
               "PUT" : {
                  "allowtoken" : 1,
                  "description" : "Set datacenter options.",
                  "method" : "PUT",
                  "name" : "set_options",
                  "parameters" : {
                     "additionalProperties" : 0,
                     "properties" : {
                        "bwlimit" : {
                           "description" : "Set I/O bandwidth limit for various operations (in KiB/s).",
                           "format" : {
                              "clone" : {
                                 "description" : "bandwidth limit in KiB/s for cloning disks",
                                 "format_description" : "LIMIT",
                                 "minimum" : "0",
                                 "optional" : 1,
                                 "type" : "number"
                              },
                              "default" : {
                                 "description" : "default bandwidth limit in KiB/s",
                                 "format_description" : "LIMIT",
                                 "minimum" : "0",
                                 "optional" : 1,
                                 "type" : "number"
                              },
                              "migration" : {
                                 "description" : "bandwidth limit in KiB/s for migrating guests (including moving local disks)",
                                 "format_description" : "LIMIT",
                                 "minimum" : "0",
                                 "optional" : 1,
                                 "type" : "number"
                              },
                              "move" : {
                                 "description" : "bandwidth limit in KiB/s for moving disks",
                                 "format_description" : "LIMIT",
                                 "minimum" : "0",
                                 "optional" : 1,
                                 "type" : "number"
                              },
                              "restore" : {
                                 "description" : "bandwidth limit in KiB/s for restoring guests from backups",
                                 "format_description" : "LIMIT",
                                 "minimum" : "0",
                                 "optional" : 1,
                                 "type" : "number"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[clone=<LIMIT>] [,default=<LIMIT>] [,migration=<LIMIT>] [,move=<LIMIT>] [,restore=<LIMIT>]"
                        },
                        "consent-text" : {
                           "description" : "Consent text that is displayed before logging in.",
                           "maxLength" : 65536,
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "console" : {
                           "description" : "Select the default Console viewer. You can either use the builtin java applet (VNC; deprecated and maps to html5), an external virt-viewer comtatible application (SPICE), an HTML5 based vnc viewer (noVNC), or an HTML5 based console client (xtermjs). If the selected viewer is not available (e.g. SPICE not activated for the VM), the fallback is noVNC.",
                           "enum" : [
                              "applet",
                              "vv",
                              "html5",
                              "xtermjs"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "crs" : {
                           "description" : "Cluster resource scheduling settings.",
                           "format" : {
                              "ha" : {
                                 "default" : "basic",
                                 "description" : "Use this resource scheduler mode for HA.",
                                 "enum" : [
                                    "basic",
                                    "static"
                                 ],
                                 "optional" : 1,
                                 "type" : "string",
                                 "verbose_description" : "Configures how the HA manager should select nodes to start or recover services. With 'basic', only the number of services is used, with 'static', static CPU and memory configuration of services is considered."
                              },
                              "ha-rebalance-on-start" : {
                                 "default" : 0,
                                 "description" : "Set to use CRS for selecting a suited node when a HA services request-state changes from stop to start.",
                                 "optional" : 1,
                                 "type" : "boolean"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[ha=<basic|static>] [,ha-rebalance-on-start=<1|0>]"
                        },
                        "delete" : {
                           "description" : "A list of settings you want to delete.",
                           "format" : "pve-configid-list",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "description" : {
                           "description" : "Datacenter description. Shown in the web-interface datacenter notes panel. This is saved as comment inside the configuration file.",
                           "maxLength" : 65536,
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "email_from" : {
                           "description" : "Specify email address to send notification from (default is root@$hostname)",
                           "format" : "email-opt",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>"
                        },
                        "fencing" : {
                           "default" : "watchdog",
                           "description" : "Set the fencing mode of the HA cluster. Hardware mode needs a valid configuration of fence devices in /etc/pve/ha/fence.cfg. With both all two modes are used.\n\nWARNING: 'hardware' and 'both' are EXPERIMENTAL & WIP",
                           "enum" : [
                              "watchdog",
                              "hardware",
                              "both"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "ha" : {
                           "description" : "Cluster wide HA settings.",
                           "format" : {
                              "shutdown_policy" : {
                                 "default" : "conditional",
                                 "description" : "The policy for HA services on node shutdown. 'freeze' disables auto-recovery, 'failover' ensures recovery, 'conditional' recovers on poweroff and freezes on reboot. 'migrate' will migrate running services to other nodes, if possible. With 'freeze' or 'failover', HA Services will always get stopped first on shutdown.",
                                 "enum" : [
                                    "freeze",
                                    "failover",
                                    "conditional",
                                    "migrate"
                                 ],
                                 "type" : "string",
                                 "verbose_description" : "Describes the policy for handling HA services on poweroff or reboot of a node. Freeze will always freeze services which are still located on the node on shutdown, those services won't be recovered by the HA manager. Failover will not mark the services as frozen and thus the services will get recovered to other nodes, if the shutdown node does not come up again quickly (< 1min). 'conditional' chooses automatically depending on the type of shutdown, i.e., on a reboot the service will be frozen but on a poweroff the service will stay as is, and thus get recovered after about 2 minutes. Migrate will try to move all running services to another node when a reboot or shutdown was triggered. The poweroff process will only continue once no running services are located on the node anymore. If the node comes up again, the service will be moved back to the previously powered-off node, at least if no other migration, reloaction or recovery took place."
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "shutdown_policy=<enum>"
                        },
                        "http_proxy" : {
                           "description" : "Specify external http proxy which is used for downloads (example: 'http://username:password@host:port/')",
                           "optional" : 1,
                           "pattern" : "http://.*",
                           "type" : "string"
                        },
                        "keyboard" : {
                           "description" : "Default keybord layout for vnc server.",
                           "enum" : [
                              "de",
                              "de-ch",
                              "da",
                              "en-gb",
                              "en-us",
                              "es",
                              "fi",
                              "fr",
                              "fr-be",
                              "fr-ca",
                              "fr-ch",
                              "hu",
                              "is",
                              "it",
                              "ja",
                              "lt",
                              "mk",
                              "nl",
                              "no",
                              "pl",
                              "pt",
                              "pt-br",
                              "sv",
                              "sl",
                              "tr"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "language" : {
                           "description" : "Default GUI language.",
                           "enum" : [
                              "ar",
                              "ca",
                              "da",
                              "de",
                              "en",
                              "es",
                              "eu",
                              "fa",
                              "fr",
                              "hr",
                              "he",
                              "it",
                              "ja",
                              "ka",
                              "kr",
                              "nb",
                              "nl",
                              "nn",
                              "pl",
                              "pt_BR",
                              "ru",
                              "sl",
                              "sv",
                              "tr",
                              "ukr",
                              "zh_CN",
                              "zh_TW"
                           ],
                           "optional" : 1,
                           "type" : "string"
                        },
                        "mac_prefix" : {
                           "default" : "BC:24:11",
                           "description" : "Prefix for the auto-generated MAC addresses of virtual guests. The default 'BC:24:11' is the OUI assigned by the IEEE to Proxmox Server Solutions GmbH for a 24-bit large MAC block. You're allowed to use this in local networks, i.e., those not directly reachable by the public (e.g., in a LAN or behind NAT).",
                           "format" : "mac-prefix",
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "<string>",
                           "verbose_description" : "Prefix for the auto-generated MAC addresses of virtual guests. The default `BC:24:11` is the Organizationally Unique Identifier (OUI) assigned by the IEEE to Proxmox Server Solutions GmbH for a MAC Address Block Large (MA-L). You're allowed to use this in local networks, i.e., those not directly reachable by the public (e.g., in a LAN or NAT/Masquerading).\n \nNote that when you run multiple cluster that (partially) share the networks of their virtual guests, it's highly recommended that you extend the default MAC prefix, or generate a custom (valid) one, to reduce the chance of MAC collisions. For example, add a separate extra hexadecimal to the Proxmox OUI for each cluster, like `BC:24:11:0` for the first, `BC:24:11:1` for the second, and so on.\n Alternatively, you can also separate the networks of the guests logically, e.g., by using VLANs.\n\nFor publicly accessible guests it's recommended that you get your own https://standards.ieee.org/products-programs/regauth/[OUI from the IEEE] registered or coordinate with your, or your hosting providers, network admins."
                        },
                        "max_workers" : {
                           "description" : "Defines how many workers (per node) are maximal started  on actions like 'stopall VMs' or task from the ha-manager.",
                           "minimum" : 1,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (1 - N)"
                        },
                        "migration" : {
                           "description" : "For cluster wide migration settings.",
                           "format" : {
                              "network" : {
                                 "description" : "CIDR of the (sub) network that is used for migration.",
                                 "format" : "CIDR",
                                 "format_description" : "CIDR",
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "type" : {
                                 "default" : "secure",
                                 "default_key" : 1,
                                 "description" : "Migration traffic is encrypted using an SSH tunnel by default. On secure, completely private networks this can be disabled to increase performance.",
                                 "enum" : [
                                    "secure",
                                    "insecure"
                                 ],
                                 "type" : "string"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[type=]<secure|insecure> [,network=<CIDR>]"
                        },
                        "migration_unsecure" : {
                           "description" : "Migration is secure using SSH tunnel by default. For secure private networks you can disable it to speed up migration. Deprecated, use the 'migration' property instead!",
                           "optional" : 1,
                           "type" : "boolean",
                           "typetext" : "<boolean>"
                        },
                        "next-id" : {
                           "description" : "Control the range for the free VMID auto-selection pool.",
                           "format" : {
                              "lower" : {
                                 "default" : 100,
                                 "description" : "Lower, inclusive boundary for free next-id API range.",
                                 "max" : 999999999,
                                 "min" : 100,
                                 "optional" : 1,
                                 "type" : "integer"
                              },
                              "upper" : {
                                 "default" : 1000000,
                                 "description" : "Upper, exclusive boundary for free next-id API range.",
                                 "max" : 1000000000,
                                 "min" : 100,
                                 "optional" : 1,
                                 "type" : "integer"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[lower=<integer>] [,upper=<integer>]"
                        },
                        "notify" : {
                           "description" : "Cluster-wide notification settings.",
                           "format" : {
                              "fencing" : {
                                 "description" : "UNUSED - Use datacenter notification settings instead.",
                                 "enum" : [
                                    "always",
                                    "never"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "package-updates" : {
                                 "default" : "auto",
                                 "description" : "DEPRECATED: Use datacenter notification settings instead. Control when the daily update job should send out notifications.",
                                 "enum" : [
                                    "auto",
                                    "always",
                                    "never"
                                 ],
                                 "optional" : 1,
                                 "type" : "string",
                                 "verbose_description" : "DEPRECATED: Use datacenter notification settings instead.\nControl how often the daily update job should send out notifications:\n* 'auto' daily for systems with a valid subscription, as those are assumed to be  production-ready and thus should know about pending updates.\n* 'always' every update, if there are new pending updates.\n* 'never' never send a notification for new pending updates.\n"
                              },
                              "replication" : {
                                 "description" : "UNUSED - Use datacenter notification settings instead.",
                                 "enum" : [
                                    "always",
                                    "never"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "target-fencing" : {
                                 "description" : "UNUSED - Use datacenter notification settings instead.",
                                 "format_description" : "TARGET",
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "target-package-updates" : {
                                 "description" : "UNUSED - Use datacenter notification settings instead.",
                                 "format_description" : "TARGET",
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "target-replication" : {
                                 "description" : "UNUSED - Use datacenter notification settings instead.",
                                 "format_description" : "TARGET",
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[fencing=<always|never>] [,package-updates=<auto|always|never>] [,replication=<always|never>] [,target-fencing=<TARGET>] [,target-package-updates=<TARGET>] [,target-replication=<TARGET>]"
                        },
                        "registered-tags" : {
                           "description" : "A list of tags that require a `Sys.Modify` on '/' to set and delete. Tags set here that are also in 'user-tag-access' also require `Sys.Modify`.",
                           "optional" : 1,
                           "pattern" : "(?:(?^i:[a-z0-9_][a-z0-9_\\-\\+\\.]*);)*(?^i:[a-z0-9_][a-z0-9_\\-\\+\\.]*)",
                           "type" : "string",
                           "typetext" : "<tag>[;<tag>...]"
                        },
                        "tag-style" : {
                           "description" : "Tag style options.",
                           "format" : {
                              "case-sensitive" : {
                                 "default" : 0,
                                 "description" : "Controls if filtering for unique tags on update should check case-sensitive.",
                                 "optional" : 1,
                                 "type" : "boolean"
                              },
                              "color-map" : {
                                 "description" : "Manual color mapping for tags (semicolon separated).",
                                 "optional" : 1,
                                 "pattern" : "(?:(?^i:[a-z0-9_][a-z0-9_\\-\\+\\.]*):[0-9a-fA-F]{6}(?::[0-9a-fA-F]{6})?)(?:;(?:(?^i:[a-z0-9_][a-z0-9_\\-\\+\\.]*):[0-9a-fA-F]{6}(?::[0-9a-fA-F]{6})?))*",
                                 "type" : "string",
                                 "typetext" : "<tag>:<hex-color>[:<hex-color-for-text>][;<tag>=...]"
                              },
                              "ordering" : {
                                 "default" : "alphabetical",
                                 "description" : "Controls the sorting of the tags in the web-interface and the API update.",
                                 "enum" : [
                                    "config",
                                    "alphabetical"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "shape" : {
                                 "default" : "circle",
                                 "description" : "Tag shape for the web ui tree. 'full' draws the full tag. 'circle' draws only a circle with the background color. 'dense' only draws a small rectancle (useful when many tags are assigned to each guest).'none' disables showing the tags.",
                                 "enum" : [
                                    "full",
                                    "circle",
                                    "dense",
                                    "none"
                                 ],
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[case-sensitive=<1|0>] [,color-map=<tag>:<hex-color>[:<hex-color-for-text>][;<tag>=...]] [,ordering=<config|alphabetical>] [,shape=<enum>]"
                        },
                        "u2f" : {
                           "description" : "u2f",
                           "format" : {
                              "appid" : {
                                 "description" : "U2F AppId URL override. Defaults to the origin.",
                                 "format_description" : "APPID",
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "origin" : {
                                 "description" : "U2F Origin override. Mostly useful for single nodes with a single URL.",
                                 "format_description" : "URL",
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[appid=<APPID>] [,origin=<URL>]"
                        },
                        "user-tag-access" : {
                           "description" : "Privilege options for user-settable tags",
                           "format" : {
                              "user-allow" : {
                                 "default" : "free",
                                 "description" : "Controls tag usage for users without `Sys.Modify` on `/` by either allowing `none`, a `list`, already `existing` or anything (`free`).",
                                 "enum" : [
                                    "none",
                                    "list",
                                    "existing",
                                    "free"
                                 ],
                                 "optional" : 1,
                                 "type" : "string",
                                 "verbose_description" : "Controls which tags can be set or deleted on resources a user controls (such as guests). Users with the `Sys.Modify` privilege on `/` are alwaysunrestricted.\n* 'none' no tags are usable.\n* 'list' tags from 'user-allow-list' are usable.\n* 'existing' like list, but already existing tags of resources are also usable.\n* 'free' no tag restrictions.\n"
                              },
                              "user-allow-list" : {
                                 "description" : "List of tags users are allowed to set and delete (semicolon separated) for 'user-allow' values 'list' and 'existing'.",
                                 "optional" : 1,
                                 "pattern" : "(?^i:[a-z0-9_][a-z0-9_\\-\\+\\.]*)(?:;(?^i:[a-z0-9_][a-z0-9_\\-\\+\\.]*))*",
                                 "type" : "string",
                                 "typetext" : "<tag>[;<tag>...]"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[user-allow=<enum>] [,user-allow-list=<tag>[;<tag>...]]"
                        },
                        "webauthn" : {
                           "description" : "webauthn configuration",
                           "format" : {
                              "allow-subdomains" : {
                                 "default" : 1,
                                 "description" : "Whether to allow the origin to be a subdomain, rather than the exact URL.",
                                 "optional" : 1,
                                 "type" : "boolean"
                              },
                              "id" : {
                                 "description" : "Relying party ID. Must be the domain name without protocol, port or location. Changing this *will* break existing credentials.",
                                 "format_description" : "DOMAINNAME",
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "origin" : {
                                 "description" : "Site origin. Must be a `https://` URL (or `http://localhost`). Should contain the address users type in their browsers to access the web interface. Changing this *may* break existing credentials.",
                                 "format_description" : "URL",
                                 "optional" : 1,
                                 "type" : "string"
                              },
                              "rp" : {
                                 "description" : "Relying party name. Any text identifier. Changing this *may* break existing credentials.",
                                 "format_description" : "RELYING_PARTY",
                                 "optional" : 1,
                                 "type" : "string"
                              }
                           },
                           "optional" : 1,
                           "type" : "string",
                           "typetext" : "[allow-subdomains=<1|0>] [,id=<DOMAINNAME>] [,origin=<URL>] [,rp=<RELYING_PARTY>]"
                        }
                     }
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/",
                        [
                           "Sys.Modify"
                        ]
                     ]
                  },
                  "protected" : 1,
                  "returns" : {
                     "type" : "null"
                  }
               }
            },
            "leaf" : 1,
            "path" : "/cluster/options",
            "text" : "options"
         },
         {
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Get cluster status information.",
                  "method" : "GET",
                  "name" : "get_status",
                  "parameters" : {
                     "additionalProperties" : 0
                  },
                  "permissions" : {
                     "check" : [
                        "perm",
                        "/",
                        [
                           "Sys.Audit"
                        ]
                     ]
                  },
                  "protected" : 1,
                  "returns" : {
                     "items" : {
                        "properties" : {
                           "id" : {
                              "type" : "string"
                           },
                           "ip" : {
                              "description" : "[node] IP of the resolved nodename.",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "level" : {
                              "description" : "[node] Proxmox VE Subscription level, indicates if eligible for enterprise support as well as access to the stable Proxmox VE Enterprise Repository.",
                              "optional" : 1,
                              "type" : "string"
                           },
                           "local" : {
                              "description" : "[node] Indicates if this is the responding node.",
                              "optional" : 1,
                              "type" : "boolean"
                           },
                           "name" : {
                              "type" : "string"
                           },
                           "nodeid" : {
                              "description" : "[node] ID of the node from the corosync configuration.",
                              "optional" : 1,
                              "type" : "integer"
                           },
                           "nodes" : {
                              "description" : "[cluster] Nodes count, including offline nodes.",
                              "optional" : 1,
                              "type" : "integer"
                           },
                           "online" : {
                              "description" : "[node] Indicates if the node is online or offline.",
                              "optional" : 1,
                              "type" : "boolean"
                           },
                           "quorate" : {
                              "description" : "[cluster] Indicates if there is a majority of nodes online to make decisions",
                              "optional" : 1,
                              "type" : "boolean"
                           },
                           "type" : {
                              "description" : "Indicates the type, either cluster or node. The type defines the object properties e.g. quorate available for type cluster.",
                              "enum" : [
                                 "cluster",
                                 "node"
                              ],
                              "type" : "string"
                           },
                           "version" : {
                              "description" : "[cluster] Current version of the corosync configuration file.",
                              "optional" : 1,
                              "type" : "integer"
                           }
                        },
                        "type" : "object"
                     },
                     "type" : "array"
                  }
               }
            },
            "leaf" : 1,
            "path" : "/cluster/status",
            "text" : "status"
         },
         {
            "info" : {
               "GET" : {
                  "allowtoken" : 1,
                  "description" : "Get next free VMID. Pass a VMID to assert that its free (at time of check).",
                  "method" : "GET",
                  "name" : "nextid",
                  "parameters" : {
                     "additionalProperties" : 0,
                     "properties" : {
                        "vmid" : {
                           "description" : "The (unique) ID of the VM.",
                           "format" : "pve-vmid",
                           "maximum" : 999999999,
                           "minimum" : 100,
                           "optional" : 1,
                           "type" : "integer",
                           "typetext" : "<integer> (100 - 999999999)"
                        }
                     }
                  },
                  "permissions" : {
                     "user" : "all"
                  },
                  "returns" : {
                     "description" : "The next free VMID.",
                     "type" : "integer"
                  }
               }
            },
            "leaf" : 1,
            "path" : "/cluster/nextid",
            "text" : "nextid"
         }
      ],
      "info" : {
         "GET" : {
            "allowtoken" : 1,
            "description" : "Cluster index.",
            "method" : "GET",
            "name" : "index",
            "parameters" : {
               "additionalProperties" : 0
            },
            "permissions" : {
               "user" : "all"
            },
            "returns" : {
               "items" : {
                  "properties" : {},
                  "type" : "object"
               },
               "links" : [
                  {
                     "href" : "{name}",
                     "rel" : "child"
                  }
               ],
               "type" : "array"
            }
         }
      },
      "leaf" : 0,
      "path" : "/cluster",
      "text" : "cluster"
   },
   {
      "children" : [
         {
            "children" : [
               {
                  "children" : [
                     {
                        "children" : [
                           {
                              "children" : [
                                 {
                                    "children" : [
                                       {
                                          "info" : {
                                             "DELETE" : {
                                                "allowtoken" : 1,
                                                "description" : "Delete rule.",
                                                "method" : "DELETE",
                                                "name" : "delete_rule",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "digest" : {
                                                         "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                         "maxLength" : 64,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "pos" : {
                                                         "description" : "Update rule at position <pos>.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Config.Network"
                                                      ]
                                                   ]
                                                },
                                                "protected" : 1,
                                                "proxyto" : null,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             },
                                             "GET" : {
                                                "allowtoken" : 1,
                                                "description" : "Get single rule data.",
                                                "method" : "GET",
                                                "name" : "get_rule",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "pos" : {
                                                         "description" : "Update rule at position <pos>.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Audit"
                                                      ]
                                                   ]
                                                },
                                                "proxyto" : null,
                                                "returns" : {
                                                   "properties" : {
                                                      "action" : {
                                                         "type" : "string"
                                                      },
                                                      "comment" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "dest" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "dport" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "enable" : {
                                                         "optional" : 1,
                                                         "type" : "integer"
                                                      },
                                                      "icmp-type" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "iface" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "ipversion" : {
                                                         "optional" : 1,
                                                         "type" : "integer"
                                                      },
                                                      "log" : {
                                                         "description" : "Log level for firewall rule",
                                                         "enum" : [
                                                            "emerg",
                                                            "alert",
                                                            "crit",
                                                            "err",
                                                            "warning",
                                                            "notice",
                                                            "info",
                                                            "debug",
                                                            "nolog"
                                                         ],
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "macro" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "pos" : {
                                                         "type" : "integer"
                                                      },
                                                      "proto" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "source" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "sport" : {
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "type" : {
                                                         "type" : "string"
                                                      }
                                                   },
                                                   "type" : "object"
                                                }
                                             },
                                             "PUT" : {
                                                "allowtoken" : 1,
                                                "description" : "Modify rule data.",
                                                "method" : "PUT",
                                                "name" : "update_rule",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "action" : {
                                                         "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                                         "maxLength" : 20,
                                                         "minLength" : 2,
                                                         "optional" : 1,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "comment" : {
                                                         "description" : "Descriptive comment.",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "delete" : {
                                                         "description" : "A list of settings you want to delete.",
                                                         "format" : "pve-configid-list",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "dest" : {
                                                         "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                         "format" : "pve-fw-addr-spec",
                                                         "maxLength" : 512,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "digest" : {
                                                         "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                         "maxLength" : 64,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "dport" : {
                                                         "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                         "format" : "pve-fw-dport-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "enable" : {
                                                         "description" : "Flag to enable/disable a rule.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "icmp-type" : {
                                                         "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                                         "format" : "pve-fw-icmp-type-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "iface" : {
                                                         "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                                         "format" : "pve-iface",
                                                         "maxLength" : 20,
                                                         "minLength" : 2,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "log" : {
                                                         "description" : "Log level for firewall rule.",
                                                         "enum" : [
                                                            "emerg",
                                                            "alert",
                                                            "crit",
                                                            "err",
                                                            "warning",
                                                            "notice",
                                                            "info",
                                                            "debug",
                                                            "nolog"
                                                         ],
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "macro" : {
                                                         "description" : "Use predefined standard macro.",
                                                         "maxLength" : 128,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "moveto" : {
                                                         "description" : "Move rule to new position <moveto>. Other arguments are ignored.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "pos" : {
                                                         "description" : "Update rule at position <pos>.",
                                                         "minimum" : 0,
                                                         "optional" : 1,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (0 - N)"
                                                      },
                                                      "proto" : {
                                                         "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                                         "format" : "pve-fw-protocol-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "source" : {
                                                         "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                         "format" : "pve-fw-addr-spec",
                                                         "maxLength" : 512,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "sport" : {
                                                         "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                         "format" : "pve-fw-sport-spec",
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "type" : {
                                                         "description" : "Rule type.",
                                                         "enum" : [
                                                            "in",
                                                            "out",
                                                            "forward",
                                                            "group"
                                                         ],
                                                         "optional" : 1,
                                                         "type" : "string"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Config.Network"
                                                      ]
                                                   ]
                                                },
                                                "protected" : 1,
                                                "proxyto" : null,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             }
                                          },
                                          "leaf" : 1,
                                          "path" : "/nodes/{node}/qemu/{vmid}/firewall/rules/{pos}",
                                          "text" : "{pos}"
                                       }
                                    ],
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "List rules.",
                                          "method" : "GET",
                                          "name" : "get_rules",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Audit"
                                                ]
                                             ]
                                          },
                                          "proxyto" : null,
                                          "returns" : {
                                             "items" : {
                                                "properties" : {
                                                   "pos" : {
                                                      "type" : "integer"
                                                   }
                                                },
                                                "type" : "object"
                                             },
                                             "links" : [
                                                {
                                                   "href" : "{pos}",
                                                   "rel" : "child"
                                                }
                                             ],
                                             "type" : "array"
                                          }
                                       },
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Create new rule.",
                                          "method" : "POST",
                                          "name" : "create_rule",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "action" : {
                                                   "description" : "Rule action ('ACCEPT', 'DROP', 'REJECT') or security group name.",
                                                   "maxLength" : 20,
                                                   "minLength" : 2,
                                                   "optional" : 0,
                                                   "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                   "type" : "string"
                                                },
                                                "comment" : {
                                                   "description" : "Descriptive comment.",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dest" : {
                                                   "description" : "Restrict packet destination address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                   "format" : "pve-fw-addr-spec",
                                                   "maxLength" : 512,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "digest" : {
                                                   "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                   "maxLength" : 64,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dport" : {
                                                   "description" : "Restrict TCP/UDP destination port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                   "format" : "pve-fw-dport-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "enable" : {
                                                   "description" : "Flag to enable/disable a rule.",
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "icmp-type" : {
                                                   "description" : "Specify icmp-type. Only valid if proto equals 'icmp' or 'icmpv6'/'ipv6-icmp'.",
                                                   "format" : "pve-fw-icmp-type-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "iface" : {
                                                   "description" : "Network interface name. You have to use network configuration key names for VMs and containers ('net\\d+'). Host related rules can use arbitrary strings.",
                                                   "format" : "pve-iface",
                                                   "maxLength" : 20,
                                                   "minLength" : 2,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "log" : {
                                                   "description" : "Log level for firewall rule.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "macro" : {
                                                   "description" : "Use predefined standard macro.",
                                                   "maxLength" : 128,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "pos" : {
                                                   "description" : "Update rule at position <pos>.",
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "proto" : {
                                                   "description" : "IP protocol. You can use protocol names ('tcp'/'udp') or simple numbers, as defined in '/etc/protocols'.",
                                                   "format" : "pve-fw-protocol-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "source" : {
                                                   "description" : "Restrict packet source address. This can refer to a single IP address, an IP set ('+ipsetname') or an IP alias definition. You can also specify an address range like '20.34.101.207-201.3.9.99', or a list of IP addresses and networks (entries are separated by comma). Please do not mix IPv4 and IPv6 addresses inside such lists.",
                                                   "format" : "pve-fw-addr-spec",
                                                   "maxLength" : 512,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "sport" : {
                                                   "description" : "Restrict TCP/UDP source port. You can use service names or simple numbers (0-65535), as defined in '/etc/services'. Port ranges can be specified with '\\d+:\\d+', for example '80:85', and you can use comma separated list to match several ports or ranges.",
                                                   "format" : "pve-fw-sport-spec",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "type" : {
                                                   "description" : "Rule type.",
                                                   "enum" : [
                                                      "in",
                                                      "out",
                                                      "forward",
                                                      "group"
                                                   ],
                                                   "optional" : 0,
                                                   "type" : "string"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Config.Network"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : null,
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       }
                                    },
                                    "leaf" : 0,
                                    "path" : "/nodes/{node}/qemu/{vmid}/firewall/rules",
                                    "text" : "rules"
                                 },
                                 {
                                    "children" : [
                                       {
                                          "info" : {
                                             "DELETE" : {
                                                "allowtoken" : 1,
                                                "description" : "Remove IP or Network alias.",
                                                "method" : "DELETE",
                                                "name" : "remove_alias",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "digest" : {
                                                         "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                         "maxLength" : 64,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "name" : {
                                                         "description" : "Alias name.",
                                                         "maxLength" : 64,
                                                         "minLength" : 2,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Config.Network"
                                                      ]
                                                   ]
                                                },
                                                "protected" : 1,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             },
                                             "GET" : {
                                                "allowtoken" : 1,
                                                "description" : "Read alias.",
                                                "method" : "GET",
                                                "name" : "read_alias",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "name" : {
                                                         "description" : "Alias name.",
                                                         "maxLength" : 64,
                                                         "minLength" : 2,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Audit"
                                                      ]
                                                   ]
                                                },
                                                "returns" : {
                                                   "type" : "object"
                                                }
                                             },
                                             "PUT" : {
                                                "allowtoken" : 1,
                                                "description" : "Update IP or Network alias.",
                                                "method" : "PUT",
                                                "name" : "update_alias",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "cidr" : {
                                                         "description" : "Network/IP specification in CIDR format.",
                                                         "format" : "IPorCIDR",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "comment" : {
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "digest" : {
                                                         "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                         "maxLength" : 64,
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "name" : {
                                                         "description" : "Alias name.",
                                                         "maxLength" : 64,
                                                         "minLength" : 2,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "rename" : {
                                                         "description" : "Rename an existing alias.",
                                                         "maxLength" : 64,
                                                         "minLength" : 2,
                                                         "optional" : 1,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Config.Network"
                                                      ]
                                                   ]
                                                },
                                                "protected" : 1,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             }
                                          },
                                          "leaf" : 1,
                                          "path" : "/nodes/{node}/qemu/{vmid}/firewall/aliases/{name}",
                                          "text" : "{name}"
                                       }
                                    ],
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "List aliases",
                                          "method" : "GET",
                                          "name" : "get_aliases",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Audit"
                                                ]
                                             ]
                                          },
                                          "returns" : {
                                             "items" : {
                                                "properties" : {
                                                   "cidr" : {
                                                      "type" : "string"
                                                   },
                                                   "comment" : {
                                                      "optional" : 1,
                                                      "type" : "string"
                                                   },
                                                   "digest" : {
                                                      "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                      "maxLength" : 64,
                                                      "optional" : 0,
                                                      "type" : "string"
                                                   },
                                                   "name" : {
                                                      "type" : "string"
                                                   }
                                                },
                                                "type" : "object"
                                             },
                                             "links" : [
                                                {
                                                   "href" : "{name}",
                                                   "rel" : "child"
                                                }
                                             ],
                                             "type" : "array"
                                          }
                                       },
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Create IP or Network Alias.",
                                          "method" : "POST",
                                          "name" : "create_alias",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "cidr" : {
                                                   "description" : "Network/IP specification in CIDR format.",
                                                   "format" : "IPorCIDR",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "comment" : {
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "name" : {
                                                   "description" : "Alias name.",
                                                   "maxLength" : 64,
                                                   "minLength" : 2,
                                                   "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                   "type" : "string"
                                                },
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Config.Network"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       }
                                    },
                                    "leaf" : 0,
                                    "path" : "/nodes/{node}/qemu/{vmid}/firewall/aliases",
                                    "text" : "aliases"
                                 },
                                 {
                                    "children" : [
                                       {
                                          "children" : [
                                             {
                                                "info" : {
                                                   "DELETE" : {
                                                      "allowtoken" : 1,
                                                      "description" : "Remove IP or Network from IPSet.",
                                                      "method" : "DELETE",
                                                      "name" : "remove_ip",
                                                      "parameters" : {
                                                         "additionalProperties" : 0,
                                                         "properties" : {
                                                            "cidr" : {
                                                               "description" : "Network/IP specification in CIDR format.",
                                                               "format" : "IPorCIDRorAlias",
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "digest" : {
                                                               "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                               "maxLength" : 64,
                                                               "optional" : 1,
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "name" : {
                                                               "description" : "IP set name.",
                                                               "maxLength" : 64,
                                                               "minLength" : 2,
                                                               "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                               "type" : "string"
                                                            },
                                                            "node" : {
                                                               "description" : "The cluster node name.",
                                                               "format" : "pve-node",
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "vmid" : {
                                                               "description" : "The (unique) ID of the VM.",
                                                               "format" : "pve-vmid",
                                                               "maximum" : 999999999,
                                                               "minimum" : 100,
                                                               "type" : "integer",
                                                               "typetext" : "<integer> (100 - 999999999)"
                                                            }
                                                         }
                                                      },
                                                      "permissions" : {
                                                         "check" : [
                                                            "perm",
                                                            "/vms/{vmid}",
                                                            [
                                                               "VM.Config.Network"
                                                            ]
                                                         ]
                                                      },
                                                      "protected" : 1,
                                                      "returns" : {
                                                         "type" : "null"
                                                      }
                                                   },
                                                   "GET" : {
                                                      "allowtoken" : 1,
                                                      "description" : "Read IP or Network settings from IPSet.",
                                                      "method" : "GET",
                                                      "name" : "read_ip",
                                                      "parameters" : {
                                                         "additionalProperties" : 0,
                                                         "properties" : {
                                                            "cidr" : {
                                                               "description" : "Network/IP specification in CIDR format.",
                                                               "format" : "IPorCIDRorAlias",
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "name" : {
                                                               "description" : "IP set name.",
                                                               "maxLength" : 64,
                                                               "minLength" : 2,
                                                               "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                               "type" : "string"
                                                            },
                                                            "node" : {
                                                               "description" : "The cluster node name.",
                                                               "format" : "pve-node",
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "vmid" : {
                                                               "description" : "The (unique) ID of the VM.",
                                                               "format" : "pve-vmid",
                                                               "maximum" : 999999999,
                                                               "minimum" : 100,
                                                               "type" : "integer",
                                                               "typetext" : "<integer> (100 - 999999999)"
                                                            }
                                                         }
                                                      },
                                                      "permissions" : {
                                                         "check" : [
                                                            "perm",
                                                            "/vms/{vmid}",
                                                            [
                                                               "VM.Audit"
                                                            ]
                                                         ]
                                                      },
                                                      "protected" : 1,
                                                      "returns" : {
                                                         "type" : "object"
                                                      }
                                                   },
                                                   "PUT" : {
                                                      "allowtoken" : 1,
                                                      "description" : "Update IP or Network settings",
                                                      "method" : "PUT",
                                                      "name" : "update_ip",
                                                      "parameters" : {
                                                         "additionalProperties" : 0,
                                                         "properties" : {
                                                            "cidr" : {
                                                               "description" : "Network/IP specification in CIDR format.",
                                                               "format" : "IPorCIDRorAlias",
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "comment" : {
                                                               "optional" : 1,
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "digest" : {
                                                               "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                               "maxLength" : 64,
                                                               "optional" : 1,
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "name" : {
                                                               "description" : "IP set name.",
                                                               "maxLength" : 64,
                                                               "minLength" : 2,
                                                               "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                               "type" : "string"
                                                            },
                                                            "node" : {
                                                               "description" : "The cluster node name.",
                                                               "format" : "pve-node",
                                                               "type" : "string",
                                                               "typetext" : "<string>"
                                                            },
                                                            "nomatch" : {
                                                               "optional" : 1,
                                                               "type" : "boolean",
                                                               "typetext" : "<boolean>"
                                                            },
                                                            "vmid" : {
                                                               "description" : "The (unique) ID of the VM.",
                                                               "format" : "pve-vmid",
                                                               "maximum" : 999999999,
                                                               "minimum" : 100,
                                                               "type" : "integer",
                                                               "typetext" : "<integer> (100 - 999999999)"
                                                            }
                                                         }
                                                      },
                                                      "permissions" : {
                                                         "check" : [
                                                            "perm",
                                                            "/vms/{vmid}",
                                                            [
                                                               "VM.Config.Network"
                                                            ]
                                                         ]
                                                      },
                                                      "protected" : 1,
                                                      "returns" : {
                                                         "type" : "null"
                                                      }
                                                   }
                                                },
                                                "leaf" : 1,
                                                "path" : "/nodes/{node}/qemu/{vmid}/firewall/ipset/{name}/{cidr}",
                                                "text" : "{cidr}"
                                             }
                                          ],
                                          "info" : {
                                             "DELETE" : {
                                                "allowtoken" : 1,
                                                "description" : "Delete IPSet",
                                                "method" : "DELETE",
                                                "name" : "delete_ipset",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "force" : {
                                                         "description" : "Delete all members of the IPSet, if there are any.",
                                                         "optional" : 1,
                                                         "type" : "boolean",
                                                         "typetext" : "<boolean>"
                                                      },
                                                      "name" : {
                                                         "description" : "IP set name.",
                                                         "maxLength" : 64,
                                                         "minLength" : 2,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Config.Network"
                                                      ]
                                                   ]
                                                },
                                                "protected" : 1,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             },
                                             "GET" : {
                                                "allowtoken" : 1,
                                                "description" : "List IPSet content",
                                                "method" : "GET",
                                                "name" : "get_ipset",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "name" : {
                                                         "description" : "IP set name.",
                                                         "maxLength" : 64,
                                                         "minLength" : 2,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Audit"
                                                      ]
                                                   ]
                                                },
                                                "returns" : {
                                                   "items" : {
                                                      "properties" : {
                                                         "cidr" : {
                                                            "type" : "string"
                                                         },
                                                         "comment" : {
                                                            "optional" : 1,
                                                            "type" : "string"
                                                         },
                                                         "digest" : {
                                                            "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                            "maxLength" : 64,
                                                            "optional" : 0,
                                                            "type" : "string"
                                                         },
                                                         "nomatch" : {
                                                            "optional" : 1,
                                                            "type" : "boolean"
                                                         }
                                                      },
                                                      "type" : "object"
                                                   },
                                                   "links" : [
                                                      {
                                                         "href" : "{cidr}",
                                                         "rel" : "child"
                                                      }
                                                   ],
                                                   "type" : "array"
                                                }
                                             },
                                             "POST" : {
                                                "allowtoken" : 1,
                                                "description" : "Add IP or Network to IPSet.",
                                                "method" : "POST",
                                                "name" : "create_ip",
                                                "parameters" : {
                                                   "additionalProperties" : 0,
                                                   "properties" : {
                                                      "cidr" : {
                                                         "description" : "Network/IP specification in CIDR format.",
                                                         "format" : "IPorCIDRorAlias",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "comment" : {
                                                         "optional" : 1,
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "name" : {
                                                         "description" : "IP set name.",
                                                         "maxLength" : 64,
                                                         "minLength" : 2,
                                                         "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                         "type" : "string"
                                                      },
                                                      "node" : {
                                                         "description" : "The cluster node name.",
                                                         "format" : "pve-node",
                                                         "type" : "string",
                                                         "typetext" : "<string>"
                                                      },
                                                      "nomatch" : {
                                                         "optional" : 1,
                                                         "type" : "boolean",
                                                         "typetext" : "<boolean>"
                                                      },
                                                      "vmid" : {
                                                         "description" : "The (unique) ID of the VM.",
                                                         "format" : "pve-vmid",
                                                         "maximum" : 999999999,
                                                         "minimum" : 100,
                                                         "type" : "integer",
                                                         "typetext" : "<integer> (100 - 999999999)"
                                                      }
                                                   }
                                                },
                                                "permissions" : {
                                                   "check" : [
                                                      "perm",
                                                      "/vms/{vmid}",
                                                      [
                                                         "VM.Config.Network"
                                                      ]
                                                   ]
                                                },
                                                "protected" : 1,
                                                "returns" : {
                                                   "type" : "null"
                                                }
                                             }
                                          },
                                          "leaf" : 0,
                                          "path" : "/nodes/{node}/qemu/{vmid}/firewall/ipset/{name}",
                                          "text" : "{name}"
                                       }
                                    ],
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "List IPSets",
                                          "method" : "GET",
                                          "name" : "ipset_index",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Audit"
                                                ]
                                             ]
                                          },
                                          "returns" : {
                                             "items" : {
                                                "properties" : {
                                                   "comment" : {
                                                      "optional" : 1,
                                                      "type" : "string"
                                                   },
                                                   "digest" : {
                                                      "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                      "maxLength" : 64,
                                                      "optional" : 0,
                                                      "type" : "string"
                                                   },
                                                   "name" : {
                                                      "description" : "IP set name.",
                                                      "maxLength" : 64,
                                                      "minLength" : 2,
                                                      "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                      "type" : "string"
                                                   }
                                                },
                                                "type" : "object"
                                             },
                                             "links" : [
                                                {
                                                   "href" : "{name}",
                                                   "rel" : "child"
                                                }
                                             ],
                                             "type" : "array"
                                          }
                                       },
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Create new IPSet",
                                          "method" : "POST",
                                          "name" : "create_ipset",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "comment" : {
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "digest" : {
                                                   "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                   "maxLength" : 64,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "name" : {
                                                   "description" : "IP set name.",
                                                   "maxLength" : 64,
                                                   "minLength" : 2,
                                                   "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                   "type" : "string"
                                                },
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "rename" : {
                                                   "description" : "Rename an existing IPSet. You can set 'rename' to the same value as 'name' to update the 'comment' of an existing IPSet.",
                                                   "maxLength" : 64,
                                                   "minLength" : 2,
                                                   "optional" : 1,
                                                   "pattern" : "[A-Za-z][A-Za-z0-9\\-\\_]+",
                                                   "type" : "string"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Config.Network"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       }
                                    },
                                    "leaf" : 0,
                                    "path" : "/nodes/{node}/qemu/{vmid}/firewall/ipset",
                                    "text" : "ipset"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Get VM firewall options.",
                                          "method" : "GET",
                                          "name" : "get_options",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Audit"
                                                ]
                                             ]
                                          },
                                          "proxyto" : "node",
                                          "returns" : {
                                             "properties" : {
                                                "dhcp" : {
                                                   "default" : 0,
                                                   "description" : "Enable DHCP.",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "enable" : {
                                                   "default" : 0,
                                                   "description" : "Enable/disable firewall rules.",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "ipfilter" : {
                                                   "description" : "Enable default IP filters. This is equivalent to adding an empty ipfilter-net<id> ipset for every interface. Such ipsets implicitly contain sane default restrictions such as restricting IPv6 link local addresses to the one derived from the interface's MAC address. For containers the configured IP addresses will be implicitly added.",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "log_level_in" : {
                                                   "description" : "Log level for incoming traffic.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "log_level_out" : {
                                                   "description" : "Log level for outgoing traffic.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "macfilter" : {
                                                   "default" : 1,
                                                   "description" : "Enable/disable MAC address filter.",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "ndp" : {
                                                   "default" : 0,
                                                   "description" : "Enable NDP (Neighbor Discovery Protocol).",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "policy_in" : {
                                                   "description" : "Input policy.",
                                                   "enum" : [
                                                      "ACCEPT",
                                                      "REJECT",
                                                      "DROP"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "policy_out" : {
                                                   "description" : "Output policy.",
                                                   "enum" : [
                                                      "ACCEPT",
                                                      "REJECT",
                                                      "DROP"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "radv" : {
                                                   "description" : "Allow sending Router Advertisement.",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                }
                                             },
                                             "type" : "object"
                                          }
                                       },
                                       "PUT" : {
                                          "allowtoken" : 1,
                                          "description" : "Set Firewall options.",
                                          "method" : "PUT",
                                          "name" : "set_options",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "delete" : {
                                                   "description" : "A list of settings you want to delete.",
                                                   "format" : "pve-configid-list",
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "dhcp" : {
                                                   "default" : 0,
                                                   "description" : "Enable DHCP.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "digest" : {
                                                   "description" : "Prevent changes if current configuration file has a different digest. This can be used to prevent concurrent modifications.",
                                                   "maxLength" : 64,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "enable" : {
                                                   "default" : 0,
                                                   "description" : "Enable/disable firewall rules.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "ipfilter" : {
                                                   "description" : "Enable default IP filters. This is equivalent to adding an empty ipfilter-net<id> ipset for every interface. Such ipsets implicitly contain sane default restrictions such as restricting IPv6 link local addresses to the one derived from the interface's MAC address. For containers the configured IP addresses will be implicitly added.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "log_level_in" : {
                                                   "description" : "Log level for incoming traffic.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "log_level_out" : {
                                                   "description" : "Log level for outgoing traffic.",
                                                   "enum" : [
                                                      "emerg",
                                                      "alert",
                                                      "crit",
                                                      "err",
                                                      "warning",
                                                      "notice",
                                                      "info",
                                                      "debug",
                                                      "nolog"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "macfilter" : {
                                                   "default" : 1,
                                                   "description" : "Enable/disable MAC address filter.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "ndp" : {
                                                   "default" : 0,
                                                   "description" : "Enable NDP (Neighbor Discovery Protocol).",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "policy_in" : {
                                                   "description" : "Input policy.",
                                                   "enum" : [
                                                      "ACCEPT",
                                                      "REJECT",
                                                      "DROP"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "policy_out" : {
                                                   "description" : "Output policy.",
                                                   "enum" : [
                                                      "ACCEPT",
                                                      "REJECT",
                                                      "DROP"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "radv" : {
                                                   "description" : "Allow sending Router Advertisement.",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Config.Network"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "type" : "null"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/firewall/options",
                                    "text" : "options"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Read firewall log",
                                          "method" : "GET",
                                          "name" : "log",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "limit" : {
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "since" : {
                                                   "description" : "Display log since this UNIX epoch.",
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "start" : {
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "until" : {
                                                   "description" : "Display log until this UNIX epoch.",
                                                   "minimum" : 0,
                                                   "optional" : 1,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (0 - N)"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Console"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "items" : {
                                                "properties" : {
                                                   "n" : {
                                                      "description" : "Line number",
                                                      "type" : "integer"
                                                   },
                                                   "t" : {
                                                      "description" : "Line text",
                                                      "type" : "string"
                                                   }
                                                },
                                                "type" : "object"
                                             },
                                             "type" : "array"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/firewall/log",
                                    "text" : "log"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Lists possible IPSet/Alias reference which are allowed in source/dest properties.",
                                          "method" : "GET",
                                          "name" : "refs",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "type" : {
                                                   "description" : "Only list references of specified type.",
                                                   "enum" : [
                                                      "alias",
                                                      "ipset"
                                                   ],
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Audit"
                                                ]
                                             ]
                                          },
                                          "returns" : {
                                             "items" : {
                                                "properties" : {
                                                   "comment" : {
                                                      "optional" : 1,
                                                      "type" : "string"
                                                   },
                                                   "name" : {
                                                      "type" : "string"
                                                   },
                                                   "ref" : {
                                                      "type" : "string"
                                                   },
                                                   "scope" : {
                                                      "type" : "string"
                                                   },
                                                   "type" : {
                                                      "enum" : [
                                                         "alias",
                                                         "ipset"
                                                      ],
                                                      "type" : "string"
                                                   }
                                                },
                                                "type" : "object"
                                             },
                                             "type" : "array"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/firewall/refs",
                                    "text" : "refs"
                                 }
                              ],
                              "info" : {
                                 "GET" : {
                                    "allowtoken" : 1,
                                    "description" : "Directory index.",
                                    "method" : "GET",
                                    "name" : "index",
                                    "parameters" : {
                                       "additionalProperties" : 0,
                                       "properties" : {
                                          "node" : {
                                             "description" : "The cluster node name.",
                                             "format" : "pve-node",
                                             "type" : "string",
                                             "typetext" : "<string>"
                                          },
                                          "vmid" : {
                                             "description" : "The (unique) ID of the VM.",
                                             "format" : "pve-vmid",
                                             "maximum" : 999999999,
                                             "minimum" : 100,
                                             "type" : "integer",
                                             "typetext" : "<integer> (100 - 999999999)"
                                          }
                                       }
                                    },
                                    "permissions" : {
                                       "user" : "all"
                                    },
                                    "returns" : {
                                       "items" : {
                                          "properties" : {},
                                          "type" : "object"
                                       },
                                       "links" : [
                                          {
                                             "href" : "{name}",
                                             "rel" : "child"
                                          }
                                       ],
                                       "type" : "array"
                                    }
                                 }
                              },
                              "leaf" : 0,
                              "path" : "/nodes/{node}/qemu/{vmid}/firewall",
                              "text" : "firewall"
                           },
                           {
                              "children" : [
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute fsfreeze-freeze.",
                                          "method" : "POST",
                                          "name" : "fsfreeze-freeze",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/fsfreeze-freeze",
                                    "text" : "fsfreeze-freeze"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute fsfreeze-status.",
                                          "method" : "POST",
                                          "name" : "fsfreeze-status",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/fsfreeze-status",
                                    "text" : "fsfreeze-status"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute fsfreeze-thaw.",
                                          "method" : "POST",
                                          "name" : "fsfreeze-thaw",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/fsfreeze-thaw",
                                    "text" : "fsfreeze-thaw"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute fstrim.",
                                          "method" : "POST",
                                          "name" : "fstrim",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/fstrim",
                                    "text" : "fstrim"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-fsinfo.",
                                          "method" : "GET",
                                          "name" : "get-fsinfo",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-fsinfo",
                                    "text" : "get-fsinfo"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-host-name.",
                                          "method" : "GET",
                                          "name" : "get-host-name",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-host-name",
                                    "text" : "get-host-name"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-memory-block-info.",
                                          "method" : "GET",
                                          "name" : "get-memory-block-info",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-memory-block-info",
                                    "text" : "get-memory-block-info"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-memory-blocks.",
                                          "method" : "GET",
                                          "name" : "get-memory-blocks",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-memory-blocks",
                                    "text" : "get-memory-blocks"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-osinfo.",
                                          "method" : "GET",
                                          "name" : "get-osinfo",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-osinfo",
                                    "text" : "get-osinfo"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-time.",
                                          "method" : "GET",
                                          "name" : "get-time",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-time",
                                    "text" : "get-time"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-timezone.",
                                          "method" : "GET",
                                          "name" : "get-timezone",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-timezone",
                                    "text" : "get-timezone"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-users.",
                                          "method" : "GET",
                                          "name" : "get-users",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-users",
                                    "text" : "get-users"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute get-vcpus.",
                                          "method" : "GET",
                                          "name" : "get-vcpus",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/get-vcpus",
                                    "text" : "get-vcpus"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute info.",
                                          "method" : "GET",
                                          "name" : "info",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/info",
                                    "text" : "info"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute network-get-interfaces.",
                                          "method" : "GET",
                                          "name" : "network-get-interfaces",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/network-get-interfaces",
                                    "text" : "network-get-interfaces"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute ping.",
                                          "method" : "POST",
                                          "name" : "ping",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/ping",
                                    "text" : "ping"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute shutdown.",
                                          "method" : "POST",
                                          "name" : "shutdown",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/shutdown",
                                    "text" : "shutdown"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute suspend-disk.",
                                          "method" : "POST",
                                          "name" : "suspend-disk",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/suspend-disk",
                                    "text" : "suspend-disk"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute suspend-hybrid.",
                                          "method" : "POST",
                                          "name" : "suspend-hybrid",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/suspend-hybrid",
                                    "text" : "suspend-hybrid"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Execute suspend-ram.",
                                          "method" : "POST",
                                          "name" : "suspend-ram",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/suspend-ram",
                                    "text" : "suspend-ram"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Sets the password for the given user to the given password",
                                          "method" : "POST",
                                          "name" : "set-user-password",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "crypted" : {
                                                   "default" : 0,
                                                   "description" : "set to 1 if the password has already been passed through crypt()",
                                                   "optional" : 1,
                                                   "type" : "boolean",
                                                   "typetext" : "<boolean>"
                                                },
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "password" : {
                                                   "description" : "The new password.",
                                                   "maxLength" : 1024,
                                                   "minLength" : 5,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "username" : {
                                                   "description" : "The user to set the password for.",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "description" : "Returns an object with a single `result` property.",
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/set-user-password",
                                    "text" : "set-user-password"
                                 },
                                 {
                                    "info" : {
                                       "POST" : {
                                          "allowtoken" : 1,
                                          "description" : "Executes the given command in the vm via the guest-agent and returns an object with the pid.",
                                          "method" : "POST",
                                          "name" : "exec",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "command" : {
                                                   "description" : "The command as a list of program + arguments.",
                                                   "items" : {
                                                      "description" : "A single part of the program + arguments.",
                                                      "format" : "string"
                                                   },
                                                   "type" : "array",
                                                   "typetext" : "<array>"
                                                },
                                                "input-data" : {
                                                   "description" : "Data to pass as 'input-data' to the guest. Usually treated as STDIN to 'command'.",
                                                   "maxLength" : 65536,
                                                   "optional" : 1,
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "properties" : {
                                                "pid" : {
                                                   "description" : "The PID of the process started by the guest-agent.",
                                                   "type" : "integer"
                                                }
                                             },
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/agent/exec",
                                    "text" : "exec"
                                 },
                                 {
                                    "info" : {
                                       "GET" : {
                                          "allowtoken" : 1,
                                          "description" : "Gets the status of the given pid started by the guest-agent",
                                          "method" : "GET",
                                          "name" : "exec-status",
                                          "parameters" : {
                                             "additionalProperties" : 0,
                                             "properties" : {
                                                "node" : {
                                                   "description" : "The cluster node name.",
                                                   "format" : "pve-node",
                                                   "type" : "string",
                                                   "typetext" : "<string>"
                                                },
                                                "pid" : {
                                                   "description" : "The PID to query",
                                                   "type" : "integer",
                                                   "typetext" : "<integer>"
                                                },
                                                "vmid" : {
                                                   "description" : "The (unique) ID of the VM.",
                                                   "format" : "pve-vmid",
                                                   "maximum" : 999999999,
                                                   "minimum" : 100,
                                                   "type" : "integer",
                                                   "typetext" : "<integer> (100 - 999999999)"
                                                }
                                             }
                                          },
                                          "permissions" : {
                                             "check" : [
                                                "perm",
                                                "/vms/{vmid}",
                                                [
                                                   "VM.Monitor"
                                                ]
                                             ]
                                          },
                                          "protected" : 1,
                                          "proxyto" : "node",
                                          "returns" : {
                                             "properties" : {
                                                "err-data" : {
                                                   "description" : "stderr of the process",
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "err-truncated" : {
                                                   "description" : "true if stderr was not fully captured",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "exitcode" : {
                                                   "description" : "process exit code if it was normally terminated.",
                                                   "optional" : 1,
                                                   "type" : "integer"
                                                },
                                                "exited" : {
                                                   "description" : "Tells if the given command has exited yet.",
                                                   "type" : "boolean"
                                                },
                                                "out-data" : {
                                                   "description" : "stdout of the process",
                                                   "optional" : 1,
                                                   "type" : "string"
                                                },
                                                "out-truncated" : {
                                                   "description" : "true if stdout was not fully captured",
                                                   "optional" : 1,
                                                   "type" : "boolean"
                                                },
                                                "signal" : {
                                                   "description" : "signal number or exception code if the process was abnormally terminated.",
                                                   "optional" : 1,
                                                   "type" : "integer"
                                                }
                                             },
                                             "type" : "object"
                                          }
                                       }
                                    },
                                    "leaf" : 1,
                                    "path" : "/nodes/{node}/qemu/{vmid}/