/**
 * Georgian translation
 * By Ekaterine Papava (utf-8 encoding)
 * 25 July 2023
 */
Ext.onReady(function() {

    if (Ext.Date) {
        Ext.Date.defaultFormat = 'd.m.Y';

        Ext.Date.monthNames = ["იანვარი", "თებერვალი", "მარტი", "აპრილი", "მაისი", "ივნისი", "ივლისი", "აგვისტო", "სექტემბერი", "ოქტომბერი", "ნოემბერი", "დეკემბერი"];

        Ext.Date.shortMonthNames = ["იან", "თებ", "მარ", "აპრ", "მაი", "ივნ", "ივლ", "აგვ", "სექტ", "ოქტ", "ნოე", "დეკ"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.shortMonthNames[month];
        };

        Ext.Date.monthNumbers = {
            'იან': 0,
            'თებ': 1,
            'მარ': 2,
            'აპრ': 3,
            'მაი': 4,
            'ივნ': 5,
            'ივლ': 6,
            'აგვ': 7,
            'სექტ': 8,
            'ოქტ': 9,
            'ნოე': 10,
            'დეკ': 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["კვირა", "ორშაბათი", "სამშაბათი", "ოთხშაბათი", "ხუთშაბათი", "პარასკევი", "შაბათი"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }

    if (Ext.util && Ext.util.Format) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: ' ',
            decimalSeparator: ',',
            currencySign: '\u20BE',
            // Georgian Lari
            dateFormat: 'd.m.Y'
        });
    }
});

Ext.define("Ext.locale.ka.view.View", {
    override: "Ext.view.View",
    emptyText: ""
});

Ext.define("Ext.locale.ka.grid.plugin.DragDrop", {
    override: "Ext.grid.plugin.DragDrop",
    dragText: "{0} მონიშნული სტრიქონი"
});

Ext.define("Ext.locale.ka.tab.Tab", {
    override: "Ext.tab.Tab",
    closeText: "ამ ჩანართის დახურვა"
});

Ext.define("Ext.locale.ka.form.field.Base", {
    override: "Ext.form.field.Base",
    invalidText: "ამ ველის მნიშვნელობა არასწორია"
});

// changing the msg text below will affect the LoadMask
Ext.define("Ext.locale.ka.view.AbstractView", {
    override: "Ext.view.AbstractView",
    loadingText: "ჩატვირთვა..."
});

Ext.define("Ext.locale.ka.picker.Date", {
    override: "Ext.picker.Date",
    todayText: "დღეს",
    minText: "ეს თარიღი მინიმალურ თარიღამდეა",
    maxText: "ეს თარიღი მაქსიმალური თარიღის შემდეგაა",
    disabledDaysText: "მიუწვდომელია",
    disabledDatesText: "მიუწვდომელია",
    nextText: 'შემდეგი თვე (Control+მარჯვნივ)',
    prevText: 'წინა თვე (Control+მარცხნივ)',
    monthYearText: 'თვის არჩევა (წლის არჩევა: Control+ზემოთ/ქვემოთ)',
    todayTip: "{0} (გამოტოვება)",
    format: "d.m.y",
    startDay: 1
});

Ext.define("Ext.locale.ka.picker.Month", {
    override: "Ext.picker.Month",
    okText: "დიახ",
    cancelText: "გაუქმება"
});

Ext.define("Ext.locale.ka.toolbar.Paging", {
    override: "Ext.PagingToolbar",
    beforePageText: "გვერდი",
    afterPageText: "{0}-დან",
    firstText: "პირველი გვერდი",
    prevText: "წინა გვერდი",
    nextText: "შემდეგი გვერდი",
    lastText: "ბოლო გვერდი",
    refreshText: "განახლება",
    displayMsg: "ნაჩვენებია {0} ჩანაწერი {1}-დან. სულ {2}",
    emptyMsg: 'საჩვენებელი მონაცემების გარეშე'
});

Ext.define("Ext.locale.ka.form.field.Text", {
    override: "Ext.form.field.Text",
    minLengthText: "ამ ველის მინიმალური სიგრძეა {0}",
    maxLengthText: "ამ ველის მაქსიმალური სიგრძეა {0}",
    blankText: "ამ ველის შევსება აუცილებელია",
    regexText: "",
    emptyText: null
});

Ext.define("Ext.locale.ka.form.field.Number", {
    override: "Ext.form.field.Number",
    minText: "ამ ველის მნიშვნელობა {0}-ზე ნაკლები ვერ იქნება",
    maxText: "ამ ველის მნიშვნელობა {0}-ზე მეტი ვერ იქნება",
    nanText: "{0} რიცხვი არაა",
    negativeText: "მნიშვნელობა უარყოფითი ვერ იქნება"
});

Ext.define("Ext.locale.ka.form.field.Date", {
    override: "Ext.form.field.Date",
    disabledDaysText: "ხელმისაწვდომი არაა",
    disabledDatesText: "ხელმისაწვდომი არაა",
    minText: "ამ ველის თარიღი {0}-ზე ადრე ვერ იქნება",
    maxText: "ამ ველის თარიღი {0}-ის შემდეგ ვერ იქნება",
    invalidText: "{0} თარიღი სწორი არაა. თარიღის სწორი ფორმატია {1}",
    format: "d.m.y",
    altFormats: "d.m.y|d/m/Y|d-m-y|d-m-Y|d/m|d-m|dm|dmy|dmY|d|Y-m-d"
});

Ext.define("Ext.locale.ka.form.field.ComboBox", {
    override: "Ext.form.field.ComboBox",
    valueNotFoundText: undefined
}, function() {
    Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
        loadingText: "იტვირთება..."
    });
});

Ext.define("Ext.locale.ka.form.field.VTypes", {
    override: "Ext.form.field.VTypes",
    emailText: 'ეს ველი უნდა შეიცავდეს ელფოსტის მისამართს ფორმატში "user@example.com"',
    urlText: 'ეს ველი უნდა შეიცავდეს ბმულს ფორმატში "http:/' + '/www.example.com"',
    alphaText: 'ეს ველი მხოლოდ ლათინურ ასოებს და ქვედატირეს "_" უნდა შეიცავდეს',
    alphanumText: 'ეს ველი მხოლოდ ლათინურ ასოებს, ციფრებს და ქვედატირეს "_" უნდა შეიცავდეს'
});

Ext.define("Ext.locale.ka.form.field.HtmlEditor", {
    override: "Ext.form.field.HtmlEditor",
    createLinkText: 'შეიყვანეთ მისამართი:'
}, function() {
    Ext.apply(Ext.form.field.HtmlEditor.prototype, {
        buttonTips: {
            bold: {
                title: 'ნახევრადსქელი (Ctrl+B)',
                text: 'მონიშნული ტექსტის ნახევრად გასქელება.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            italic: {
                title: 'კურსივი (Ctrl+I)',
                text: 'მონიშნული ტექსტის კურსივად გადაკეთება.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            underline: {
                title: 'ხაზგასმული (Ctrl+U)',
                text: 'მონიშნული ტექსტისთვის ხაზის გასმა.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            increasefontsize: {
                title: 'ზომის გაზრდა',
                text: 'ფონტის ზომის გაზრდა.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            decreasefontsize: {
                title: 'ზომის შემცირება',
                text: 'ფონტის ზომის შემცირება.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            backcolor: {
                title: 'ჩასხმა',
                text: 'მონიშნული ტექსტის ან აბზაცის ფონის ფერის შეცვლა.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            forecolor: {
                title: 'ტექსტის ფერი',
                text: 'ტექსტის ფერის შეცვლა.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            justifyleft: {
                title: 'ტექსტის სწორება მარცხენა მხარეს',
                text: 'ტექსტის სწორება მარცხენა მხარეს.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            justifycenter: {
                title: 'ცენტრზე',
                text: 'ტექსტის ცენტრში სწორება.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            justifyright: {
                title: 'ტექსტის სწორება მარჯვენა მხარეს',
                text: 'ტექსტის სწორება მარჯვენა მხარეს.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            insertunorderedlist: {
                title: 'მარკერები',
                text: 'მარკერებიანი სიის დაწყება.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            insertorderedlist: {
                title: 'ჩამონათვალი',
                text: 'ჩამონათვლის დაწყება.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            createlink: {
                title: 'ჰიპერბმულის შექმნა',
                text: 'მონიშნული ტექსტიდან ჰიპერბმულის შექმნა.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            },
            sourceedit: {
                title: 'საწყისი კოდი',
                text: 'საწყის კოდზე გადართვა.',
                cls: Ext.baseCSSPrefix + 'html-editor-tip'
            }
        }
    });
});

Ext.define("Ext.locale.ka.form.Basic", {
    override: "Ext.form.Basic",
    waitTitle: "მოითმინეთ..."
});

Ext.define("Ext.locale.ka.grid.header.Container", {
    override: "Ext.grid.header.Container",
    sortAscText: "ზრდადობით დალაგება",
    sortDescText: "კლებადობით დალაგება",
    lockText: "სვეტის მიმაგრება",
    unlockText: "სვეტის მოხსნა",
    columnsText: "სვეტები"
});

Ext.define("Ext.locale.ka.grid.GroupingFeature", {
    override: "Ext.grid.feature.Grouping",
    emptyGroupText: '(ცარიელია)',
    groupByText: 'ამ ველით დაჯგუფება',
    showGroupsText: 'ჯგუფებად ჩვენება'
});

Ext.define("Ext.locale.ka.grid.PropertyColumnModel", {
    override: "Ext.grid.PropertyColumnModel",
    nameText: "სახელი",
    valueText: "მნიშვნელობა",
    dateFormat: "d.m.Y"
});

Ext.define("Ext.locale.ka.window.MessageBox", {
    override: "Ext.window.MessageBox",
    buttonText: {
        ok: "დიახ",
        cancel: "გაუქმება",
        yes: "კი",
        no: "არა"
    }
});

Ext.define("Ext.locale.ka.form.field.File", {
    override: "Ext.form.field.File",
    buttonText: "დათვალიერება..."
});

// This is needed until we can refactor all of the locales into individual files
Ext.define("Ext.locale.ka.Component", {
    override: "Ext.Component"
});
